"use strict";

const FiatCurrencies = [
  {
    id: "AED",
    name: "United Arab Emirates Dirham",
    symbol: "د.إ",
    precision: 2,
  },
  { id: "AFN", name: "Afghan Afghani", symbol: "؋", precision: 2 },
  { id: "ALL", name: "Albanian Lek", symbol: "L", precision: 2 },
  { id: "AMD", name: "Armenian Dram", symbol: "֏", precision: 2 },
  {
    id: "ANG",
    name: "Netherlands Antillean Guilder",
    symbol: "ƒ",
    precision: 2,
  },
  { id: "AOA", name: "Angolan Kwanza", symbol: "Kz", precision: 2 },
  { id: "ARS", name: "Argentine Peso", symbol: "$", precision: 2 },
  { id: "AUD", name: "Australian Dollar", symbol: "$", precision: 2 },
  { id: "AWG", name: "Aruban Florin", symbol: "ƒ", precision: 2 },
  { id: "AZN", name: "Azerbaijani Manat", symbol: "₼", precision: 2 },
  {
    id: "BAM",
    name: "Bosnia-Herzegovina Convertible Mark",
    symbol: "KM",
    precision: 2,
  },
  { id: "BBD", name: "Barbadian Dollar", symbol: "$", precision: 2 },
  { id: "BDT", name: "Bangladeshi Taka", symbol: "৳", precision: 2 },
  { id: "BGN", name: "Bulgarian Lev", symbol: "лв", precision: 2 },
  { id: "BHD", name: "Bahraini Dinar", symbol: ".د.ب", precision: 3 },
  { id: "BIF", name: "Burundian Franc", symbol: "FBu", precision: 0 },
  { id: "BMD", name: "Bermudian Dollar", symbol: "$", precision: 2 },
  { id: "BND", name: "Brunei Dollar", symbol: "$", precision: 2 },
  { id: "BOB", name: "Bolivian Boliviano", symbol: "Bs.", precision: 2 },
  { id: "BRL", name: "Brazilian Real", symbol: "R$", precision: 2 },
  { id: "BSD", name: "Bahamian Dollar", symbol: "$", precision: 2 },
  { id: "BTN", name: "Bhutanese Ngultrum", symbol: "Nu.", precision: 2 },
  { id: "BWP", name: "Botswanan Pula", symbol: "P", precision: 2 },
  { id: "BYN", name: "New Belarusian Ruble", symbol: "Br", precision: 2 },
  { id: "BZD", name: "Belize Dollar", symbol: "BZ$", precision: 2 },
  { id: "CAD", name: "Canadian Dollar", symbol: "$", precision: 2 },
  { id: "CDF", name: "Congolese Franc", symbol: "FC", precision: 2 },
  { id: "CHF", name: "Swiss Franc", symbol: "Fr", precision: 2 },
  {
    id: "CLF",
    name: "Chilean Unit of Account (UF)",
    symbol: "UF",
    precision: 4,
  },
  { id: "CLP", name: "Chilean Peso", symbol: "$", precision: 0 },
  { id: "CNY", name: "Chinese Yuan", symbol: "¥", precision: 2 },
  { id: "COP", name: "Colombian Peso", symbol: "$", precision: 2 },
  { id: "CRC", name: "Costa Rican Colón", symbol: "₡", precision: 2 },
  {
    id: "CUC",
    name: "Cuban Convertible Peso",
    symbol: "$",
    precision: 2,
  },
  { id: "CUP", name: "Cuban Peso", symbol: "₱", precision: 2 },
  { id: "CVE", name: "Cape Verdean Escudo", symbol: "$", precision: 2 },
  {
    id: "CZK",
    name: "Czech Republic Koruna",
    symbol: "Kč",
    precision: 2,
  },
  { id: "DJF", name: "Djiboutian Franc", symbol: "Fdj", precision: 0 },
  { id: "DKK", name: "Danish Krone", symbol: "kr", precision: 2 },
  { id: "DOP", name: "Dominican Peso", symbol: "RD$", precision: 2 },
  { id: "DZD", name: "Algerian Dinar", symbol: "د.ج", precision: 2 },
  { id: "EGP", name: "Egyptian Pound", symbol: "£", precision: 2 },
  { id: "ERN", name: "Eritrean Nakfa", symbol: "Nfk", precision: 2 },
  { id: "ETB", name: "Ethiopian Birr", symbol: "Br", precision: 2 },
  { id: "EUR", name: "Euro", symbol: "€", precision: 2 },
  { id: "FJD", name: "Fijian Dollar", symbol: "$", precision: 2 },
  {
    id: "FKP",
    name: "Falkland Islands Pound",
    symbol: "£",
    precision: 2,
  },
  {
    id: "GBP",
    name: "British Pound Sterling",
    symbol: "£",
    precision: 2,
  },
  { id: "GEL", name: "Georgian Lari", symbol: "₾", precision: 2 },
  { id: "GGP", name: "Guernsey Pound", symbol: "£", precision: 2 },
  { id: "GHS", name: "Ghanaian Cedi", symbol: "₵", precision: 2 },
  { id: "GIP", name: "Gibraltar Pound", symbol: "£", precision: 2 },
  { id: "GMD", name: "Gambian Dalasi", symbol: "D", precision: 2 },
  { id: "GNF", name: "Guinean Franc", symbol: "FG", precision: 0 },
  { id: "GTQ", name: "Guatemalan Quetzal", symbol: "Q", precision: 2 },
  { id: "GYD", name: "Guyanaese Dollar", symbol: "$", precision: 2 },
  { id: "HKD", name: "Hong Kong Dollar", symbol: "$", precision: 2 },
  { id: "HNL", name: "Honduran Lempira", symbol: "L", precision: 2 },
  { id: "HRK", name: "Croatian Kuna", symbol: "kn", precision: 2 },
  { id: "HTG", name: "Haitian Gourde", symbol: "G", precision: 2 },
  { id: "HUF", name: "Hungarian Forint", symbol: "Ft", precision: 2 },
  { id: "IDR", name: "Indonesian Rupiah", symbol: "Rp", precision: 2 },
  { id: "ILS", name: "Israeli New Sheqel", symbol: "₪", precision: 2 },
  { id: "IMP", name: "Manx pound", symbol: "£", precision: 2 },
  { id: "INR", name: "Indian Rupee", symbol: "₹", precision: 2 },
  { id: "IQD", name: "Iraqi Dinar", symbol: "ع.د", precision: 3 },
  { id: "IRR", name: "Iranian Rial", symbol: "﷼", precision: 2 },
  { id: "ISK", name: "Icelandic Króna", symbol: "kr", precision: 0 },
  { id: "JEP", name: "Jersey Pound", symbol: "£", precision: 2 },
  { id: "JMD", name: "Jamaican Dollar", symbol: "J$", precision: 2 },
  { id: "JOD", name: "Jordanian Dinar", symbol: "د.ا", precision: 3 },
  { id: "JPY", name: "Japanese Yen", symbol: "¥", precision: 0 },
  { id: "KES", name: "Kenyan Shilling", symbol: "Sh", precision: 2 },
  { id: "KGS", name: "Kyrgystani Som", symbol: "с", precision: 2 },
  { id: "KHR", name: "Cambodian Riel", symbol: "៛", precision: 2 },
  { id: "KMF", name: "Comorian Franc", symbol: "CF", precision: 0 },
  { id: "KPW", name: "North Korean Won", symbol: "₩", precision: 2 },
  { id: "KRW", name: "South Korean Won", symbol: "₩", precision: 0 },
  { id: "KWD", name: "Kuwaiti Dinar", symbol: "د.ك", precision: 3 },
  { id: "KYD", name: "Cayman Islands Dollar", symbol: "$", precision: 2 },
  { id: "KZT", name: "Kazakhstani Tenge", symbol: "₸", precision: 2 },
  { id: "LAK", name: "Laotian Kip", symbol: "₭", precision: 2 },
  { id: "LBP", name: "Lebanese Pound", symbol: "ل.ل", precision: 2 },
  { id: "LKR", name: "Sri Lankan Rupee", symbol: "Rs", precision: 2 },
  { id: "LRD", name: "Liberian Dollar", symbol: "$", precision: 2 },
  { id: "LSL", name: "Lesotho Loti", symbol: "L", precision: 2 },
  { id: "LYD", name: "Libyan Dinar", symbol: "ل.د", precision: 3 },
  { id: "MAD", name: "Moroccan Dirham", symbol: "د.م.", precision: 2 },
  { id: "MDL", name: "Moldovan Leu", symbol: "L", precision: 2 },
  { id: "MGA", name: "Malagasy Ariary", symbol: "Ar", precision: 2 },
  { id: "MKD", name: "Macedonian Denar", symbol: "ден", precision: 2 },
  { id: "MMK", name: "Myanma Kyat", symbol: "Ks", precision: 2 },
  { id: "MNT", name: "Mongolian Tugrik", symbol: "₮", precision: 2 },
  { id: "MOP", name: "Macanese Pataca", symbol: "MOP$", precision: 2 },
  { id: "MUR", name: "Mauritian Rupee", symbol: "₨", precision: 2 },
  { id: "MVR", name: "Maldivian Rufiyaa", symbol: "Rf", precision: 2 },
  { id: "MWK", name: "Malawian Kwacha", symbol: "MK", precision: 2 },
  { id: "MXN", name: "Mexican Peso", symbol: "$", precision: 2 },
  { id: "MYR", name: "Malaysian Ringgit", symbol: "RM", precision: 2 },
  { id: "MZN", name: "Mozambican Metical", symbol: "MT", precision: 2 },
  { id: "NAD", name: "Namibian Dollar", symbol: "$", precision: 2 },
  { id: "NGN", name: "Nigerian Naira", symbol: "₦", precision: 2 },
  { id: "NIO", name: "Nicaraguan Córdoba", symbol: "C$", precision: 2 },
  { id: "NOK", name: "Norwegian Krone", symbol: "kr", precision: 2 },
  { id: "NPR", name: "Nepalese Rupee", symbol: "₨", precision: 2 },
  { id: "NZD", name: "New Zealand Dollar", symbol: "$", precision: 2 },
  { id: "OMR", name: "Omani Rial", symbol: "ر.ع.", precision: 3 },
  { id: "PAB", name: "Panamanian Balboa", symbol: "B/.", precision: 2 },
  { id: "PEN", name: "Peruvian Nuevo Sol", symbol: "S/", precision: 2 },
  {
    id: "PGK",
    name: "Papua New Guinean Kina",
    symbol: "K",
    precision: 2,
  },
  { id: "PHP", name: "Philippine Peso", symbol: "₱", precision: 2 },
  { id: "PKR", name: "Pakistani Rupee", symbol: "₨", precision: 2 },
  { id: "PLN", name: "Polish Zloty", symbol: "zł", precision: 2 },
  { id: "PYG", name: "Paraguayan Guarani", symbol: "₲", precision: 0 },
  { id: "QAR", name: "Qatari Rial", symbol: "ر.ق", precision: 2 },
  { id: "RON", name: "Romanian Leu", symbol: "lei", precision: 2 },
  { id: "RSD", name: "Serbian Dinar", symbol: "дин", precision: 2 },

  { id: "RUB", name: "Russian Ruble", symbol: "₽", precision: 2 },
  { id: "RWF", name: "Rwandan Franc", symbol: "FRw", precision: 0 },
  { id: "SAR", name: "Saudi Riyal", symbol: "ر.س", precision: 2 },
  {
    id: "MRU",
    name: "Mauritanian Ouguiya",
    symbol: "UM",
    precision: 2,
  },
  {
    id: "SBD",
    name: "Solomon Islands Dollar",
    symbol: "$",
    precision: 2,
  },
  {
    id: "SCR",
    name: "Seychellois Rupee",
    symbol: "₨",
    precision: 2,
  },
  {
    id: "SDG",
    name: "Sudanese Pound",
    symbol: "£",
    precision: 2,
  },
  {
    id: "SEK",
    name: "Swedish Krona",
    symbol: "kr",
    precision: 2,
  },
  {
    id: "SGD",
    name: "Singapore Dollar",
    symbol: "$",
    precision: 2,
  },
  {
    id: "SHP",
    name: "Saint Helena Pound",
    symbol: "£",
    precision: 2,
  },
  {
    id: "SLL",
    name: "Sierra Leonean Leone",
    symbol: "Le",
    precision: 2,
  },
  {
    id: "SOS",
    name: "Somali Shilling",
    symbol: "Sh",
    precision: 2,
  },
  {
    id: "SRD",
    name: "Surinamese Dollar",
    symbol: "$",
    precision: 2,
  },
  {
    id: "SSP",
    name: "South Sudanese Pound",
    symbol: "£",
    precision: 2,
  },
  {
    id: "STN",
    name: "São Tomé and Príncipe Dobra",
    symbol: "Db",
    precision: 2,
  },
  {
    id: "SYP",
    name: "Syrian Pound",
    symbol: "£",
    precision: 2,
  },
  {
    id: "SZL",
    name: "Swazi Lilangeni",
    symbol: "L",
    precision: 2,
  },
  {
    id: "THB",
    name: "Thai Baht",
    symbol: "฿",
    precision: 2,
  },
  {
    id: "TJS",
    name: "Tajikistani Somoni",
    symbol: "SM",
    precision: 2,
  },
  {
    id: "TMT",
    name: "Turkmenistani Manat",
    symbol: "T",
    precision: 2,
  },
  {
    id: "TND",
    name: "Tunisian Dinar",
    symbol: "د.ت",
    precision: 3,
  },
  {
    id: "TOP",
    name: "Tongan Paʻanga",
    symbol: "T$",
    precision: 2,
  },
  {
    id: "TRY",
    name: "Turkish Lira",
    symbol: "₺",
    precision: 2,
  },
  {
    id: "TTD",
    name: "Trinidad and Tobago Dollar",
    symbol: "TT$",
    precision: 2,
  },
  {
    id: "TWD",
    name: "New Taiwan Dollar",
    symbol: "NT$",
    precision: 2,
  },
  {
    id: "TZS",
    name: "Tanzanian Shilling",
    symbol: "Sh",
    precision: 2,
  },
  {
    id: "UAH",
    name: "Ukrainian Hryvnia",
    symbol: "₴",
    precision: 2,
  },
  {
    id: "UGX",
    name: "Ugandan Shilling",
    symbol: "USh",
    precision: 0,
  },
  { id: "USD", name: "United States Dollar", symbol: "$", precision: 2 },
  { id: "UYU", name: "Uruguayan Peso", symbol: "$U", precision: 2 },
  { id: "UZS", name: "Uzbekistani Som", symbol: "soʻm", precision: 2 },
  {
    id: "VES",
    name: "Venezuelan Bolívar",
    symbol: "Bs.S.",
    precision: 2,
  },
  { id: "VND", name: "Vietnamese Dong", symbol: "₫", precision: 0 },
  { id: "VUV", name: "Vanuatu Vatu", symbol: "VT", precision: 0 },
  { id: "WST", name: "Samoan Tala", symbol: "WS$", precision: 2 },
  {
    id: "XAF",
    name: "Central African CFA Franc",
    symbol: "FCFA",
    precision: 0,
  },
  { id: "XCD", name: "East Caribbean Dollar", symbol: "$", precision: 2 },
  {
    id: "XOF",
    name: "West African CFA Franc",
    symbol: "CFA",
    precision: 0,
  },
  { id: "XPF", name: "CFP Franc", symbol: "₣", precision: 0 },
  { id: "YER", name: "Yemeni Rial", symbol: "﷼", precision: 2 },
  { id: "ZAR", name: "South African Rand", symbol: "R", precision: 2 },
  { id: "ZMW", name: "Zambian Kwacha", symbol: "ZK", precision: 2 },
  { id: "ZWL", name: "Zimbabwean Dollar", symbol: "$", precision: 2 },
];

/** @type {import('sequelize-cli').Migration} */

module.exports = {
  async up(queryInterface, Sequelize) {
    try {
      // Fetch existing currency IDs to compare against
      const existingCurrencies = await queryInterface.sequelize.query(
        "SELECT id FROM currency",
        { type: queryInterface.sequelize.QueryTypes.SELECT }
      );
      const existingIds = new Set(
        existingCurrencies.map((currency) => currency.id)
      );

      // Filter out FiatCurrencies that already exist in the database by id
      const newCurrencies = FiatCurrencies.filter(
        (currency) => !existingIds.has(currency.id)
      ).map((currency) => ({
        ...currency,
        status: false, // Assuming you want to set status: false for new entries
      }));

      // Only insert new currencies that do not exist
      if (newCurrencies.length > 0) {
        await queryInterface.bulkInsert("currency", newCurrencies);
      }
    } catch (error) {
      console.error("Bulk insert error:", error);
      throw error; // Rethrow the error to ensure the migration fails appropriately
    }
  },

  async down(queryInterface, Sequelize) {
    return queryInterface.bulkDelete("currency", null, {});
  },
};
