"use strict";async function generatePowChallenge(e,r){if(r){const e=`pow_rate:${r}`,t=await redis.get(e);if(t&&Number(t)>=MAX_CHALLENGES_PER_MINUTE)throw new Error("Too many challenge requests. Please wait a moment.");await redis.setex(e,60,String(Number(t||0)+1))}const t=cache_1.CacheManager.getInstance(),o=await t.getSetting("powCaptchaDifficulty")||"medium",a=DIFFICULTY_LEVELS[o]||DIFFICULTY_LEVELS.medium,i=Date.now(),n=`${crypto_1.default.randomBytes(32).toString("hex")}:${i}:${e}`,l={challenge:n,difficulty:a,timestamp:i,action:e},c=`pow_challenge:${n}`;await redis.setex(c,Math.floor(CHALLENGE_EXPIRY_MS/1e3),JSON.stringify(l));console_1.logger.debug("POW",`Generated challenge for action: ${e}, difficulty: ${a}`);return{challenge:n,difficulty:a,timestamp:i,expiresIn:CHALLENGE_EXPIRY_MS}}async function verifyPowSolution(e,r){const t=`pow_challenge:${e.challenge}`,o=await redis.get(t);if(!o){console_1.logger.warn("POW","Challenge not found or expired");return{valid:!1,error:"Challenge expired or invalid. Please refresh and try again."}}let a;try{a=JSON.parse(o)}catch(e){console_1.logger.error("POW","Failed to parse stored challenge data");return{valid:!1,error:"Invalid challenge data"}}if(a.action!==r){console_1.logger.warn("POW",`Action mismatch: expected ${r}, got ${a.action}`);return{valid:!1,error:"Challenge action mismatch"}}if(Date.now()-a.timestamp>CHALLENGE_EXPIRY_MS){console_1.logger.warn("POW","Challenge expired");await redis.del(t);return{valid:!1,error:"Challenge expired. Please refresh and try again."}}const i=`${e.challenge}:${e.nonce}`,n=crypto_1.default.createHash("sha256").update(i).digest("hex");if(n!==e.hash){console_1.logger.warn("POW","Hash mismatch");return{valid:!1,error:"Invalid solution hash"}}if(!verifyDifficulty(n,a.difficulty)){console_1.logger.warn("POW",`Difficulty not met: required ${a.difficulty} leading zero bits`);return{valid:!1,error:"Solution does not meet difficulty requirement"}}await redis.del(t);console_1.logger.debug("POW",`Valid solution verified for action: ${r}`);return{valid:!0}}function verifyDifficulty(e,r){var t;return((null===(t=hexToBinary(e).match(/^0*/))||void 0===t?void 0:t[0].length)||0)>=r}function hexToBinary(e){return e.split("").map(e=>parseInt(e,16).toString(2).padStart(4,"0")).join("")}async function isPowCaptchaEnabled(){const e=cache_1.CacheManager.getInstance(),r=await e.getSetting("powCaptchaStatus");return"true"===r||!0===r}async function verifyPowOrThrow(e,r){if(!await isPowCaptchaEnabled())return;if(!e||!e.challenge||void 0===e.nonce||!e.hash)throw new Error("Proof-of-work solution is required");const t=await verifyPowSolution(e,r);if(!t.valid)throw new Error(t.error||"Invalid proof-of-work solution")}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.generatePowChallenge=generatePowChallenge;exports.verifyPowSolution=verifyPowSolution;exports.isPowCaptchaEnabled=isPowCaptchaEnabled;exports.verifyPowOrThrow=verifyPowOrThrow;const crypto_1=__importDefault(require("crypto")),cache_1=require("./cache"),redis_1=require("./redis"),console_1=require("./console"),redis=redis_1.RedisSingleton.getInstance(),DIFFICULTY_LEVELS={low:14,medium:17,high:20},CHALLENGE_EXPIRY_MS=3e5,MAX_CHALLENGES_PER_MINUTE=10;