"use strict";var __createBinding=this&&this.__createBinding||(Object.create?function(i,t,e,n){void 0===n&&(n=e);var o=Object.getOwnPropertyDescriptor(t,e);o&&!("get"in o?!t.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return t[e]}});Object.defineProperty(i,n,o)}:function(i,t,e,n){void 0===n&&(n=e);i[n]=t[e]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(i,t){Object.defineProperty(i,"default",{enumerable:!0,value:t})}:function(i,t){i.default=t}),__importStar=this&&this.__importStar||function(){var i=function(t){i=Object.getOwnPropertyNames||function(i){var t=[];for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[t.length]=e);return t};return i(t)};return function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var n=i(t),o=0;o<n.length;o++)"default"!==n[o]&&__createBinding(e,t,n[o]);__setModuleDefault(e,t);return e}}();Object.defineProperty(exports,"__esModule",{value:!0});exports.FCMProvider=void 0;const admin=__importStar(require("firebase-admin")),BasePushProvider_1=require("./BasePushProvider");class FCMProvider extends BasePushProvider_1.BasePushProvider{constructor(i){super("FCM",i);this.app=null;this.validateConfig()&&this.initializeApp()}loadConfigFromEnv(){var i;return{projectId:process.env.FCM_PROJECT_ID,clientEmail:process.env.FCM_CLIENT_EMAIL,privateKey:null===(i=process.env.FCM_PRIVATE_KEY)||void 0===i?void 0:i.replace(/\\n/g,"\n"),serviceAccountPath:process.env.FCM_SERVICE_ACCOUNT_PATH}}validateConfig(){if(this.config.serviceAccountPath)return!0;if(!this.config.projectId){this.logError("Missing FCM_PROJECT_ID",{});return!1}if(!this.config.clientEmail){this.logError("Missing FCM_CLIENT_EMAIL",{});return!1}if(!this.config.privateKey){this.logError("Missing FCM_PRIVATE_KEY",{});return!1}return!0}initializeApp(){try{if(admin.apps.length>0){this.app=admin.apps[0];this.log("Using existing Firebase app");return}if(this.config.serviceAccountPath){const i=require(this.config.serviceAccountPath);this.app=admin.initializeApp({credential:admin.credential.cert(i)})}else this.app=admin.initializeApp({credential:admin.credential.cert({projectId:this.config.projectId,clientEmail:this.config.clientEmail,privateKey:this.config.privateKey})});this.log("Firebase Admin SDK initialized successfully")}catch(i){this.logError("Failed to initialize Firebase Admin SDK",i);throw i}}async send(i,t){try{if(!this.validateConfig()||!this.app)throw new Error("FCM configuration is invalid or app not initialized");const e=this.filterValidTokens(i.tokens);if(0===e.length)return{success:!1,error:"No valid device tokens provided"};const n=this.buildFCMMessage(i,t);return 1===e.length?await this.sendToDevice(e[0],n):await this.sendMulticast(e,i,t)}catch(i){this.logError("Failed to send push notification",i);return{success:!1,error:i.message||"Failed to send push notification via FCM"}}}async sendToDevice(i,t){try{const e=await admin.messaging().send({token:i,...t});this.log("Push notification sent successfully",{token:i.substring(0,20)+"...",messageId:e});return{success:!0,messageId:`fcm-${e}`,externalId:e}}catch(t){if("messaging/invalid-registration-token"===t.code||"messaging/registration-token-not-registered"===t.code){this.log("Invalid or unregistered token",{token:i});return{success:!1,error:"Invalid device token",metadata:{invalidToken:i,shouldRemove:!0}}}throw t}}async sendMulticast(i,t,e){try{if(!this.app)throw new Error("Firebase app not initialized");const n=this.buildFCMMessage(t,e),o=await admin.messaging().sendEachForMulticast({tokens:i,...n});this.log("Multicast push notification sent",{totalTokens:i.length,successCount:o.successCount,failureCount:o.failureCount});const s=[];o.responses.forEach((t,e)=>{var n,o;t.success||"messaging/invalid-registration-token"!==(null===(n=t.error)||void 0===n?void 0:n.code)&&"messaging/registration-token-not-registered"!==(null===(o=t.error)||void 0===o?void 0:o.code)||s.push(i[e])});return{success:o.successCount>0,messageId:`fcm-multicast-${Date.now()}`,metadata:{totalSent:i.length,successCount:o.successCount,failureCount:o.failureCount,invalidTokens:s}}}catch(i){this.logError("Failed to send multicast push notification",i);throw i}}buildFCMMessage(i,t){const e={notification:{title:this.truncateText(i.title,65),body:this.truncateText(i.body,240)}};i.imageUrl&&(e.notification.imageUrl=i.imageUrl);i.data&&(e.data=i.data);(null==t?void 0:t.android)&&(e.android={priority:"high"===i.priority?"high":"normal",notification:{channelId:t.android.channelId||"default-channel",color:t.android.color,icon:i.icon,imageUrl:i.imageUrl,sound:i.sound||"default",tag:i.tag},ttl:i.ttl?1e3*i.ttl:void 0});if(null==t?void 0:t.ios){e.apns={headers:{"apns-priority":"high"===i.priority?"10":"5"},payload:{aps:{alert:{title:e.notification.title,body:e.notification.body},badge:t.ios.badge,sound:t.ios.sound||"default",contentAvailable:t.ios.contentAvailable?1:0,mutableContent:t.ios.mutableContent?1:0}}};i.imageUrl&&(e.apns.fcmOptions={imageUrl:i.imageUrl})}(null==t?void 0:t.web)&&(e.webpush={notification:{title:e.notification.title,body:e.notification.body,icon:t.web.icon||i.icon,badge:t.web.badge,vibrate:t.web.vibrate,requireInteraction:"high"===i.priority},fcmOptions:{link:i.clickAction}});return e}validateToken(i){if(!i||i.length<100||i.length>200)return!1;return/^[a-zA-Z0-9_-]+$/.test(i)}async subscribeToTopic(i,t){try{if(!this.app)throw new Error("Firebase app not initialized");const e=await admin.messaging().subscribeToTopic(i,t);this.log("Tokens subscribed to topic",{topic:t,successCount:e.successCount,failureCount:e.failureCount});return{success:e.successCount>0,metadata:{topic:t,successCount:e.successCount,failureCount:e.failureCount}}}catch(i){this.logError("Failed to subscribe to topic",i);throw i}}async unsubscribeFromTopic(i,t){try{if(!this.app)throw new Error("Firebase app not initialized");const e=await admin.messaging().unsubscribeFromTopic(i,t);this.log("Tokens unsubscribed from topic",{topic:t,successCount:e.successCount,failureCount:e.failureCount});return{success:e.successCount>0,metadata:{topic:t,successCount:e.successCount,failureCount:e.failureCount}}}catch(i){this.logError("Failed to unsubscribe from topic",i);throw i}}}exports.FCMProvider=FCMProvider;