"use strict";async function getMatchingEngine(){try{return(await Promise.resolve().then(()=>__importStar(require("@b/api/(ext)/ecosystem/utils/matchingEngine")))).MatchingEngine.getInstance()}catch(e){return{getTickers:async()=>({})}}}async function processWalletPnl(){const e="processWalletPnl",a=Date.now();try{(0,broadcast_1.broadcastStatus)(e,"running");(0,broadcast_1.broadcastLog)(e,"Starting wallet PnL processing");const t=await db_1.models.user.findAll({attributes:["id"]});(0,broadcast_1.broadcastLog)(e,`Found ${t.length} users to process`);for(const a of t){(0,broadcast_1.broadcastLog)(e,`Scheduling PnL task for user ${a.id}`);walletTask_1.walletPnlTaskQueue.add(()=>handlePnl(a))}(0,broadcast_1.broadcastStatus)(e,"completed",{duration:Date.now()-a});(0,broadcast_1.broadcastLog)(e,"Wallet PnL processing scheduled","success")}catch(a){console_1.logger.error("CRON","Wallet PnL processing failed",a);(0,broadcast_1.broadcastStatus)(e,"failed");(0,broadcast_1.broadcastLog)(e,`Wallet PnL processing failed: ${a.message}`,"error");throw a}}async function cleanupOldPnlRecords(){const e="cleanupOldPnlRecords";try{(0,broadcast_1.broadcastStatus)(e,"running");(0,broadcast_1.broadcastLog)(e,"Starting cleanup of old PnL records");const a=(0,date_fns_1.subDays)(new Date,30),t=(0,date_fns_1.subDays)(new Date,1),r='{"FIAT":0,"SPOT":0,"ECO":0}',s={FIAT:0,SPOT:0,ECO:0};(0,broadcast_1.broadcastLog)(e,"Deleting PnL records older than one month");await db_1.models.walletPnl.destroy({where:{createdAt:{[sequelize_1.Op.lt]:a}}});(0,broadcast_1.broadcastLog)(e,"Deleted PnL records older than one month","success");(0,broadcast_1.broadcastLog)(e,"Deleting PnL records older than yesterday with zero balance");await db_1.models.walletPnl.destroy({where:{createdAt:{[sequelize_1.Op.lt]:t},[sequelize_1.Op.or]:[{balances:r},{balances:s}]}});(0,broadcast_1.broadcastLog)(e,"Deleted PnL records older than yesterday with zero balance","success");(0,broadcast_1.broadcastStatus)(e,"completed");(0,broadcast_1.broadcastLog)(e,"Cleanup of old PnL records completed","success")}catch(a){console_1.logger.error("CRON","Cleanup of old PnL records failed",a);(0,broadcast_1.broadcastStatus)(e,"failed");(0,broadcast_1.broadcastLog)(e,`Cleanup of old PnL records failed: ${a.message}`,"error")}}async function processSpotPendingDeposits(){const e="processSpotPendingDeposits";try{(0,broadcast_1.broadcastStatus)(e,"running");(0,broadcast_1.broadcastLog)(e,"Starting processing of pending spot deposits");const a=await getPendingSpotTransactionsQuery("DEPOSIT");(0,broadcast_1.broadcastLog)(e,`Found ${a.length} pending deposit transactions`);for(const t of a){const a=t.id,r=t.userId,s=t.referenceId;if(s)if(index_ws_1.spotVerificationIntervals.has(a))(0,broadcast_1.broadcastLog)(e,`Verification already scheduled for transaction ${a}`,"info");else{(0,index_ws_1.startSpotVerificationSchedule)(a,r,s);(0,broadcast_1.broadcastLog)(e,`Started verification for transaction ${a}`,"info")}else(0,broadcast_1.broadcastLog)(e,`Transaction ${a} has no referenceId; skipping`,"info")}(0,broadcast_1.broadcastStatus)(e,"completed");(0,broadcast_1.broadcastLog)(e,"Processing pending spot deposits completed","success")}catch(a){console_1.logger.error("CRON","Processing pending spot deposits failed",a);(0,broadcast_1.broadcastStatus)(e,"failed");(0,broadcast_1.broadcastLog)(e,`Processing pending spot deposits failed: ${a.message}`,"error");throw a}}async function getPendingSpotTransactionsQuery(e){try{const a=new Date(Date.now()-36e5);return await db_1.models.transaction.findAll({where:{status:"PENDING",type:e,createdAt:{[sequelize_1.Op.between]:[a,new Date]},[sequelize_1.Op.and]:[{referenceId:{[sequelize_1.Op.ne]:null}},{referenceId:{[sequelize_1.Op.ne]:""}}]},include:[{model:db_1.models.wallet,as:"wallet",attributes:["id","currency"]}]})}catch(e){console_1.logger.error("CRON","Error getting pending spot transactions",e);throw e}}async function processPendingWithdrawals(){const e="processPendingWithdrawals";try{(0,broadcast_1.broadcastStatus)(e,"running");(0,broadcast_1.broadcastLog)(e,"Starting processing pending withdrawals");const a=await getPendingSpotTransactionsQuery("WITHDRAW");(0,broadcast_1.broadcastLog)(e,`Found ${a.length} pending withdrawal transactions`);for(const t of a){(0,broadcast_1.broadcastLog)(e,`Processing withdrawal transaction ${t.id}`);const a=t.userId,r=t.referenceId;if(!r){(0,broadcast_1.broadcastLog)(e,`Transaction ${t.id} has no referenceId; skipping`,"info");continue}const s=await exchange_1.default.startExchange();(0,broadcast_1.broadcastLog)(e,`Exchange started for processing transaction ${t.id}`);try{const{wallet:o}=t;(0,broadcast_1.broadcastLog)(e,`Fetching withdrawals for currency ${null==o?void 0:o.currency} for transaction ${t.id}`);const n=(await s.fetchWithdrawals(null==o?void 0:o.currency)).find(e=>e.id===r);let c="PENDING";if(n){switch(n.status){case"completed":case"ok":c="COMPLETED";break;case"cancelled":case"canceled":c="CANCELLED";break;case"failed":c="FAILED"}(0,broadcast_1.broadcastLog)(e,`Withdrawal data for transaction ${t.id} returned status ${n.status}`)}else(0,broadcast_1.broadcastLog)(e,`No withdrawal data found for transaction ${t.id}`,"info");if(!c)continue;if(t.status===c){(0,broadcast_1.broadcastLog)(e,`Transaction ${t.id} already has status ${c}; skipping update`,"info");continue}await(0,utils_1.updateTransaction)(t.id,{status:c});(0,broadcast_1.broadcastLog)(e,`Transaction ${t.id} status updated to ${c}`,"success");if("FAILED"===c||"CANCELLED"===c){await(0,spot_1.updateSpotWalletBalance)(a,null==o?void 0:o.currency,Number(t.amount),Number(t.fee),"REFUND_WITHDRAWAL");await(0,notifications_1.createNotification)({userId:a,relatedId:t.id,title:"Withdrawal Failed",message:`Your withdrawal of ${t.amount} ${null==o?void 0:o.currency} has failed.`,type:"system",link:`/finance/wallet/withdrawals/${t.id}`,actions:[{label:"View Withdrawal",link:`/finance/wallet/withdrawals/${t.id}`,primary:!0}]});(0,broadcast_1.broadcastLog)(e,`Processed failed withdrawal ${t.id}`,"info")}}catch(a){console_1.logger.error("CRON",`Error processing withdrawal ${t.id}`,a);(0,broadcast_1.broadcastLog)(e,`Error processing withdrawal ${t.id}: ${a.message}`,"error");continue}}(0,broadcast_1.broadcastStatus)(e,"completed");(0,broadcast_1.broadcastLog)(e,"Processing pending withdrawals completed","success")}catch(a){console_1.logger.error("CRON","Processing pending withdrawals failed",a);(0,broadcast_1.broadcastStatus)(e,"failed");(0,broadcast_1.broadcastLog)(e,`Processing pending withdrawals failed: ${a.message}`,"error");throw a}}var __createBinding=this&&this.__createBinding||(Object.create?function(e,a,t,r){void 0===r&&(r=t);var s=Object.getOwnPropertyDescriptor(a,t);s&&!("get"in s?!a.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return a[t]}});Object.defineProperty(e,r,s)}:function(e,a,t,r){void 0===r&&(r=t);e[r]=a[t]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,a){Object.defineProperty(e,"default",{enumerable:!0,value:a})}:function(e,a){e.default=a}),__importStar=this&&this.__importStar||function(){var e=function(a){e=Object.getOwnPropertyNames||function(e){var a=[];for(var t in e)Object.prototype.hasOwnProperty.call(e,t)&&(a[a.length]=t);return a};return e(a)};return function(a){if(a&&a.__esModule)return a;var t={};if(null!=a)for(var r=e(a),s=0;s<r.length;s++)"default"!==r[s]&&__createBinding(t,a,r[s]);__setModuleDefault(t,a);return t}}(),__importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.processWalletPnl=processWalletPnl;exports.cleanupOldPnlRecords=cleanupOldPnlRecords;exports.processSpotPendingDeposits=processSpotPendingDeposits;exports.getPendingSpotTransactionsQuery=getPendingSpotTransactionsQuery;exports.processPendingWithdrawals=processPendingWithdrawals;const exchange_1=__importDefault(require("@b/utils/exchange")),db_1=require("@b/db"),console_1=require("@b/utils/console"),sequelize_1=require("sequelize"),date_fns_1=require("date-fns"),broadcast_1=require("../broadcast"),index_ws_1=require("@b/api/finance/deposit/spot/index.ws"),spot_1=require("@b/utils/spot"),utils_1=require("@b/api/finance/utils"),notifications_1=require("@b/utils/notifications"),walletTask_1=require("./walletTask"),handlePnl=async e=>{var a;const t="processWalletPnl";try{(0,broadcast_1.broadcastLog)(t,`Handling PnL for user ${e.id}`);const r=await db_1.models.wallet.findAll({where:{userId:e.id},attributes:["currency","balance","type"]});(0,broadcast_1.broadcastLog)(t,`User ${e.id} has ${r.length} wallets`);if(!r.length){(0,broadcast_1.broadcastLog)(t,`No wallets found for user ${e.id}`,"info");return}const s=new Date;s.setHours(0,0,0,0);(0,broadcast_1.broadcastLog)(t,`Today date set to ${s.toISOString()}`);const o=Array.from(r.map(e=>e.currency));(0,broadcast_1.broadcastLog)(t,`Unique currencies for user ${e.id}: ${o.join(", ")}`);const[n,c,d,i]=await Promise.all([db_1.models.walletPnl.findOne({where:{userId:e.id,createdAt:{[sequelize_1.Op.gte]:s}},attributes:["id","balances"]}),db_1.models.currency.findAll({where:{id:o},attributes:["id","price"]}),db_1.models.exchangeCurrency.findAll({where:{currency:o},attributes:["currency","price"]}),getMatchingEngine()]);(0,broadcast_1.broadcastLog)(t,`Parallel queries completed for user ${e.id}`);const l=await i.getTickers();(0,broadcast_1.broadcastLog)(t,"Tickers fetched from MatchingEngine");const u=new Map(c.map(e=>[e.id,e.price])),b=new Map(d.map(e=>[e.currency,e.price])),g={FIAT:0,SPOT:0,ECO:0};for(const e of r){let t;"FIAT"===e.type?t=u.get(e.currency):"SPOT"===e.type?t=b.get(e.currency):"ECO"===e.type&&(t=(null===(a=l[e.currency])||void 0===a?void 0:a.last)||0);t&&(g[e.type]+=t*e.balance)}(0,broadcast_1.broadcastLog)(t,`Calculated balances for user ${e.id}: FIAT=${g.FIAT}, SPOT=${g.SPOT}, ECO=${g.ECO}`);if(Object.values(g).some(e=>e>0))if(n){await n.update({balances:g});(0,broadcast_1.broadcastLog)(t,`Updated today's PnL record for user ${e.id}`,"success")}else{await db_1.models.walletPnl.create({userId:e.id,balances:g,createdAt:s});(0,broadcast_1.broadcastLog)(t,`Created new PnL record for user ${e.id}`,"success")}else(0,broadcast_1.broadcastLog)(t,`No positive balances to record for user ${e.id}`,"info")}catch(a){console_1.logger.error("CRON",`Error handling PnL for user ${e.id}`,a);(0,broadcast_1.broadcastLog)("processWalletPnl",`Error handling PnL for user ${e.id}: ${a.message}`,"error");throw a}};