"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),token_1=require("@b/utils/token");exports.metadata={summary:"Get user notification preferences",description:"Retrieves the notification preferences for a user using their unsubscribe token.",operationId:"getUnsubscribePreferences",tags:["User","Unsubscribe"],requiresAuth:!1,query:[{name:"token",in:"query",required:!0,schema:{type:"string"},description:"The unsubscribe token from the email"}],responses:{200:{description:"Preferences retrieved successfully.",content:{"application/json":{schema:{type:"object",properties:{email:{type:"boolean"},sms:{type:"boolean"},push:{type:"boolean"}}}}}},400:{description:"Invalid or expired token"},404:{description:"User not found"},500:{description:"Internal Server Error"}}};exports.default=async e=>{var r,s,t;const{ctx:i,query:n}=e,{token:o}=n;if(!o){null==i||i.fail("Token is required");throw(0,error_1.createError)({statusCode:400,message:"Token is required"})}null==i||i.step("Verifying unsubscribe token");const u=await(0,token_1.verifyUnsubscribeToken)(o);if(!u){null==i||i.fail("Invalid or expired token");throw(0,error_1.createError)({statusCode:400,message:"Invalid or expired token"})}null==i||i.step("Fetching user preferences");const a=await db_1.models.user.findByPk(u,{attributes:["id","email","firstName","settings"]});if(!a){null==i||i.fail("User not found");throw(0,error_1.createError)({statusCode:404,message:"User not found"})}const l=a.settings||{email:!0,sms:!0,push:!0};null==i||i.success("Preferences retrieved successfully");return{email:null===(r=l.email)||void 0===r||r,sms:null===(s=l.sms)||void 0===s||s,push:null===(t=l.push)||void 0===t||t}};