"use strict";function isWebPushSubscription(e){try{const s=JSON.parse(e);return s&&"string"==typeof s.endpoint&&s.endpoint.startsWith("https://")&&s.keys&&"string"==typeof s.keys.p256dh&&"string"==typeof s.keys.auth}catch(e){return!1}}function getSubscriptionDetails(e){var s,t,i,o,n,r,u,c,a;let p=0,d=0;const l=[];if(!e)return{fcm:0,webpush:0,total:0,endpoints:[]};if(e.pushTokens)if(Array.isArray(e.pushTokens)){for(const n of e.pushTokens)if("string"==typeof n)if(isWebPushSubscription(n)){d++;try{const e=JSON.parse(n);l.push((null===(s=e.endpoint)||void 0===s?void 0:s.substring(0,60))+"...")}catch(e){}}else{p++;l.push("FCM: "+n.substring(0,20)+"...")}else if(n&&"object"==typeof n)if("webpush"===n.type){d++;try{const e=JSON.parse(n.token);l.push((null===(t=e.endpoint)||void 0===t?void 0:t.substring(0,60))+"...")}catch(e){l.push("WebPush: invalid format")}}else if("fcm"===n.type){p++;l.push("FCM: "+((null===(i=n.token)||void 0===i?void 0:i.substring(0,20))||"unknown")+"...")}else if(n.token)if(isWebPushSubscription(n.token)){d++;try{const e=JSON.parse(n.token);l.push((null===(o=e.endpoint)||void 0===o?void 0:o.substring(0,60))+"...")}catch(e){}}else{p++;l.push("FCM: "+n.token.substring(0,20)+"...")}}else if("object"==typeof e.pushTokens)for(const[s,t]of Object.entries(e.pushTokens))if("string"==typeof t)if(isWebPushSubscription(t)){d++;try{const e=JSON.parse(t);l.push(`[${s}] ${null===(n=e.endpoint)||void 0===n?void 0:n.substring(0,50)}...`)}catch(e){}}else{p++;l.push(`[${s}] FCM: ${t.substring(0,20)}...`)}else if(t&&"object"==typeof t){const e=t;if("webpush"===e.type){d++;try{const t=JSON.parse(e.token);l.push(`[${s}] ${null===(r=t.endpoint)||void 0===r?void 0:r.substring(0,50)}...`)}catch(e){l.push(`[${s}] WebPush: invalid`)}}else if("fcm"===e.type){p++;l.push(`[${s}] FCM: ${null===(u=e.token)||void 0===u?void 0:u.substring(0,20)}...`)}else if(e.token)if(isWebPushSubscription(e.token)){d++;try{const t=JSON.parse(e.token);l.push(`[${s}] ${null===(c=t.endpoint)||void 0===c?void 0:c.substring(0,50)}...`)}catch(e){}}else{p++;l.push(`[${s}] FCM: ${e.token.substring(0,20)}...`)}}if(e.webPushSubscriptions&&Array.isArray(e.webPushSubscriptions))for(const s of e.webPushSubscriptions){d++;const e="string"==typeof s?JSON.parse(s):s;l.push(`[legacy] ${null===(a=e.endpoint)||void 0===a?void 0:a.substring(0,50)}...`)}return{fcm:p,webpush:d,total:p+d,endpoints:l}}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const notification_1=require("@b/services/notification"),errors_1=require("@b/utils/schema/errors"),db_1=require("@b/db");exports.metadata={summary:"Test Push Notification",description:"Send a test push notification to verify your push subscription is working",operationId:"testUserPushNotification",tags:["User","Push","Testing"],requiresAuth:!0,responses:{200:{description:"Test push notification result",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},message:{type:"string"},delivered:{type:"boolean"},deviceCount:{type:"number"}}}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse}};exports.default=async e=>{var s;const{user:t}=e;if(!(null==t?void 0:t.id))throw new Error("User not authenticated");try{const e=notification_1.notificationService.getChannel("PUSH")||new notification_1.PushChannel,i=e.hasWebPushProvider(),o=e.hasFCMProvider();if(!i&&!o)return{success:!1,message:"Push notifications are not configured on this server.",delivered:!1};const n=await db_1.models.user.findByPk(t.id,{attributes:["settings"]}),r=getSubscriptionDetails((null==n?void 0:n.settings)||{});if(0===r.total)return{success:!1,message:"No push subscription found. Please enable push notifications first.",delivered:!1,deviceCount:0};if(r.webpush>0&&!i)return{success:!1,message:"Web Push (VAPID) is not configured but you have web push subscriptions.",delivered:!1};if(r.fcm>0&&!o)return{success:!1,message:"FCM is not configured but you have FCM tokens.",delivered:!1};const u=await notification_1.notificationService.send({userId:t.id,type:"SYSTEM",channels:["PUSH"],data:{title:"Test Notification",message:`Push notifications are working! Sent to ${r.total} device(s).`,testMode:!0,timestamp:(new Date).toISOString(),badge:1,link:"/user/profile?tab=notifications"},priority:"HIGH",idempotencyKey:`user-test-push-${t.id}-${Date.now()}`}),c=u.channelsDelivered.includes("PUSH");if(u.channelsFailed.includes("PUSH")){return{success:!1,message:(null===(s=u.errors)||void 0===s?void 0:s.PUSH)||"Failed to deliver push notification",delivered:!1,deviceCount:r.total}}return{success:!0,message:c?`Test notification sent to ${r.total} device(s)!`:"Notification queued for delivery.",delivered:c,deviceCount:r.total}}catch(e){console.error("[Push Test] Error:",e);throw e}};