"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),notification_1=require("@b/services/notification");exports.metadata={summary:"Subscribe to push notifications",description:"Register a Web Push subscription or FCM token for the current user",operationId:"subscribeToPush",tags:["User","Push Notifications"],requiresAuth:!0,requestBody:{required:!0,content:{"application/json":{schema:{type:"object",required:["type"],properties:{type:{type:"string",enum:["webpush","fcm"],description:"Type of push subscription"},subscription:{type:"object",description:"Web Push subscription object (for type=webpush)",properties:{endpoint:{type:"string",description:"Push service endpoint URL"},keys:{type:"object",properties:{p256dh:{type:"string",description:"P-256 public key"},auth:{type:"string",description:"Authentication secret"}}}}},token:{type:"string",description:"FCM token (for type=fcm)"},deviceId:{type:"string",description:"Optional device identifier"},platform:{type:"string",enum:["web","android","ios"],description:"Platform type"}}}}}},responses:{200:{description:"Subscription registered successfully",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},message:{type:"string"},deviceId:{type:"string",description:"Generated or provided device ID"}}}}}},401:{description:"Unauthorized"}}};exports.default=async e=>{const{user:r,body:t}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"User not authenticated"});const{type:s,subscription:i,token:o,deviceId:n,platform:c}=t;if(!s)throw(0,error_1.createError)({statusCode:400,message:"Subscription type is required"});const a=notification_1.notificationService.getChannel("PUSH")||new notification_1.PushChannel;if("webpush"===s){if(!i||!i.endpoint||!i.keys)throw(0,error_1.createError)({statusCode:400,message:"Invalid Web Push subscription object"});if(!i.keys.p256dh||!i.keys.auth)throw(0,error_1.createError)({statusCode:400,message:"Missing subscription keys (p256dh and auth required)"});if(!a.hasWebPushProvider())throw(0,error_1.createError)({statusCode:503,message:"Web Push notifications are not configured on this server"});if(!await a.addWebPushSubscription(r.id,i,n))throw(0,error_1.createError)({statusCode:500,message:"Failed to save subscription"});return{success:!0,message:"Web Push subscription registered successfully",deviceId:n||"auto-generated"}}if("fcm"===s){if(!o)throw(0,error_1.createError)({statusCode:400,message:"FCM token is required"});if(!a.hasFCMProvider())throw(0,error_1.createError)({statusCode:503,message:"FCM notifications are not configured on this server"});if(!await a.addDeviceToken(r.id,o,"fcm",n,c||"web"))throw(0,error_1.createError)({statusCode:500,message:"Failed to save FCM token"});return{success:!0,message:"FCM token registered successfully",deviceId:n||"auto-generated"}}throw(0,error_1.createError)({statusCode:400,message:"Invalid subscription type. Use 'webpush' or 'fcm'"})};