"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),constants_1=require("@b/utils/constants"),utils_1=require("./utils"),error_1=require("@b/utils/error");exports.metadata={summary:"Lists transactions with optional filters",operationId:"listTransactions",tags:["Finance","Transactions"],parameters:[...constants_1.crudParameters,{name:"walletType",in:"query",description:"Type of the wallet",schema:{type:"string"}},{name:"currency",in:"query",description:"Currency of the wallet",schema:{type:"string"}}],responses:{200:{description:"Paginated list of transactions retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{data:{type:"array",items:{type:"object",properties:utils_1.baseTransactionSchema}},pagination:constants_1.paginationSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Transactions"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{const{user:t,query:r}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{walletType:s,currency:a,...n}=r,o={userId:t.id};s&&(o.type=s);a&&(o.currency=a);let i=null;if(s||a){i=await db_1.models.wallet.findOne({where:o});if(!i)throw(0,error_1.createError)({statusCode:404,message:"Wallet not found"})}return(0,query_1.getFiltered)({model:db_1.models.transaction,query:n,where:{userId:t.id,...i?{walletId:i.id}:{}},sortField:n.sortField||"createdAt",numericFields:["amount","fee"],includeModels:[{model:db_1.models.wallet,as:"wallet",attributes:["currency","type"]}]})};