"use strict";async function findInvestmentById(e){const t=await db_1.models.investment.findOne({where:{id:e},include:[{model:db_1.models.investmentPlan,as:"plan"},{model:db_1.models.wallet,as:"wallet"},{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","email","avatar"]}]});if(!t)throw(0,error_1.createError)({statusCode:404,message:INVESTMENT_NOT_FOUND});return t.get({plain:!0})}async function deleteInvestments(e){await db_1.models.investment.destroy({where:{id:e}})}async function checkInvestments(){const e=await db_1.models.investment.findAll({where:{status:"ACTIVE"},include:[{model:db_1.models.investmentPlan,as:"plan"},{model:db_1.models.investmentDuration,as:"duration"}]});for(const t of e){if(!t.createdAt)continue;let e;switch(t.duration.timeframe){case"HOUR":e=60*t.duration.duration*60*1e3;break;case"DAY":e=24*t.duration.duration*60*60*1e3;break;case"WEEK":e=7*t.duration.duration*24*60*60*1e3;break;case"MONTH":e=30*t.duration.duration*24*60*60*1e3}const n=new Date(t.createdAt.getTime()+e);if(!((new Date).getTime()<n.getTime()))try{const e=await db_1.models.wallet.findOne({where:{userId:t.userId,currency:t.plan.currency,type:t.plan.walletType}});if(!e){console.error(`Wallet not found for investment ${t.id}`);continue}if(t.profit){const n=t.amount*(t.profit/100),a=t.amount+n,s=`investment_roi_${t.id}`;await wallet_1.walletService.credit({idempotencyKey:s,userId:t.userId,walletId:e.id,walletType:t.plan.walletType,currency:t.plan.currency,amount:a,operationType:"AI_INVESTMENT_ROI",description:`Investment ROI: Plan "${t.plan.title}" | Duration: ${t.duration.duration} ${t.duration.timeframe}`,metadata:{investmentId:t.id,planId:t.plan.id,originalAmount:t.amount,profitPercentage:t.profit,profitAmount:n}});await t.update({status:"COMPLETED"})}}catch(e){console.error(`Failed to process investment ${t.id}: ${e.message}`)}}}Object.defineProperty(exports,"__esModule",{value:!0});exports.baseUserSchema=exports.baseInvestmentPlanSchema=exports.baseInvestmentSchema=void 0;exports.findInvestmentById=findInvestmentById;exports.deleteInvestments=deleteInvestments;exports.checkInvestments=checkInvestments;const db_1=require("@b/db"),schema_1=require("@b/utils/schema"),wallet_1=require("@b/services/wallet"),error_1=require("@b/utils/error");exports.baseInvestmentSchema={id:(0,schema_1.baseStringSchema)("ID of the investment"),amount:(0,schema_1.baseNumberSchema)("Amount of the investment"),roi:(0,schema_1.baseNumberSchema)("Return on investment (ROI) of the investment"),duration:(0,schema_1.baseIntegerSchema)("Duration of the investment in days"),status:(0,schema_1.baseStringSchema)("Status of the investment")};exports.baseInvestmentPlanSchema={id:(0,schema_1.baseStringSchema)("ID of the investment plan"),name:(0,schema_1.baseStringSchema)("Name of the investment plan"),title:(0,schema_1.baseStringSchema)("Title of the investment plan"),image:(0,schema_1.baseStringSchema)("Image of the investment plan"),description:(0,schema_1.baseStringSchema)("Description of the investment plan"),currency:(0,schema_1.baseStringSchema)("Currency of the investment plan"),minAmount:(0,schema_1.baseNumberSchema)("Minimum amount required for the investment plan"),maxAmount:(0,schema_1.baseNumberSchema)("Maximum amount allowed for the investment plan"),roi:(0,schema_1.baseNumberSchema)("Return on investment (ROI) of the investment plan"),duration:(0,schema_1.baseIntegerSchema)("Duration of the investment plan in days"),status:(0,schema_1.baseBooleanSchema)("Status of the investment plan")};exports.baseUserSchema={id:(0,schema_1.baseStringSchema)("ID of the user"),firstName:(0,schema_1.baseStringSchema)("First name of the user"),lastName:(0,schema_1.baseStringSchema)("Last name of the user"),avatar:(0,schema_1.baseStringSchema)("Avatar of the user")};const INVESTMENT_NOT_FOUND="Investment not found";