"use strict";async function getInvestmentStats(){try{const e=await db_1.models.investment.count({distinct:!0,col:"userId",where:{status:{[sequelize_1.Op.in]:ACTIVE_INVESTMENT_STATUS}}}),t=await db_1.models.investment.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"totalInvested"]],raw:!0}),n=Number((null==t?void 0:t.totalInvested)||0),r=await db_1.models.investment.findOne({attributes:[[(0,sequelize_1.fn)("AVG",(0,sequelize_1.literal)("CASE WHEN amount > 0 AND profit IS NOT NULL THEN ((profit / amount) * 100) ELSE NULL END")),"averageReturn"]],where:{status:{[sequelize_1.Op.in]:COMPLETED_INVESTMENT_STATUS}},raw:!0}),s=Number((null==r?void 0:r.averageReturn)||0),a=await db_1.models.investmentPlan.count({where:{status:!0}}),i=await db_1.models.investmentPlan.findOne({attributes:[[(0,sequelize_1.fn)("MAX",(0,sequelize_1.col)("profitPercentage")),"maxProfitPercentage"]],where:{status:!0},raw:!0});return{activeInvestors:e,totalInvested:n,averageReturn:s,totalPlans:a,maxProfitPercentage:Number((null==i?void 0:i.maxProfitPercentage)||0)}}catch(e){console_1.logger.error("INVESTMENT","Error in getInvestmentStats",e);throw(0,error_1.createError)({statusCode:500,message:"Internal Server Error"})}}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;exports.default=getInvestmentStats;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize"),console_1=require("@b/utils/console"),ACTIVE_INVESTMENT_STATUS=["ACTIVE","RUNNING","OPEN"],COMPLETED_INVESTMENT_STATUS=["COMPLETED","CLOSED"];exports.metadata={summary:"Get Investment Platform Statistics",description:"Retrieves platform-wide investment stats: number of active investors, total invested amount, average return (completed investments), and number of investment plans.",operationId:"getInvestmentStats",tags:["Investment","Stats"],responses:{200:{description:"Investment platform statistics retrieved successfully.",content:{"application/json":{schema:{type:"object",properties:{activeInvestors:{type:"number",description:"Unique users with active investments."},totalInvested:{type:"number",description:"Total amount invested (all time)."},averageReturn:{type:"number",description:"Average return percentage for completed investments."},totalPlans:{type:"number",description:"Total number of active investment plans."},maxProfitPercentage:{type:"number",description:"Maximum profit percentage among all active plans."}}}}}},500:{description:"Internal Server Error."}}};