"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),wallet_1=require("@b/services/wallet"),error_1=require("@b/utils/error"),emails_1=require("@b/utils/emails"),utils_1=require("./utils");exports.metadata={summary:"Verifies a PayU payment",description:"Handles return URL verification after payment completion and updates transaction status",operationId:"verifyPayUPayment",tags:["Finance","Deposit","PayU"],requiresAuth:!0,logModule:"PAYU_DEPOSIT",logTitle:"Verify PayU payment",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{txnid:{type:"string",description:"PayU transaction ID"},mihpayid:{type:"string",description:"PayU internal payment ID"},status:{type:"string",description:"Transaction status from PayU"},hash:{type:"string",description:"Hash for verification"},amount:{type:"string",description:"Transaction amount"},productinfo:{type:"string",description:"Product information"},firstname:{type:"string",description:"Customer first name"},email:{type:"string",description:"Customer email"},udf1:{type:"string"},udf2:{type:"string"},udf3:{type:"string"},udf4:{type:"string"},udf5:{type:"string"},mode:{type:"string",description:"Payment mode used"},bankcode:{type:"string",description:"Bank code"},bank_ref_num:{type:"string",description:"Bank reference number"},error:{type:"string",description:"Error message if any"},error_Message:{type:"string",description:"Detailed error message"}},required:["txnid"]}}}},responses:{200:{description:"Payment verified successfully",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},data:{type:"object",properties:{transaction_id:{type:"string"},mihpayid:{type:"string"},status:{type:"string"},amount:{type:"number"},currency:{type:"string"},gateway:{type:"string"},payment_mode:{type:"string"},bank_name:{type:"string"},bank_ref_num:{type:"string"},verified_at:{type:"string"}}}}}}}},400:{description:"Bad request - Invalid verification data"},401:{description:"Unauthorized - User not authenticated"},404:{description:"Transaction not found"},500:{description:"Internal server error"}}};exports.default=async e=>{const{user:t,body:r}=e,{txnid:a,mihpayid:i,status:n,hash:s,amount:o,productinfo:d,firstname:u,email:c,udf1:p,udf2:m,udf3:y,udf4:_,udf5:f,mode:l,bankcode:g,bank_ref_num:h,error:b,error_Message:w}=r;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"User not authenticated"});if(!a)throw(0,error_1.createError)({statusCode:400,message:"Transaction ID is required"});try{(0,utils_1.validatePayUConfig)();const e=await db_1.models.transaction.findOne({where:{uuid:a,userId:t.id,type:"DEPOSIT"}});if(!e)throw(0,error_1.createError)({statusCode:404,message:"Transaction not found"});const r=JSON.parse(e.metadata||"{}");if("payu"!==r.gateway)throw(0,error_1.createError)({statusCode:400,message:"Invalid gateway for this transaction"});if("COMPLETED"===e.status)return{success:!0,data:{transaction_id:e.uuid,mihpayid:i||r.mihpayid||"",status:"COMPLETED",amount:e.amount,currency:r.currency||"INR",gateway:"payu",payment_mode:r.paymentMode||l||"",bank_name:r.bankName||"",bank_ref_num:r.bankRefNum||h||"",verified_at:e.updatedAt}};if(s&&n&&o&&d&&u&&c){const e={key:utils_1.PAYU_CONFIG.MERCHANT_KEY,txnid:a,amount:o,productinfo:d,firstname:u,email:c,status:n,udf1:p||"",udf2:m||"",udf3:y||"",udf4:_||"",udf5:f||""};if(!(0,utils_1.verifyPayUHash)(e,s,utils_1.PAYU_CONFIG.MERCHANT_SALT))throw(0,error_1.createError)({statusCode:400,message:"Invalid hash verification"})}const P={key:utils_1.PAYU_CONFIG.MERCHANT_KEY,command:"verify_payment",var1:a,hash:""},C=`${utils_1.PAYU_CONFIG.MERCHANT_KEY}|verify_payment|${a}|${utils_1.PAYU_CONFIG.MERCHANT_SALT}`;P.hash=require("crypto").createHash("sha512").update(C).digest("hex");const v=await(0,utils_1.makePayURequest)("/merchant/postservice.php?form=2",{method:"POST",body:P,headers:{"Content-Type":"application/x-www-form-urlencoded"}});if(1!==v.status)throw(0,error_1.createError)({statusCode:400,message:v.message||"Payment verification failed"});const I=v.transaction_details[a];if(!I)throw(0,error_1.createError)({statusCode:404,message:"Transaction details not found in PayU response"});const E=I.status,T=(0,utils_1.mapPayUStatus)(E),k=(0,utils_1.parsePayUAmount)(I.amt||o||"0",r.currency||"INR"),U=await db_1.sequelize.transaction();try{await e.update({status:T,referenceId:i||I.mihpayid||e.referenceId,metadata:JSON.stringify({...r,mihpayid:i||I.mihpayid,bankRefNum:h||I.bank_ref_num,paymentMode:l||I.mode,bankCode:g||I.bankcode,bankName:I.bank_name,cardType:I.card_type,nameOnCard:I.name_on_card,cardNum:I.cardnum,paymentSource:I.payment_source,error:b||I.error,errorMessage:w||I.error_Message,payuVerifyResponse:I,verifiedAt:(new Date).toISOString()})},{transaction:U});if("COMPLETED"===T){const a=r.currency||"USD",n=(await wallet_1.walletCreationService.getOrCreateWallet(t.id,"FIAT",a,U)).wallet,s=`payu_verify_${e.id}`;await wallet_1.walletService.credit({idempotencyKey:s,userId:t.id,walletId:n.id,walletType:"FIAT",currency:a,amount:k,operationType:"DEPOSIT",referenceId:e.id,description:`PayU deposit of ${k} ${a}`,metadata:{method:"PAYU",mihpayid:i||I.mihpayid,mode:l||I.mode},transaction:U});const o=parseFloat(String(n.balance))+k;await(0,emails_1.sendFiatTransactionEmail)(t,e,a,o)}await U.commit();return{success:!0,data:{transaction_id:e.uuid,mihpayid:i||I.mihpayid||"",status:T,amount:e.amount,currency:r.currency||"INR",gateway:"payu",payment_mode:l||I.mode||"",bank_name:I.bank_name||"",bank_ref_num:h||I.bank_ref_num||"",card_type:I.card_type||"",name_on_card:I.name_on_card||"",payment_source:I.payment_source||"",error:b||I.error||"",error_message:w||I.error_Message||"",verified_at:(new Date).toISOString()}}}catch(e){await U.rollback();throw e}}catch(b){if(b.statusCode)throw b;throw(0,error_1.createError)({statusCode:500,message:b instanceof Error?b.message:"Payment verification failed"})}};