"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),utils_1=require("./utils");exports.metadata={summary:"Creates a PayU payment session",description:"Initiates a PayU payment transaction with comprehensive payment method support",operationId:"createPayUPayment",tags:["Finance","Deposit","PayU"],requiresAuth:!0,logModule:"PAYU_DEPOSIT",logTitle:"Create PayU payment session",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{amount:{type:"number",description:"Payment amount",minimum:.01},currency:{type:"string",description:"Payment currency (INR, USD, EUR, GBP, PLN, CZK, RON, HUF, UAH, TRY, BRL, COP, PEN, ARS, CLP, MXN, ZAR)",enum:["INR","USD","EUR","GBP","PLN","CZK","RON","HUF","UAH","TRY","BRL","COP","PEN","ARS","CLP","MXN","ZAR"]},paymentMethod:{type:"string",description:"Preferred payment method (card, upi, netbanking, wallet, emi, cash, bank_transfer, boleto, pix)",enum:["card","upi","netbanking","wallet","emi","cash","bank_transfer","boleto","pix"]},customerInfo:{type:"object",properties:{firstName:{type:"string"},lastName:{type:"string"},email:{type:"string"},phone:{type:"string"},address:{type:"object",properties:{street:{type:"string"},city:{type:"string"},state:{type:"string"},country:{type:"string"},zipCode:{type:"string"}}}},required:["firstName","email"]}},required:["amount","currency"]}}}},responses:{200:{description:"Payment session created successfully",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},data:{type:"object",properties:{transaction_id:{type:"string"},payment_url:{type:"string"},payment_form_data:{type:"object"},amount:{type:"number"},fee:{type:"number"},total_amount:{type:"number"},currency:{type:"string"},gateway:{type:"string"},expires_at:{type:"string"},supported_methods:{type:"array",items:{type:"string"}}}}}}}}},400:{description:"Bad request - Invalid input data"},401:{description:"Unauthorized - User not authenticated"},500:{description:"Internal server error"}}};exports.default=async e=>{var t,r,a,s,o,i;const{user:n,body:u}=e,{amount:d,currency:l,paymentMethod:c,customerInfo:p}=u;if(!(null==n?void 0:n.id))throw(0,error_1.createError)({statusCode:401,message:"User not authenticated"});if(!d||d<=0)throw(0,error_1.createError)({statusCode:400,message:"Valid amount is required"});if(!l)throw(0,error_1.createError)({statusCode:400,message:"Currency is required"});try{const e=await db_1.models.depositGateway.findOne({where:{alias:"payu",status:!0}});if(!e)throw(0,error_1.createError)({statusCode:404,message:"PayU gateway not found or disabled"});(0,utils_1.validatePayUConfig)();if(!(0,utils_1.validatePayUCurrency)(l))throw(0,error_1.createError)({statusCode:400,message:`Unsupported currency: ${l}`});if(!(null===(t=e.currencies)||void 0===t?void 0:t.includes(l)))throw(0,error_1.createError)({statusCode:400,message:`Currency ${l} is not supported by PayU gateway`});const u=e.getFixedFee(l),m=e.getPercentageFee(l),y=e.getMinAmount(l),_=e.getMaxAmount(l);if(d<y)throw(0,error_1.createError)({statusCode:400,message:`Amount must be at least ${y} ${l}`});if(_&&d>_)throw(0,error_1.createError)({statusCode:400,message:`Amount cannot exceed ${_} ${l}`});const g=d*m/100+u,f=d+g,U=(0,utils_1.getPayUPaymentMethods)(l);if(c&&!(0,utils_1.validatePaymentMethod)(l,c))throw(0,error_1.createError)({statusCode:400,message:`Payment method ${c} not supported for ${l}`});const N=(0,utils_1.generatePayUTransactionId)(),C=(0,utils_1.formatPayUAmount)(f),P={firstName:(null==p?void 0:p.firstName)||n.firstName||"Customer",lastName:(null==p?void 0:p.lastName)||n.lastName||"",email:(null==p?void 0:p.email)||n.email,phone:(null==p?void 0:p.phone)||n.phone||"",address:{street:(null===(r=null==p?void 0:p.address)||void 0===r?void 0:r.street)||"",city:(null===(a=null==p?void 0:p.address)||void 0===a?void 0:a.city)||"",state:(null===(s=null==p?void 0:p.address)||void 0===s?void 0:s.state)||"",country:(null===(o=null==p?void 0:p.address)||void 0===o?void 0:o.country)||"",zipCode:(null===(i=null==p?void 0:p.address)||void 0===i?void 0:i.zipCode)||""}};if(!P.email)throw(0,error_1.createError)({statusCode:400,message:"Customer email is required"});const h=await db_1.models.transaction.create({uuid:N,userId:n.id,type:"DEPOSIT",status:"PENDING",amount:d,fee:g,description:`PayU deposit of ${d} ${l} (Fee: ${g} ${l})`,metadata:JSON.stringify({gateway:"payu",currency:l,paymentMethod:c||"card",customer:P,fees:{fixed:u,percentage:m,total:g},amounts:{base:d,fee:g,total:f},createdAt:(new Date).toISOString(),expiresAt:new Date(Date.now()+36e5).toISOString()})}),A={key:utils_1.PAYU_CONFIG.MERCHANT_KEY,txnid:N,amount:C,productinfo:`Wallet deposit - ${l}`,firstname:P.firstName,email:P.email,phone:P.phone,surl:`${process.env.FRONTEND_URL}${utils_1.PAYU_CONFIG.SUCCESS_URL}`,furl:`${process.env.FRONTEND_URL}${utils_1.PAYU_CONFIG.FAILURE_URL}`,hash:""};P.lastName&&(A.udf1=P.lastName);P.address.city&&(A.udf2=P.address.city);P.address.state&&(A.udf3=P.address.state);P.address.country&&(A.udf4=P.address.country);c&&(A.udf5=c);if(c)switch(c){case"upi":A.pg="UPI";break;case"netbanking":A.pg="NB";break;case"wallet":A.pg="WALLET";break;case"emi":A.pg="EMI";break;default:A.pg="CC"}A.hash=(0,utils_1.generatePayUHash)(A,utils_1.PAYU_CONFIG.MERCHANT_SALT);await h.update({referenceId:N,metadata:JSON.stringify({...JSON.parse(h.metadata||"{}"),payuRequest:A,paymentUrl:`${utils_1.PAYU_CONFIG.API_BASE_URL}/_payment`,callbackUrl:`${process.env.FRONTEND_URL}${utils_1.PAYU_CONFIG.CALLBACK_URL}`,successUrl:A.surl,failureUrl:A.furl,cancelUrl:`${process.env.FRONTEND_URL}${utils_1.PAYU_CONFIG.CANCEL_URL}`})});return{success:!0,data:{transaction_id:N,payment_url:`${utils_1.PAYU_CONFIG.API_BASE_URL}/_payment`,payment_form_data:A,amount:d,fee:g,total_amount:f,currency:l,gateway:"payu",expires_at:new Date(Date.now()+36e5).toISOString(),supported_methods:U,customer_info:{name:`${P.firstName} ${P.lastName}`.trim(),email:P.email,phone:P.phone},callback_url:`${process.env.FRONTEND_URL}${utils_1.PAYU_CONFIG.CALLBACK_URL}`,success_url:A.surl,failure_url:A.furl,cancel_url:`${process.env.FRONTEND_URL}${utils_1.PAYU_CONFIG.CANCEL_URL}`,limits:{min:y,max:_},fees:{fixed:u,percentage:m,total:g}}}}catch(e){throw(0,error_1.createError)({statusCode:500,message:e instanceof Error?e.message:"Failed to create PayU payment"})}};