"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),emails_1=require("@b/utils/emails"),console_1=require("@b/utils/console"),utils_1=require("./utils"),utils_2=require("@b/api/finance/utils");exports.metadata={summary:"Verifies a Paystack payment",description:"Verifies payment status with Paystack and updates transaction records",operationId:"verifyPaystackPayment",tags:["Finance","Deposit","Paystack"],requiresAuth:!0,logModule:"PAYSTACK_DEPOSIT",logTitle:"Verify Paystack payment",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{reference:{type:"string",description:"Payment reference from Paystack"},trxref:{type:"string",description:"Transaction reference (alternative parameter name)"}},anyOf:[{required:["reference"]},{required:["trxref"]}]}}}},responses:{200:{description:"Payment verification completed",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},data:{type:"object",properties:{transaction_id:{type:"string"},reference:{type:"string"},status:{type:"string"},amount:{type:"number"},currency:{type:"string"},gateway:{type:"string"},gateway_response:{type:"string"},paid_at:{type:"string"},channel:{type:"string"},fees:{type:"number"}}}}}}}},400:{description:"Bad request - Invalid parameters"},401:{description:"Unauthorized"},404:{description:"Transaction not found"},500:{description:"Internal server error"}}};exports.default=async e=>{const{user:t,body:a}=e,{reference:r,trxref:s}=a;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"User not authenticated"});const n=r||s;if(!n)throw(0,error_1.createError)({statusCode:400,message:"Payment reference is required"});try{(0,utils_1.validatePaystackConfig)();const e=await db_1.models.transaction.findOne({where:{id:n,userId:t.id}});if(!e)throw(0,error_1.createError)({statusCode:404,message:"Transaction not found"});if("COMPLETED"===e.status)return{success:!0,data:{transaction_id:e.id,reference:n,status:"COMPLETED",amount:e.amount,currency:e.currency,gateway:"paystack",gateway_response:"Already completed",paid_at:e.updatedAt,channel:"unknown",fees:e.fee||0}};const a=await(0,utils_1.makePaystackRequest)(`/transaction/verify/${n}`,{method:"GET"});if(!a.status||!a.data)throw(0,error_1.createError)({statusCode:400,message:a.message||"Failed to verify payment with Paystack"});const r=a.data,s=(0,utils_1.mapPaystackStatus)(r.status),i=(0,utils_1.parsePaystackAmount)(r.amount,r.currency),o=(0,utils_1.parsePaystackAmount)(r.fees||0,r.currency);if(Math.abs(i-e.amount)>.01)throw(0,error_1.createError)({statusCode:400,message:"Transaction amount mismatch"});if(r.currency!==e.currency)throw(0,error_1.createError)({statusCode:400,message:"Transaction currency mismatch"});await e.update({status:s,referenceId:r.reference,fee:o,metadata:JSON.stringify({...JSON.parse(e.metadata||"{}"),paystack_transaction_id:r.id,paystack_status:r.status,gateway_response:r.gateway_response,paid_at:r.paid_at,channel:r.channel,authorization:r.authorization,customer:r.customer,fees_breakdown:r.fees_breakdown})});if("COMPLETED"===s){const a=await(0,utils_2.processFiatDeposit)({userId:t.id,currency:e.currency,amount:e.amount,fee:o,referenceId:r.reference,method:"PAYSTACK",description:`Paystack deposit of ${e.amount} ${e.currency}`,metadata:{paystack_transaction_id:r.id,channel:r.channel},idempotencyKey:`paystack_deposit_${n}`});try{await(0,emails_1.sendFiatTransactionEmail)(t,e,e.currency,a.newBalance)}catch(e){console_1.logger.error("PAYSTACK","Failed to send confirmation email",e)}return{success:!0,data:{transaction_id:e.id,reference:n,status:s,amount:i,currency:r.currency,gateway:"paystack",gateway_response:r.gateway_response,paid_at:r.paid_at,channel:r.channel,fees:o}}}return{success:!0,data:{transaction_id:e.id,reference:n,status:s,amount:i,currency:r.currency,gateway:"paystack",gateway_response:r.gateway_response,paid_at:r.paid_at,channel:r.channel,fees:o}}}catch(e){if(e instanceof utils_1.PaystackError)throw(0,error_1.createError)({statusCode:e.status,message:e.message});if(e.statusCode)throw e;throw(0,error_1.createError)({statusCode:500,message:"Failed to verify Paystack payment"})}};