"use strict";function validatePaystackConfig(){if(!exports.PAYSTACK_CONFIG.SECRET_KEY)throw new PaystackError("Paystack secret key is not configured","CONFIG_ERROR",500);if(!exports.PAYSTACK_CONFIG.PUBLIC_KEY)throw new PaystackError("Paystack public key is not configured","CONFIG_ERROR",500)}function isCurrencySupported(e){return Object.keys(exports.PAYSTACK_CURRENCY_REGIONS).includes(e.toUpperCase())}function getCurrencyInfo(e){const t=e.toUpperCase();return exports.PAYSTACK_CURRENCY_REGIONS[t]||null}function getAvailablePaymentMethods(e){const t=getCurrencyInfo(e);return(null==t?void 0:t.methods)||[]}function formatPaystackAmount(e,t){const r=exports.PAYSTACK_CURRENCY_DECIMALS[t.toUpperCase()]||2;return Math.round(e*Math.pow(10,r))}function parsePaystackAmount(e,t){const r=exports.PAYSTACK_CURRENCY_DECIMALS[t.toUpperCase()]||2;return e/Math.pow(10,r)}function mapPaystackStatus(e){return exports.PAYSTACK_STATUS_MAPPING[e.toLowerCase()]||"PENDING"}function generatePaystackReference(){return`PS_${Date.now()}_${Math.random().toString(36).substring(2,8)}`.toUpperCase()}async function makePaystackRequest(e,t={}){const{method:r="GET",body:o,headers:n={}}=t;try{validatePaystackConfig();const t=`${exports.PAYSTACK_CONFIG.API_BASE_URL}${e}`,a={method:r,headers:{Authorization:`Bearer ${exports.PAYSTACK_CONFIG.SECRET_KEY}`,"Content-Type":"application/json","User-Agent":"Paystack-Integration/1.0",...n},signal:AbortSignal.timeout(exports.PAYSTACK_CONFIG.TIMEOUT)};!o||"POST"!==r&&"PUT"!==r&&"PATCH"!==r||(a.body=JSON.stringify(o));const s=await fetch(t,a),c=await s.json();if(!s.ok){const e=c.message||`HTTP ${s.status}: ${s.statusText}`;throw new PaystackError(e,"API_ERROR",s.status,c)}return c}catch(e){if(e instanceof PaystackError)throw e;if(e instanceof Error){if("AbortError"===e.name)throw new PaystackError("Request timeout","TIMEOUT_ERROR",408);throw new PaystackError(e.message,"NETWORK_ERROR",500)}throw new PaystackError("Unknown error occurred","UNKNOWN_ERROR",500)}}function buildWebhookUrl(){return`${process.env.APP_PUBLIC_URL||"http://localhost:3000"}${exports.PAYSTACK_CONFIG.WEBHOOK_ENDPOINT}`}function buildReturnUrl(){return`${process.env.APP_PUBLIC_URL||"http://localhost:3000"}${exports.PAYSTACK_CONFIG.RETURN_URL}`}function buildCancelUrl(){return`${process.env.APP_PUBLIC_URL||"http://localhost:3000"}/user/wallet/deposit/paystack/cancel`}function isTestMode(){return exports.PAYSTACK_CONFIG.SANDBOX}function getPaymentMethodDisplayName(e){return{card:"Credit/Debit Card",bank:"Bank Transfer",ussd:"USSD",qr:"QR Code",mobile_money:"Mobile Money",bank_transfer:"Direct Bank Transfer",mpesa:"M-PESA",eft:"Electronic Funds Transfer"}[e]||e.toUpperCase()}function validateWebhookSignature(e,t){try{return crypto_1.default.createHmac("sha512",exports.PAYSTACK_CONFIG.SECRET_KEY).update(e).digest("hex")===t}catch(e){return!1}}function calculatePaystackFees(e,t){const r=getCurrencyInfo(t);if(!r)return{fees:0,netAmount:e,grossAmount:e};const{percentage:o,fixed:n,cap:a}=r.fees.local;let s=e*o/100+n;a&&s>a&&(s=a);"NGN"===t&&e<2500&&(s=e*o/100);return{fees:Math.round(100*s)/100,netAmount:Math.round(100*(e-s))/100,grossAmount:e}}function getRegionFromCurrency(e){const t=getCurrencyInfo(e);return(null==t?void 0:t.region)||"Unknown"}function getCountryFromCurrency(e){const t=getCurrencyInfo(e);return(null==t?void 0:t.country)||"XX"}function getSupportedChannels(e){const t=getAvailablePaymentMethods(e),r={card:"card",bank:"bank",ussd:"ussd",qr:"qr",mobile_money:"mobile_money",bank_transfer:"bank_transfer",mpesa:"mobile_money",eft:"bank"};return t.map(e=>r[e]||e).filter(Boolean)}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.PaystackError=exports.PAYSTACK_WEBHOOK_EVENTS=exports.PAYSTACK_STATUS_MAPPING=exports.PAYSTACK_CURRENCY_DECIMALS=exports.PAYSTACK_CURRENCY_REGIONS=exports.PAYSTACK_CONFIG=void 0;exports.validatePaystackConfig=validatePaystackConfig;exports.isCurrencySupported=isCurrencySupported;exports.getCurrencyInfo=getCurrencyInfo;exports.getAvailablePaymentMethods=getAvailablePaymentMethods;exports.formatPaystackAmount=formatPaystackAmount;exports.parsePaystackAmount=parsePaystackAmount;exports.mapPaystackStatus=mapPaystackStatus;exports.generatePaystackReference=generatePaystackReference;exports.makePaystackRequest=makePaystackRequest;exports.buildWebhookUrl=buildWebhookUrl;exports.buildReturnUrl=buildReturnUrl;exports.buildCancelUrl=buildCancelUrl;exports.isTestMode=isTestMode;exports.getPaymentMethodDisplayName=getPaymentMethodDisplayName;exports.validateWebhookSignature=validateWebhookSignature;exports.calculatePaystackFees=calculatePaystackFees;exports.getRegionFromCurrency=getRegionFromCurrency;exports.getCountryFromCurrency=getCountryFromCurrency;exports.getSupportedChannels=getSupportedChannels;const crypto_1=__importDefault(require("crypto"));exports.PAYSTACK_CONFIG={API_BASE_URL:(process.env.APP_PAYSTACK_SANDBOX,"https://api.paystack.co"),SECRET_KEY:process.env.APP_PAYSTACK_SECRET_KEY||"",PUBLIC_KEY:process.env.APP_PAYSTACK_PUBLIC_KEY||"",SANDBOX:"true"===process.env.APP_PAYSTACK_SANDBOX,WEBHOOK_ENDPOINT:process.env.APP_PAYSTACK_WEBHOOK_ENDPOINT||"/api/finance/deposit/fiat/paystack/webhook",RETURN_URL:process.env.APP_PAYSTACK_RETURN_URL||"/user/wallet/deposit/paystack/verify",TIMEOUT:3e4,VERSION:"v1"};exports.PAYSTACK_CURRENCY_REGIONS={NGN:{region:"Nigeria",country:"NG",methods:["card","bank","ussd","qr","mobile_money","bank_transfer"],fees:{local:{percentage:1.5,fixed:100,cap:2e3},international:{percentage:3.9,fixed:100},usd:{percentage:3.9,fixed:0}}},GHS:{region:"Ghana",country:"GH",methods:["card","mobile_money"],fees:{local:{percentage:1.95,fixed:0},international:{percentage:1.95,fixed:0}}},ZAR:{region:"South Africa",country:"ZA",methods:["card","eft"],fees:{local:{percentage:2.9,fixed:100},international:{percentage:3.1,fixed:100}}},KES:{region:"Kenya",country:"KE",methods:["card","mpesa"],fees:{local:{percentage:2.9,fixed:0},international:{percentage:3.8,fixed:0},usd:{percentage:3.8,fixed:0}}},XOF:{region:"Côte d'Ivoire",country:"CI",methods:["card","mobile_money"],fees:{local:{percentage:3.2,fixed:0},international:{percentage:3.8,fixed:0}}},EGP:{region:"Egypt",country:"EG",methods:["card"],fees:{local:{percentage:2.7,fixed:250},international:{percentage:3.5,fixed:250}}},USD:{region:"International",country:"US",methods:["card"],fees:{local:{percentage:3.9,fixed:0},international:{percentage:3.9,fixed:0}}}};exports.PAYSTACK_CURRENCY_DECIMALS={NGN:2,GHS:2,ZAR:2,KES:2,XOF:0,EGP:2,USD:2};exports.PAYSTACK_STATUS_MAPPING={success:"COMPLETED",failed:"FAILED",abandoned:"CANCELLED",pending:"PENDING",processing:"PENDING",reversed:"REFUNDED",ongoing:"PENDING"};exports.PAYSTACK_WEBHOOK_EVENTS={CHARGE_SUCCESS:"charge.success",CHARGE_DISPUTE_CREATE:"charge.dispute.create",CHARGE_DISPUTE_REMIND:"charge.dispute.remind",CHARGE_DISPUTE_RESOLVE:"charge.dispute.resolve",INVOICE_CREATE:"invoice.create",INVOICE_PAYMENT_FAILED:"invoice.payment_failed",INVOICE_UPDATE:"invoice.update",SUBSCRIPTION_CREATE:"subscription.create",SUBSCRIPTION_DISABLE:"subscription.disable",SUBSCRIPTION_EXPIRING_CARDS:"subscription.expiring_cards",SUBSCRIPTION_NOT_RENEW:"subscription.not_renew",TRANSFER_SUCCESS:"transfer.success",TRANSFER_FAILED:"transfer.failed",TRANSFER_REVERSED:"transfer.reversed"};class PaystackError extends Error{constructor(e,t="PAYSTACK_ERROR",r=500,o){super(e);this.name="PaystackError";this.code=t;this.status=r;this.details=o}}exports.PaystackError=PaystackError;