"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),utils_1=require("./utils"),db_1=require("@b/db"),emails_1=require("@b/utils/emails"),console_1=require("@b/utils/console"),wallet_1=require("@b/services/wallet");exports.metadata={summary:"Handles Klarna webhook notifications",description:"Processes webhook notifications from Klarna for order status updates and payment confirmations.",operationId:"klarnaWebhook",tags:["Finance","Webhook"],logModule:"WEBHOOK",logTitle:"Klarna webhook",requestBody:{description:"Klarna webhook notification data",content:{"application/json":{schema:{type:"object",properties:{order_id:{type:"string",description:"Klarna order ID"},event_type:{type:"string",description:"Type of webhook event"},event_id:{type:"string",description:"Unique event identifier"},timestamp:{type:"string",description:"Event timestamp"}},required:["order_id","event_type"]}}}},responses:{200:{description:"Webhook processed successfully",content:{"application/json":{schema:{type:"object",properties:{status:{type:"string",description:"Processing status"},message:{type:"string",description:"Response message"}}}}}},400:{description:"Invalid webhook data",content:{"application/json":{schema:{type:"object",properties:{error:{type:"string"}}}}}},404:(0,query_1.notFoundMetadataResponse)("Order"),500:query_1.serverErrorResponse},requiresAuth:!1};exports.default=async e=>{const{body:t,headers:r,ctx:s}=e;console_1.logger.info("KLARNA",`Webhook received - event: ${t.event_type}, order: ${t.order_id}`);const{order_id:a,event_type:o,event_id:n,timestamp:i}=t;if(!a||!o)throw(0,error_1.createError)({statusCode:400,message:"Missing required webhook data: order_id and event_type"});try{const e=await db_1.models.transaction.findOne({where:{type:"DEPOSIT",status:["PENDING","PROCESSING"]},include:[{model:db_1.models.user,as:"user",required:!0}],order:[["createdAt","DESC"]]});if(!e){console_1.logger.warn("KLARNA",`No pending transaction found for order: ${a}`);null==s||s.success("Klarna deposit completed successfully");return{status:"ignored",message:"No matching transaction found"}}const t=JSON.parse(e.metadata||"{}");if(t.order_id!==a){console_1.logger.debug("KLARNA",`Order ID mismatch: expected ${t.order_id}, got ${a}`);return{status:"ignored",message:"Order ID does not match transaction"}}if(t.processed_events&&t.processed_events.includes(n)){console_1.logger.debug("KLARNA",`Event ${n} already processed for order ${a}`);return{status:"duplicate",message:"Event already processed"}}const r=await(0,utils_1.makeKlarnaRequest)(`/ordermanagement/v1/orders/${a}`,"GET");if(!r)throw(0,error_1.createError)({statusCode:500,message:`Failed to retrieve order details for ${a}`});console_1.logger.info("KLARNA",`Order ${a} status: ${r.status}`);const d=r.status&&utils_1.KLARNA_STATUS_MAPPING[r.status]||"PENDING",c={...t,last_event_type:o,last_event_id:n,last_event_timestamp:i,current_klarna_status:r.status,processed_events:[...t.processed_events||[],n],webhook_updated_at:(new Date).toISOString()};if("COMPLETED"===d||"CAPTURED"===r.status){const r=e.user,n=t.purchase_currency;null==s||s.step("Finding or creating wallet");const i=(await wallet_1.walletCreationService.getOrCreateWallet(r.id,"FIAT",n)).wallet;null==s||s.step("Validating currency");const d=await db_1.models.currency.findOne({where:{id:i.currency}});if(!d){null==s||s.fail("Currency not found");throw(0,error_1.createError)({statusCode:404,message:"Currency not found"})}const l=e.amount-e.fee;let u=i.balance+l;u=parseFloat(u.toFixed(d.precision||2));await db_1.sequelize.transaction(async t=>{await db_1.models.transaction.update({status:"COMPLETED",metadata:JSON.stringify({...c,completed_at:(new Date).toISOString()}),description:`Klarna deposit of ${l} ${n} completed by ${r.firstName} ${r.lastName}`},{where:{id:e.id},transaction:t});null==s||s.step("Updating wallet balance via wallet service");const d=`klarna_webhook_${a}`;await wallet_1.walletService.credit({idempotencyKey:d,userId:r.id,walletId:i.id,walletType:"FIAT",currency:n,amount:l,operationType:"DEPOSIT",referenceId:a,description:`Klarna deposit of ${l} ${n}`,metadata:{method:"KLARNA",orderId:a,eventType:o},transaction:t});e.fee>0&&await db_1.models.adminProfit.create({amount:e.fee,currency:i.currency,type:"DEPOSIT",description:`Klarna deposit fee from ${r.firstName} ${r.lastName}`},{transaction:t})});try{null==s||s.step("Sending notification email");await(0,emails_1.sendFiatTransactionEmail)(r,{...e.dataValues,type:"DEPOSIT",amount:l,status:"COMPLETED",description:`Klarna deposit of ${l} ${n} completed`},n,u)}catch(e){console_1.logger.error("KLARNA","Failed to send confirmation email",e)}console_1.logger.success("KLARNA",`Payment completed for user ${r.id}, order ${a}`);return{status:"completed",message:"Payment processed successfully",order_id:a,transaction_id:e.id}}if("FAILED"===d||"CANCELLED"===r.status){await db_1.models.transaction.update({status:"FAILED",metadata:JSON.stringify({...c,failure_reason:`Klarna order status: ${r.status}`,failed_at:(new Date).toISOString()})},{where:{id:e.id}});console_1.logger.warn("KLARNA",`Payment failed for order ${a}, status: ${r.status}`);return{status:"failed",message:"Payment failed",order_id:a,reason:r.status}}await db_1.models.transaction.update({metadata:JSON.stringify(c)},{where:{id:e.id}});console_1.logger.info("KLARNA",`Order ${a} status updated to: ${r.status}`);return{status:"updated",message:"Status updated",order_id:a,current_status:r.status}}catch(e){console_1.logger.error("KLARNA","Webhook processing error",e);if(e instanceof utils_1.KlarnaError)throw(0,error_1.createError)({statusCode:400,message:`Klarna webhook error: ${e.message}`});throw(0,error_1.createError)({statusCode:500,message:`Webhook processing failed: ${e.message}`})}};