"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),utils_1=require("./utils"),db_1=require("@b/db"),publicUrl=process.env.NEXT_PUBLIC_SITE_URL,isProduction="production"===process.env.NODE_ENV;exports.metadata={summary:"Creates a Klarna payment session",description:"Initiates a Klarna payment process by creating a payment session with Buy Now, Pay Later options. Supports multiple payment methods including Pay Now, Pay Later, and Pay in Installments.",operationId:"createKlarnaPayment",tags:["Finance","Deposit"],logModule:"KLARNA_DEPOSIT",logTitle:"Create Klarna payment session",requestBody:{description:"Payment information for Klarna session",content:{"application/json":{schema:{type:"object",properties:{amount:{type:"number",description:"Payment amount in base currency units"},currency:{type:"string",description:"Currency code (e.g., USD, EUR, GBP)"},country:{type:"string",description:"Purchase country code (e.g., US, GB, DE)",nullable:!0},payment_method:{type:"string",description:"Preferred Klarna payment method",enum:["pay_now","pay_later","pay_over_time"],nullable:!0},customer:{type:"object",description:"Customer information",properties:{email:{type:"string",format:"email"},phone:{type:"string"},given_name:{type:"string"},family_name:{type:"string"},date_of_birth:{type:"string",format:"date"}},nullable:!0},billing_address:{type:"object",description:"Billing address information",properties:{given_name:{type:"string"},family_name:{type:"string"},email:{type:"string",format:"email"},phone:{type:"string"},street_address:{type:"string"},postal_code:{type:"string"},city:{type:"string"},region:{type:"string"},country:{type:"string"}},nullable:!0}},required:["amount","currency"]}}}},responses:{200:{description:"Klarna payment session created successfully. Returns session details and client token for frontend integration.",content:{"application/json":{schema:{type:"object",properties:{session_id:{type:"string",description:"Klarna session ID"},client_token:{type:"string",description:"Client token for Klarna SDK"},payment_method_categories:{type:"array",description:"Available payment methods",items:{type:"object",properties:{identifier:{type:"string"},name:{type:"string"},asset_urls:{type:"object",properties:{descriptive:{type:"string"},standard:{type:"string"}}}}}},purchase_country:{type:"string",description:"Purchase country code"},purchase_currency:{type:"string",description:"Purchase currency code"},order_amount:{type:"number",description:"Total order amount in minor units"},reference:{type:"string",description:"Merchant reference for this payment"}}}}}},400:{description:"Invalid request parameters",content:{"application/json":{schema:{type:"object",properties:{error:{type:"string"},details:{type:"object"}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Klarna"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{var t;const{user:r,body:n,ctx:a}=e;if(!r)throw(0,error_1.createError)({statusCode:401,message:"User not authenticated"});const{amount:s,currency:o,country:i,payment_method:c,customer:u,billing_address:p}=n;if(!s||s<=0)throw(0,error_1.createError)({statusCode:400,message:"Amount must be greater than 0"});if(!(0,utils_1.validateCurrency)(o))throw(0,error_1.createError)({statusCode:400,message:`Currency ${o} is not supported by Klarna`});null==a||a.step("Fetching payment gateway configuration");const l=await db_1.models.depositGateway.findOne({where:{alias:"klarna",status:!0}});if(!l){null==a||a.fail("Payment gateway not found");throw(0,error_1.createError)({statusCode:404,message:"Klarna gateway not found or disabled"})}if(!(null===(t=l.currencies)||void 0===t?void 0:t.includes(o)))throw(0,error_1.createError)({statusCode:400,message:`Currency ${o} is not supported by Klarna gateway`});let d=i;if(!d)for(const[e,t]of Object.entries(utils_1.KLARNA_COUNTRY_CURRENCY_MAP))if(t.includes(o)){d=e;break}if(!d)throw(0,error_1.createError)({statusCode:400,message:`No supported country found for currency ${o}`});const y=utils_1.KLARNA_COUNTRY_CURRENCY_MAP[d];if(!y||!y.includes(o))throw(0,error_1.createError)({statusCode:400,message:`Currency ${o} is not supported in country ${d}`});const m=utils_1.KLARNA_LOCALE_MAP[d]||"en-US",{fixedFee:_,percentageFee:f}=l,g=s*(f||0)/100+(_||0),h=s+g,b=(0,utils_1.convertToKlarnaAmount)(h);null==a||a.step("Calculating fees");const K=(0,utils_1.convertToKlarnaAmount)(g),v=(0,utils_1.generateKlarnaReference)(),C=[{type:"physical",reference:"deposit",name:"Account Deposit",quantity:1,unit_price:(0,utils_1.convertToKlarnaAmount)(s),tax_rate:0,total_amount:(0,utils_1.convertToKlarnaAmount)(s),total_tax_amount:0}];g>0&&C.push({type:"fee",reference:"processing_fee",name:"Processing Fee",quantity:1,unit_price:(0,utils_1.convertToKlarnaAmount)(g),tax_rate:0,total_amount:(0,utils_1.convertToKlarnaAmount)(g),total_tax_amount:0});const w=`${publicUrl}${isProduction?"":":3000"}`,P={purchase_country:d,purchase_currency:o,locale:m,order_amount:b,order_tax_amount:K,order_lines:C,merchant_urls:{terms:`${w}/terms`,confirmation:`${w}/api/finance/deposit/fiat/klarna/verify?session_id={checkout.order.id}`,push:`${w}/api/finance/deposit/fiat/klarna/webhook`,authorization:`${w}/api/finance/deposit/fiat/klarna/authorize`},merchant_reference1:v,merchant_reference2:r.id,options:{allow_separate_shipping_address:!1,date_of_birth_mandatory:!1,title_mandatory:!1,phone_mandatory:!1,show_subtotal_detail:!0,allowed_customer_types:["person"],purchase_type:"buy"}};if(u||r.email){P.customer={type:"person",...u};P.billing_address={given_name:(null==u?void 0:u.given_name)||r.firstName||"",family_name:(null==u?void 0:u.family_name)||r.lastName||"",email:(null==u?void 0:u.email)||r.email,country:d,...p}}try{const e=await(0,utils_1.makeKlarnaRequest)("/payments/v1/sessions","POST",P);await db_1.models.transaction.create({userId:r.id,type:"DEPOSIT",amount:h,fee:g,referenceId:e.session_id,status:"PENDING",metadata:JSON.stringify({method:"KLARNA",session_id:e.session_id,merchant_reference:v,purchase_country:d,purchase_currency:o,payment_method:c||"auto",klarna_reference:e.klarna_reference}),description:`Klarna deposit of ${s} ${o} initiated by ${r.firstName} ${r.lastName}`});return{session_id:e.session_id,client_token:e.client_token,payment_method_categories:e.payment_method_categories,purchase_country:d,purchase_currency:o,order_amount:b,reference:v,html_snippet:e.html_snippet}}catch(e){if(e instanceof utils_1.KlarnaError)throw(0,error_1.createError)({statusCode:500,message:`Klarna payment session creation failed: ${e.message}`});throw(0,error_1.createError)({statusCode:500,message:`Failed to create Klarna payment session: ${e.message}`})}};