"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.makeDLocalRequest=exports.DLocalError=exports.DLOCAL_STATUS_MAPPING=exports.COUNTRY_DOCUMENT_REQUIREMENTS=exports.validateCurrency=exports.DLOCAL_SUPPORTED_CURRENCIES=exports.getDLocalHeaders=exports.verifyWebhookSignature=exports.generateSignature=exports.getDLocalConfig=void 0;const crypto_1=__importDefault(require("crypto")),error_1=require("@b/utils/error"),getDLocalConfig=()=>{const e=process.env.APP_DLOCAL_X_LOGIN,r=process.env.APP_DLOCAL_X_TRANS_KEY,t=process.env.APP_DLOCAL_SECRET_KEY,a="production"===process.env.NODE_ENV;if(!e||!r||!t)throw(0,error_1.createError)({statusCode:500,message:"dLocal credentials are not properly configured in environment variables"});return{xLogin:e,xTransKey:r,secretKey:t,baseUrl:a?"https://api.dlocal.com":"https://sandbox.dlocal.com",version:"2.1"}};exports.getDLocalConfig=getDLocalConfig;const generateSignature=(e,r,t,a)=>{const i=e+r+t;return`V2-HMAC-SHA256, Signature: ${crypto_1.default.createHmac("sha256",a).update(i,"utf8").digest("hex")}`};exports.generateSignature=generateSignature;const verifyWebhookSignature=(e,r,t,a,i)=>{try{return e===(0,exports.generateSignature)(r,t,a,i)}catch(e){return!1}};exports.verifyWebhookSignature=verifyWebhookSignature;const getDLocalHeaders=(e,r,t,a)=>({"X-Date":t,"X-Login":e,"X-Trans-Key":r,"Content-Type":"application/json","X-Version":"2.1","User-Agent":"v5-platform/1.0",Authorization:a});exports.getDLocalHeaders=getDLocalHeaders;exports.DLOCAL_SUPPORTED_CURRENCIES=["ARS","BOB","BRL","CLP","COP","CRC","DOP","USD","GTQ","HNL","MXN","NIO","PYG","PEN","UYU","BDT","CNY","INR","IDR","JPY","MYR","PKR","PHP","THB","VND","XAF","CDF","EGP","GHS","XOF","JOD","KES","MAD","NGN","OMR","QAR","RWF","SAR","ZAR","TZS","TRY","UGX","ZMW"];const validateCurrency=e=>exports.DLOCAL_SUPPORTED_CURRENCIES.includes(e.toUpperCase());exports.validateCurrency=validateCurrency;exports.COUNTRY_DOCUMENT_REQUIREMENTS={AR:{required:!0,name:"DNI, CUIT, or CUIL",format:"Between 7 to 9 or 11 digits"},BD:{required:!0,name:"NID Card",format:"13-17 digits"},BO:{required:!0,name:"CI",format:"Between 5 to 20 digits"},BR:{required:!0,name:"CPF or CNPJ",format:"11 digits for CPF, 14 for CNPJ"},CM:{required:!0,name:"CNI or ID",format:"8 digits"},CL:{required:!0,name:"CI or RUT",format:"Between 8 to 9 characters"},CN:{required:!0,name:"Citizen ID",format:"18 digits or 17 digits + letter X"},CO:{required:!0,name:"CC",format:"Between 6 to 10 digits"},CR:{required:!0,name:"CI",format:"9 digits"},CD:{required:!0,name:"National ID Card",format:"12 digits alphanumeric"},DO:{required:!1,name:"ID",format:"11 digits"},EC:{required:!0,name:"CI",format:"Between 5 to 20 digits"},SV:{required:!0,name:"DUI",format:"9 digits"},EG:{required:!0,name:"ID",format:"14 digits"},GH:{required:!0,name:"Ghana Card",format:"13 digits (3 letters + 10 numbers)"},GT:{required:!0,name:"CUI",format:"13 digits"},HN:{required:!0,name:"DNI",format:"13 digits"},IN:{required:!0,name:"PAN",format:"10 characters (5 letters, 4 numbers, 1 letter)"},ID:{required:!0,name:"NIK",format:"16 digits"},CI:{required:!0,name:"CNI",format:"11 digits"},JP:{required:!0,name:"My Number",format:"12 digits"},JO:{required:!0,name:"National ID Card",format:"10 digits"},KE:{required:!0,name:"National ID Card",format:"8 digits"},MY:{required:!0,name:"NRIC",format:"12 digits"},MX:{required:!0,name:"CURP",format:"Between 10 to 18 characters"},MA:{required:!0,name:"CNIE",format:"Between 5 to 20 characters"},NI:{required:!0,name:"DNI",format:"14 digits (13 numbers, 1 letter)"},NE:{required:!0,name:"CNI",format:"7 digits"},NG:{required:!0,name:"NIN",format:"11 digits"},OM:{required:!0,name:"National ID Card",format:"9 digits"},PK:{required:!0,name:"CNIC",format:"13 digits"},PA:{required:!1,name:"Cedula de Identidad",format:"8 digits"},PY:{required:!0,name:"CI",format:"Between 5 to 20 digits"},PE:{required:!0,name:"DNI",format:"Between 8 to 9 digits"},PH:{required:!0,name:"PSN",format:"12 digits"},QA:{required:!0,name:"National ID Card",format:"8 digits"},RW:{required:!0,name:"National Identity Card",format:"16 digits"},SA:{required:!0,name:"National ID Card",format:"10 digits"},SN:{required:!0,name:"CNI or ECOWAS ID Card",format:"13 to 17 digits"},ZA:{required:!0,name:"South African Identity Card",format:"13 digits"},TZ:{required:!0,name:"National Identity Card",format:"20 digits"},TH:{required:!0,name:"Thai Identity Card",format:"13 digits"},TR:{required:!0,name:"T.C. Kimlik No.",format:"Between 5 to 20 digits"},UG:{required:!0,name:"National ID number",format:"Between 14 to 17 digits"},UY:{required:!0,name:"CI or RUT",format:"Between 6 to 8 digits or 12 digits"},VN:{required:!0,name:"VNID",format:"Between 9 or 13 digits"},ZM:{required:!1,name:"National Registration Card",format:"9 digits"}};exports.DLOCAL_STATUS_MAPPING={PENDING:"pending",PAID:"completed",REJECTED:"failed",CANCELLED:"cancelled",EXPIRED:"expired",AUTHORIZED:"authorized",REFUNDED:"refunded",PARTIALLY_REFUNDED:"partially_refunded",CHARGEBACK:"chargeback"};class DLocalError extends Error{constructor(e,r="DLOCAL_ERROR",t=500){super(e);this.name="DLocalError";this.code=r;this.statusCode=t}}exports.DLocalError=DLocalError;const makeDLocalRequest=async(e,r,t)=>{const a=(0,exports.getDLocalConfig)(),i=(new Date).toISOString(),o=t?JSON.stringify(t):"",n=(0,exports.generateSignature)(a.xLogin,i,o,a.secretKey),s=(0,exports.getDLocalHeaders)(a.xLogin,a.xTransKey,i,n),d=`${a.baseUrl}${e}`,m={method:r,headers:s};!t||"POST"!==r&&"PUT"!==r||(m.body=o);try{const e=await fetch(d,m),r=await e.json();if(!e.ok)throw new DLocalError(r.message||`dLocal API Error: ${e.status}`,r.code||"API_ERROR",e.status);return r}catch(e){if(e instanceof DLocalError)throw e;throw new DLocalError(`Network error: ${e.message}`,"NETWORK_ERROR",500)}};exports.makeDLocalRequest=makeDLocalRequest;