"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),utils_1=require("./utils"),query_1=require("@b/utils/query");exports.metadata={summary:"Get exchange rate between two currencies",description:"Returns the exchange rate between two currencies given their wallet types.",operationId:"getExchangeRate",tags:["Finance","Currency"],logModule:"FINANCE",logTitle:"Get currency exchange rate",parameters:[{name:"fromCurrency",in:"query",description:"The currency to convert from",required:!0,schema:{type:"string"}},{name:"fromType",in:"query",description:"The wallet type of the currency to convert from",required:!0,schema:{type:"string"}},{name:"toCurrency",in:"query",description:"The currency to convert to",required:!0,schema:{type:"string"}},{name:"toType",in:"query",description:"The wallet type of the currency to convert to",required:!0,schema:{type:"string"}}],requiresAuth:!0,responses:{200:{description:"Exchange rate retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{...utils_1.baseResponseSchema,data:{type:"number",description:"Exchange rate from fromCurrency to toCurrency"}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Currency"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{user:r,query:t,ctx:a}=e;if(!(null==r?void 0:r.id)){null==a||a.fail("User not authenticated");throw(0,error_1.createError)(401,"Unauthorized")}const{fromCurrency:n,fromType:c,toCurrency:i,toType:s}=t;null==a||a.step("Validating exchange rate parameters");if(!(n&&c&&i&&s)){null==a||a.fail("Missing required query parameters");throw(0,error_1.createError)(400,"Missing required query parameters")}if(n===i&&c===s){null==a||a.success(`Exchange rate for ${n} to ${i} (same currency): 1`);return{status:!0,message:"Exchange rate retrieved successfully",data:1}}null==a||a.step(`Fetching USD price for ${n} (${c})`);let o,u;switch(c){case"FIAT":o=await(0,utils_1.getFiatPriceInUSD)(n);break;case"SPOT":o=await(0,utils_1.getSpotPriceInUSD)(n);break;case"ECO":o=await(0,utils_1.getEcoPriceInUSD)(n);break;default:null==a||a.fail(`Invalid source wallet type: ${c}`);throw(0,error_1.createError)(400,`Invalid fromType: ${c}`)}null==a||a.step(`Fetching USD price for ${i} (${s})`);switch(s){case"FIAT":u=await(0,utils_1.getFiatPriceInUSD)(i);break;case"SPOT":u=await(0,utils_1.getSpotPriceInUSD)(i);break;case"ECO":u=await(0,utils_1.getEcoPriceInUSD)(i);break;default:null==a||a.fail(`Invalid target wallet type: ${s}`);throw(0,error_1.createError)(400,`Invalid toType: ${s}`)}null==a||a.step("Calculating exchange rate");const l=u/o;null==a||a.success(`Exchange rate calculated: ${n} to ${i} = ${l}`);return l};