"use strict";async function getTokenIconFromCache(e){const t=`${CACHE_KEY_PREFIX}${e}`;return await redis.get(t)}async function setTokenIconInCache(e,t){const r=`${CACHE_KEY_PREFIX}${e}`;await redis.set(r,t,"EX",3600)}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const utils_1=require("./utils"),db_1=require("@b/db"),redis_1=require("@b/utils/redis"),sequelize_1=require("sequelize"),redis=redis_1.RedisSingleton.getInstance(),query_1=require("@b/utils/query");exports.metadata={summary:"List Exchange Markets",operationId:"listMarkets",tags:["Exchange","Markets"],description:"Retrieves a list of all available markets.",parameters:[{name:"eco",in:"query",required:!0,description:"include eco",schema:{type:"string"}}],responses:{200:{description:"A list of markets",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:utils_1.baseMarketSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Market"),500:query_1.serverErrorResponse}};const CACHE_KEY_PREFIX="ecosystem_token_icon:",CACHE_EXPIRY=3600;exports.default=async e=>{const{query:t,ctx:r}=e,{eco:s}=t;null==r||r.step("Fetching exchange markets");const n=await db_1.models.exchangeMarket.findAll({where:{status:!0}});let a=[];if("true"===s){a=await db_1.models.ecosystemMarket.findAll({where:{status:!0}});const e=Array.from(new Set(a.map(e=>e.currency).filter(e=>void 0!==e))),t={},r=[];for(const s of e){const e=await getTokenIconFromCache(s);null!==e?t[s]=e:r.push(s)}if(r.length>0){const e=await db_1.models.ecosystemToken.findAll({where:{currency:{[sequelize_1.Op.in]:r}}});for(const r of e)if(r.currency&&r.icon){t[r.currency]=r.icon;await setTokenIconInCache(r.currency,r.icon)}}a=a.map(e=>{const r=e.currency&&t[e.currency]||null;return{...e.get({plain:!0}),icon:r,isEco:!0}})}const c=[...n.map(e=>({...e.get({plain:!0}),symbol:`${e.currency}/${e.pair}`,isEco:!1})),...a.map(e=>({...e,symbol:`${e.currency}/${e.pair}`}))];null==r||r.success(`Retrieved ${c.length} markets (${n.length} exchange, ${a.length} ecosystem)`);return c};