"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query");exports.metadata={summary:"List Binary Markets",operationId:"listBinaryMarkets",tags:["Exchange","Binary","Markets"],description:"Retrieves a list of all available binary trading markets.",logModule:"EXCHANGE",logTitle:"Get Binary Markets",responses:{200:{description:"A list of binary markets",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{id:{type:"string",description:"Market ID"},currency:{type:"string",description:"Base currency"},pair:{type:"string",description:"Quote currency"},isTrending:{type:"boolean",description:"Whether the market is trending"},isHot:{type:"boolean",description:"Whether the market is hot"},status:{type:"boolean",description:"Market status"}}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Binary Market"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{ctx:r}=e;try{null==r||r.step("Fetching binary markets");const e=(await db_1.models.binaryMarket.findAll({where:{status:!0},order:[["isTrending","DESC"],["isHot","DESC"],["currency","ASC"]]})).map(e=>({...e.get({plain:!0}),label:`${e.currency}/${e.pair}`,symbol:`${e.currency}/${e.pair}`}));null==r||r.success(`Retrieved ${e.length} binary markets`);return e}catch(e){console.error("Error fetching binary markets:",e);throw e}};