"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const pow_captcha_1=require("@b/utils/pow-captcha"),error_1=require("@b/utils/error");exports.metadata={summary:"Get a proof-of-work challenge",description:"Generates a new proof-of-work challenge for bot protection. The client must solve this challenge before submitting forms.",operationId:"getPowChallenge",tags:["Auth"],requiresAuth:!1,parameters:[{name:"action",in:"query",required:!0,schema:{type:"string",enum:["login","register","reset"],description:"The action this challenge is for"}}],responses:{200:{description:"Challenge generated successfully",content:{"application/json":{schema:{type:"object",properties:{enabled:{type:"boolean",description:"Whether PoW captcha is enabled"},challenge:{type:"string",description:"The challenge string to solve"},difficulty:{type:"number",description:"Number of leading zero bits required in hash"},timestamp:{type:"number",description:"Challenge creation timestamp"},expiresIn:{type:"number",description:"Time until challenge expires (ms)"}}}}}},400:{description:"Invalid request"},429:{description:"Too many requests"}}};exports.default=async e=>{var r,t;const{query:o,headers:a}=e,{action:i}=o;if(!await(0,pow_captcha_1.isPowCaptchaEnabled)())return{enabled:!1};if(!i||!["login","register","reset"].includes(i))throw(0,error_1.createError)({statusCode:400,message:"Invalid or missing action parameter"});try{const e=(null===(t=null===(r=null==a?void 0:a["x-forwarded-for"])||void 0===r?void 0:r.split(",")[0])||void 0===t?void 0:t.trim())||(null==a?void 0:a["x-real-ip"])||"unknown";return{enabled:!0,...await(0,pow_captcha_1.generatePowChallenge)(i,e)}}catch(e){if(e instanceof Error&&e.message.includes("Too many"))throw(0,error_1.createError)({statusCode:429,message:e.message});throw(0,error_1.createError)({statusCode:500,message:"Failed to generate challenge"})}};