"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const token_1=require("@b/utils/token"),error_1=require("@b/utils/error");exports.metadata={summary:"Logs out the current user",operationId:"logoutUser",tags:["Auth"],description:"Logs out the current user and clears all session tokens",requiresAuth:!0,logModule:"LOGOUT",logTitle:"User logout",responses:{200:{description:"User logged out successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"}}}}}},401:{description:"Unauthorized, no user to log out"}}};exports.default=async e=>{const{ctx:s}=e;try{null==s||s.step("Validating session");if(!e.cookies.sessionId){null==s||s.fail("No active session found");throw(0,error_1.createError)({statusCode:401,message:"No active session found"})}null==s||s.step("Deleting session");await(0,token_1.deleteSession)(e.cookies.sessionId);null==s||s.step("Clearing user data");e.setUser(null);null==s||s.success("User logged out successfully");return{message:"You have been logged out",cookies:{accessToken:"",refreshToken:"",sessionId:"",csrfToken:""}}}catch(e){null==s||s.fail(e.message||"Logout failed");throw e}};