"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const token_1=require("@b/utils/token"),db_1=require("@b/db"),error_1=require("@b/utils/error"),emails_1=require("@b/utils/emails");exports.metadata={summary:"Generate account deletion confirmation code",operationId:"generateAccountDeletionCode",tags:["Account"],description:"Generates a code for confirming account deletion and sends it to the user's email.",requiresAuth:!0,logModule:"ACCOUNT",logTitle:"Request account deletion",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{email:{type:"string",format:"email",description:"Email of the user requesting account deletion"}},required:["email"]}}}},responses:{200:{description:"Deletion confirmation code generated successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"}}}}}},400:{description:"Invalid request",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Error message"}}}}}}}};exports.default=async e=>{const{body:t,ctx:o}=e,{email:i}=t;try{null==o||o.step("Validating account deletion request");if(!i){null==o||o.fail("Email is required");throw(0,error_1.createError)({statusCode:400,message:"Email is required"})}null==o||o.step(`Looking up user: ${i}`);const e=await db_1.models.user.findOne({where:{email:i}});if(!e){null==o||o.fail("User not found");throw(0,error_1.createError)({message:"User not found",statusCode:404})}null==o||o.step("Generating deletion confirmation token");const t=await(0,token_1.generateEmailToken)({user:{id:e.id}});try{null==o||o.step("Sending deletion confirmation email");await emails_1.emailQueue.add({emailData:{TO:e.email,FIRSTNAME:e.firstName,TOKEN:t},emailType:"AccountDeletionConfirmation"});null==o||o.success(`Deletion confirmation sent to ${i}`);return{message:"Deletion confirmation code sent successfully"}}catch(e){null==o||o.fail("Failed to send deletion confirmation email");throw(0,error_1.createError)({message:e.message,statusCode:500})}}catch(e){null==o||o.fail(e.message||"Account deletion request failed");throw e}};