"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),error_1=require("@b/utils/error");exports.metadata={summary:"Update chart cache settings",operationId:"updateChartSettings",tags:["Admin","Exchange","Chart"],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{cacheDays:{type:"number",description:"Number of days to cache chart data",minimum:1,maximum:365},rateLimit:{type:"number",description:"Delay in milliseconds between API requests",minimum:100,maximum:1e4},intervals:{type:"array",items:{type:"string"},description:"Intervals to cache"},autoUpdate:{type:"boolean",description:"Enable automatic chart data updates"}}}}}},responses:{200:{description:"Settings updated successfully",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},message:{type:"string"}}}}}},401:query_1.unauthorizedResponse,500:query_1.serverErrorResponse},requiresAuth:!0,permission:"manage.exchange.chart"};const VALID_INTERVALS=["1m","3m","5m","15m","30m","1h","2h","4h","6h","8h","12h","1d","3d","1w"];exports.default=async e=>{const{body:t}=e,{cacheDays:a,rateLimit:s,intervals:r,autoUpdate:i}=t;if(r){const e=r.filter(e=>!VALID_INTERVALS.includes(e));if(e.length>0)throw(0,error_1.createError)({statusCode:400,message:`Invalid intervals: ${e.join(", ")}`})}let n={};const o=await db_1.models.settings.findOne({where:{key:"chart_cache"}});if(null==o?void 0:o.value)try{n=JSON.parse(o.value)}catch(e){}const c={...n,...void 0!==a&&{cacheDays:a},...void 0!==s&&{rateLimit:s},...void 0!==r&&{intervals:r},...void 0!==i&&{autoUpdate:i}};o?await o.update({value:JSON.stringify(c)}):await db_1.models.settings.create({key:"chart_cache",value:JSON.stringify(c)});return{message:"Chart settings updated successfully",settings:c}};