"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.gatewayUpdateSchema=exports.baseGatewaySchema=void 0;const schema_1=require("@b/utils/schema"),name=(0,schema_1.baseStringSchema)("Name of the deposit gateway",100),title=(0,schema_1.baseStringSchema)("Title of the deposit gateway",100),description=(0,schema_1.baseStringSchema)("Description of the deposit gateway",500),image=(0,schema_1.baseStringSchema)("URL to an image representing the deposit gateway",255,0,!0),fixedFee={...(0,schema_1.baseNumberSchema)("Fixed fee for transactions through this gateway"),nullable:!0,minimum:0},percentageFee={...(0,schema_1.baseNumberSchema)("Percentage fee for transactions through this gateway"),nullable:!0,minimum:0,maximum:100},minAmount={...(0,schema_1.baseNumberSchema)("Minimum amount allowed through this gateway"),nullable:!0,minimum:0},maxAmount={...(0,schema_1.baseNumberSchema)("Maximum amount allowed through this gateway"),nullable:!0,minimum:0},status=(0,schema_1.baseBooleanSchema)("Current status of the deposit gateway (active or inactive)");exports.baseGatewaySchema={id:{...(0,schema_1.baseStringSchema)("ID of the deposit gateway"),nullable:!0},name:name,title:title,description:description,image:image,alias:{...(0,schema_1.baseStringSchema)("Unique alias for the deposit gateway"),nullable:!0},currencies:{type:"object",description:"Supported currencies in JSON format",nullable:!0},fixedFee:fixedFee,percentageFee:percentageFee,minAmount:minAmount,maxAmount:maxAmount,type:{...(0,schema_1.baseStringSchema)("Type of the deposit gateway"),nullable:!0},status:status,version:{...(0,schema_1.baseStringSchema)("Version of the deposit gateway"),nullable:!0},productId:{...(0,schema_1.baseStringSchema)("Product ID associated with the deposit gateway"),nullable:!0}};exports.gatewayUpdateSchema={type:"object",properties:{title:title,description:description,image:image,alias:{...(0,schema_1.baseStringSchema)("Unique alias for the deposit gateway"),nullable:!0},currencies:{type:"array",items:{type:"string"},description:"Supported currencies array",nullable:!0},fixedFee:{oneOf:[{type:"null"},{type:"number",minimum:0,description:"Global fixed fee for all currencies"},{type:"object",patternProperties:{"^[A-Z]{3,4}$":{type:"number",minimum:0}},additionalProperties:!1,description:"Currency-specific fixed fees"}]},percentageFee:{oneOf:[{type:"null"},{type:"number",minimum:0,maximum:100,description:"Global percentage fee for all currencies"},{type:"object",patternProperties:{"^[A-Z]{3,4}$":{type:"number",minimum:0,maximum:100}},additionalProperties:!1,description:"Currency-specific percentage fees"}]},minAmount:{oneOf:[{type:"null"},{type:"number",minimum:0,description:"Global minimum amount for all currencies"},{type:"object",patternProperties:{"^[A-Z]{3,4}$":{type:"number",minimum:0}},additionalProperties:!1,description:"Currency-specific minimum amounts"}]},maxAmount:{oneOf:[{type:"null"},{type:"number",minimum:0,description:"Global maximum amount for all currencies"},{type:"object",patternProperties:{"^[A-Z]{3,4}$":{type:"number",minimum:0}},additionalProperties:!1,description:"Currency-specific maximum amounts"}]},status:status},required:["title","description"]};