"use strict";function validateBinarySettings(e){const t=[];e.global.maxConcurrentOrders<1&&t.push("Max concurrent orders must be at least 1");for(const[r,n]of Object.entries(e.orderTypes)){(n.profitPercentage<0||n.profitPercentage>1e3)&&t.push(`${r}: Profit percentage must be between 0 and 1000`);if("barrierLevels"in n){const e=n;if(e.barrierLevels&&0!==e.barrierLevels.length)for(const n of e.barrierLevels){n.distancePercent<=0&&t.push(`${r}: Barrier distance must be positive`);(n.profitPercent<0||n.profitPercent>1e3)&&t.push(`${r}: Barrier profit must be between 0 and 1000`)}else n.enabled&&t.push(`${r}: At least one barrier level is required when enabled`)}if("strikeLevels"in n){const e=n;e.strikeLevels&&0!==e.strikeLevels.length||n.enabled&&t.push(`${r}: At least one strike level is required when enabled`)}}if(e.durations&&0!==e.durations.length){0===e.durations.filter(e=>e.enabled).length&&t.push("At least one duration must be enabled");for(const r of e.durations)r.minutes<1&&t.push("Duration must be at least 1 minute")}else t.push("At least one duration is required");return{valid:0===t.length,errors:t,warnings:generateWarnings(e)}}function generateWarnings(e){const t=[],r=e.orderTypes.HIGHER_LOWER;if(r.enabled&&r.barrierLevels){const e=Math.max(...r.barrierLevels.filter(e=>e.enabled).map(e=>e.distancePercent));e>2?t.push({level:"danger",category:"Barrier Risk",message:`HIGHER_LOWER max barrier distance (${e}%) allows nearly guaranteed wins`,suggestion:"Reduce max barrier distance to 1% or less, or reduce profit for far barriers",field:"orderTypes.HIGHER_LOWER.barrierLevels"}):e>1&&t.push({level:"warning",category:"Barrier Risk",message:`HIGHER_LOWER barrier distance (${e}%) may be too easy`,suggestion:"Consider reducing profit percentage for farther barriers",field:"orderTypes.HIGHER_LOWER.barrierLevels"})}const n=calculateAverageProfit(e);n>90&&t.push({level:"warning",category:"Profitability",message:`Average profit (${n.toFixed(1)}%) may not be sustainable`,suggestion:"Consider reducing profit percentages or adding more barrier tiers"});0===e.durations.filter(e=>e.enabled).length&&t.push({level:"danger",category:"Configuration",message:"No durations are enabled - trading will not work",suggestion:"Enable at least one duration",field:"durations"});0===e.riskManagement.dailyLossLimit&&t.push({level:"info",category:"Risk Management",message:"No daily loss limit is configured",suggestion:"Consider setting a daily loss limit to prevent large losses",field:"riskManagement"});const i=e.orderTypes.TOUCH_NO_TOUCH;if(i.enabled){const e=Math.min(...i.barrierLevels.filter(e=>e.enabled).map(e=>e.profitPercent));e<150&&t.push({level:"info",category:"Configuration",message:`TOUCH profit (${e}%) is low for a difficult trade type`,suggestion:"TOUCH trades are harder to win - consider higher profit percentage",field:"orderTypes.TOUCH_NO_TOUCH"})}const d=e.orderTypes.TURBO;d.enabled&&d.maxDuration>5&&t.push({level:"warning",category:"Configuration",message:`TURBO max duration (${d.maxDuration} min) is longer than typical`,suggestion:"Turbo trades are meant to be short (1-5 minutes)",field:"orderTypes.TURBO.maxDuration"});const a=Object.entries(e.orderTypes).filter(([e,t])=>t.enabled).map(([e,t])=>t.profitPercentage);a.length>1&&1===new Set(a).size&&t.push({level:"info",category:"Configuration",message:"All enabled order types have the same profit percentage",suggestion:"Consider differentiating profits based on trade difficulty"});return t}function calculateAverageProfit(e){const t=Object.values(e.orderTypes).filter(e=>e.enabled);if(0===t.length)return 0;return t.reduce((e,t)=>e+t.profitPercentage,0)/t.length}function findBarrierLevel(e,t,r){const n=e.orderTypes[t];if("barrierLevels"in n){return n.barrierLevels.find(e=>e.id===r)||null}return null}function findStrikeLevel(e,t){return e.orderTypes.CALL_PUT.strikeLevels.find(e=>e.id===t)||null}function calculateBarrierPrice(e,t,r){const n=e*(t.distancePercent/100);return r?e+n:e-n}function calculateStrikePrice(e,t,r){const n=e*(t.distancePercent/100);return r?e+n:e-n}function getProfitForLevel(e,t,r){if("CALL_PUT"===t){const t=findStrikeLevel(e,r);return(null==t?void 0:t.profitPercent)||e.orderTypes.CALL_PUT.profitPercentage}const n=findBarrierLevel(e,t,r);return(null==n?void 0:n.profitPercent)||e.orderTypes[t].profitPercentage}function isOrderTypeEnabled(e,t){return e.global.enabled&&e.orderTypes[t].enabled}function getEnabledBarrierLevels(e,t){const r=e.orderTypes[t];if("barrierLevels"in r){return r.barrierLevels.filter(e=>e.enabled)}return[]}function getEnabledStrikeLevels(e){return e.orderTypes.CALL_PUT.strikeLevels.filter(e=>e.enabled)}function getEnabledDurations(e){return e.durations.filter(e=>e.enabled)}function isDurationEnabledForType(e,t,r){var n;const i=e.durations.find(e=>e.id===t);if(!i||!i.enabled)return!1;const d=null===(n=i.orderTypeOverrides)||void 0===n?void 0:n[r];return!1!==(null==d?void 0:d.enabled)}function mergeWithDefaults(e){var t,r,n,i,d;return{...exports.DEFAULT_BINARY_SETTINGS,...e,global:{...exports.DEFAULT_BINARY_SETTINGS.global,...e.global||{}},display:{...exports.DEFAULT_BINARY_SETTINGS.display,...e.display||{}},orderTypes:{RISE_FALL:{...exports.DEFAULT_BINARY_SETTINGS.orderTypes.RISE_FALL,...(null===(t=e.orderTypes)||void 0===t?void 0:t.RISE_FALL)||{}},HIGHER_LOWER:{...exports.DEFAULT_BINARY_SETTINGS.orderTypes.HIGHER_LOWER,...(null===(r=e.orderTypes)||void 0===r?void 0:r.HIGHER_LOWER)||{}},TOUCH_NO_TOUCH:{...exports.DEFAULT_BINARY_SETTINGS.orderTypes.TOUCH_NO_TOUCH,...(null===(n=e.orderTypes)||void 0===n?void 0:n.TOUCH_NO_TOUCH)||{}},CALL_PUT:{...exports.DEFAULT_BINARY_SETTINGS.orderTypes.CALL_PUT,...(null===(i=e.orderTypes)||void 0===i?void 0:i.CALL_PUT)||{}},TURBO:{...exports.DEFAULT_BINARY_SETTINGS.orderTypes.TURBO,...(null===(d=e.orderTypes)||void 0===d?void 0:d.TURBO)||{}}},durations:e.durations||exports.DEFAULT_BINARY_SETTINGS.durations,riskManagement:{...exports.DEFAULT_BINARY_SETTINGS.riskManagement,...e.riskManagement||{}},_lastModified:(new Date).toISOString()}}Object.defineProperty(exports,"__esModule",{value:!0});exports.BINARY_PRESETS=exports.AGGRESSIVE_PRESET=exports.CONSERVATIVE_PRESET=exports.DEFAULT_BINARY_SETTINGS=void 0;exports.validateBinarySettings=validateBinarySettings;exports.generateWarnings=generateWarnings;exports.findBarrierLevel=findBarrierLevel;exports.findStrikeLevel=findStrikeLevel;exports.calculateBarrierPrice=calculateBarrierPrice;exports.calculateStrikePrice=calculateStrikePrice;exports.getProfitForLevel=getProfitForLevel;exports.isOrderTypeEnabled=isOrderTypeEnabled;exports.getEnabledBarrierLevels=getEnabledBarrierLevels;exports.getEnabledStrikeLevels=getEnabledStrikeLevels;exports.getEnabledDurations=getEnabledDurations;exports.isDurationEnabledForType=isDurationEnabledForType;exports.mergeWithDefaults=mergeWithDefaults;const DEFAULT_HIGHER_LOWER_BARRIERS=[{id:"hl_close",label:"Close (0.1%)",distancePercent:.1,profitPercent:68,enabled:!0},{id:"hl_near",label:"Near (0.2%)",distancePercent:.2,profitPercent:54,enabled:!0},{id:"hl_medium",label:"Medium (0.3%)",distancePercent:.3,profitPercent:45,enabled:!0},{id:"hl_far",label:"Far (0.5%)",distancePercent:.5,profitPercent:35,enabled:!1}],DEFAULT_TOUCH_BARRIERS=[{id:"tn_close",label:"Close (0.1%)",distancePercent:.1,profitPercent:95,enabled:!0},{id:"tn_near",label:"Near (0.2%)",distancePercent:.2,profitPercent:120,enabled:!0},{id:"tn_medium",label:"Medium (0.3%)",distancePercent:.3,profitPercent:150,enabled:!0}],DEFAULT_CALL_PUT_STRIKES=[{id:"cp_atm",label:"At The Money (0.1%)",distancePercent:.1,profitPercent:72,enabled:!0},{id:"cp_near",label:"Near (0.2%)",distancePercent:.2,profitPercent:62,enabled:!0},{id:"cp_otm",label:"Out of Money (0.5%)",distancePercent:.5,profitPercent:48,enabled:!0}],DEFAULT_TURBO_BARRIERS=[{id:"turbo_tight",label:"Tight (0.03%)",distancePercent:.03,profitPercent:75,enabled:!0},{id:"turbo_normal",label:"Normal (0.05%)",distancePercent:.05,profitPercent:65,enabled:!0},{id:"turbo_wide",label:"Wide (0.1%)",distancePercent:.1,profitPercent:52,enabled:!0}],DEFAULT_DURATIONS=[{id:"d_1m",minutes:1,enabled:!0,orderTypeOverrides:{RISE_FALL:{enabled:!0,profitAdjustment:5},HIGHER_LOWER:{enabled:!0,profitAdjustment:3},TOUCH_NO_TOUCH:{enabled:!0,profitAdjustment:5},CALL_PUT:{enabled:!0,profitAdjustment:3},TURBO:{enabled:!0,profitAdjustment:0}}},{id:"d_2m",minutes:2,enabled:!0,orderTypeOverrides:{RISE_FALL:{enabled:!0,profitAdjustment:3},HIGHER_LOWER:{enabled:!0,profitAdjustment:2},TOUCH_NO_TOUCH:{enabled:!0,profitAdjustment:3},CALL_PUT:{enabled:!0,profitAdjustment:2},TURBO:{enabled:!0,profitAdjustment:-2}}},{id:"d_3m",minutes:3,enabled:!0,orderTypeOverrides:{RISE_FALL:{enabled:!0,profitAdjustment:0},HIGHER_LOWER:{enabled:!0,profitAdjustment:0},TOUCH_NO_TOUCH:{enabled:!0,profitAdjustment:0},CALL_PUT:{enabled:!0,profitAdjustment:0},TURBO:{enabled:!0,profitAdjustment:-5}}},{id:"d_5m",minutes:5,enabled:!0,orderTypeOverrides:{RISE_FALL:{enabled:!0,profitAdjustment:0},HIGHER_LOWER:{enabled:!0,profitAdjustment:-2},TOUCH_NO_TOUCH:{enabled:!0,profitAdjustment:0},CALL_PUT:{enabled:!0,profitAdjustment:-2},TURBO:{enabled:!0,profitAdjustment:-8}}},{id:"d_10m",minutes:10,enabled:!0,orderTypeOverrides:{RISE_FALL:{enabled:!0,profitAdjustment:-3},HIGHER_LOWER:{enabled:!0,profitAdjustment:-5},TOUCH_NO_TOUCH:{enabled:!0,profitAdjustment:-3},CALL_PUT:{enabled:!0,profitAdjustment:-5},TURBO:{enabled:!1,profitAdjustment:0}}},{id:"d_15m",minutes:15,enabled:!0,orderTypeOverrides:{RISE_FALL:{enabled:!0,profitAdjustment:-5},HIGHER_LOWER:{enabled:!0,profitAdjustment:-7},TOUCH_NO_TOUCH:{enabled:!0,profitAdjustment:-5},CALL_PUT:{enabled:!0,profitAdjustment:-7},TURBO:{enabled:!1,profitAdjustment:0}}},{id:"d_30m",minutes:30,enabled:!0,orderTypeOverrides:{RISE_FALL:{enabled:!0,profitAdjustment:-8},HIGHER_LOWER:{enabled:!0,profitAdjustment:-10},TOUCH_NO_TOUCH:{enabled:!0,profitAdjustment:-8},CALL_PUT:{enabled:!0,profitAdjustment:-10},TURBO:{enabled:!1,profitAdjustment:0}}},{id:"d_1h",minutes:60,enabled:!0,orderTypeOverrides:{RISE_FALL:{enabled:!0,profitAdjustment:-12},HIGHER_LOWER:{enabled:!0,profitAdjustment:-15},TOUCH_NO_TOUCH:{enabled:!0,profitAdjustment:-12},CALL_PUT:{enabled:!0,profitAdjustment:-15},TURBO:{enabled:!1,profitAdjustment:0}}}],DEFAULT_CANCELLATION_SETTINGS={enabled:!0,rules:{RISE_FALL:{enabled:!0,minTimeBeforeExpirySeconds:30,penaltyPercentage:10,penaltyByTimeRemaining:{above60Seconds:5,above30Seconds:10,below30Seconds:20}},HIGHER_LOWER:{enabled:!0,minTimeBeforeExpirySeconds:30,penaltyPercentage:15,penaltyByTimeRemaining:{above60Seconds:10,above30Seconds:15,below30Seconds:25}},TOUCH_NO_TOUCH:{enabled:!1,minTimeBeforeExpirySeconds:60,penaltyPercentage:20},CALL_PUT:{enabled:!0,minTimeBeforeExpirySeconds:60,penaltyPercentage:15,penaltyByTimeRemaining:{above60Seconds:10,above30Seconds:15,below30Seconds:25}},TURBO:{enabled:!1,minTimeBeforeExpirySeconds:0,penaltyPercentage:0}}};exports.DEFAULT_BINARY_SETTINGS={global:{enabled:!0,practiceEnabled:!0,maxConcurrentOrders:10,maxDailyOrders:100,cooldownSeconds:3,orderExpirationBuffer:30,cancelExpirationBuffer:60},display:{chartType:"CHART_ENGINE"},cancellation:DEFAULT_CANCELLATION_SETTINGS,orderTypes:{RISE_FALL:{enabled:!0,profitPercentage:72,tradingModes:{demo:!0,live:!0}},HIGHER_LOWER:{enabled:!1,profitPercentage:68,barrierLevels:DEFAULT_HIGHER_LOWER_BARRIERS,tradingModes:{demo:!0,live:!0}},TOUCH_NO_TOUCH:{enabled:!1,profitPercentage:95,barrierLevels:DEFAULT_TOUCH_BARRIERS,touchProfitMultiplier:1.2,noTouchProfitMultiplier:.7,tradingModes:{demo:!0,live:!0}},CALL_PUT:{enabled:!1,profitPercentage:72,strikeLevels:DEFAULT_CALL_PUT_STRIKES,tradingModes:{demo:!0,live:!0}},TURBO:{enabled:!1,profitPercentage:65,barrierLevels:DEFAULT_TURBO_BARRIERS,payoutPerPointRange:{min:.1,max:10},maxDuration:5,allowTicksBased:!0,tradingModes:{demo:!0,live:!0}}},durations:DEFAULT_DURATIONS,riskManagement:{dailyLossLimit:0,winRateAlert:65},_preset:"balanced",_lastModified:(new Date).toISOString()};exports.CONSERVATIVE_PRESET={global:{enabled:!0,practiceEnabled:!0,maxConcurrentOrders:5,maxDailyOrders:50,cooldownSeconds:5,orderExpirationBuffer:45,cancelExpirationBuffer:90},display:{chartType:"CHART_ENGINE"},cancellation:{enabled:!0,rules:{RISE_FALL:{enabled:!0,minTimeBeforeExpirySeconds:45,penaltyPercentage:15},HIGHER_LOWER:{enabled:!0,minTimeBeforeExpirySeconds:45,penaltyPercentage:20},TOUCH_NO_TOUCH:{enabled:!1,minTimeBeforeExpirySeconds:90,penaltyPercentage:25},CALL_PUT:{enabled:!0,minTimeBeforeExpirySeconds:90,penaltyPercentage:20},TURBO:{enabled:!1,minTimeBeforeExpirySeconds:0,penaltyPercentage:0}}},orderTypes:{RISE_FALL:{enabled:!0,profitPercentage:65,tradingModes:{demo:!0,live:!0}},HIGHER_LOWER:{enabled:!1,profitPercentage:60,tradingModes:{demo:!0,live:!0},barrierLevels:[{id:"hl_close",label:"Close (0.1%)",distancePercent:.1,profitPercent:62,enabled:!0},{id:"hl_near",label:"Near (0.2%)",distancePercent:.2,profitPercent:48,enabled:!0}]},TOUCH_NO_TOUCH:{enabled:!1,profitPercentage:85,touchProfitMultiplier:1.3,noTouchProfitMultiplier:.65,tradingModes:{demo:!0,live:!0},barrierLevels:[{id:"tn_close",label:"Close (0.1%)",distancePercent:.1,profitPercent:80,enabled:!0},{id:"tn_near",label:"Near (0.2%)",distancePercent:.2,profitPercent:100,enabled:!0}]},CALL_PUT:{enabled:!1,profitPercentage:62,tradingModes:{demo:!0,live:!0},strikeLevels:[{id:"cp_atm",label:"At The Money (0.1%)",distancePercent:.1,profitPercent:62,enabled:!0},{id:"cp_near",label:"Near (0.2%)",distancePercent:.2,profitPercent:52,enabled:!0}]},TURBO:{enabled:!1,profitPercentage:58,tradingModes:{demo:!0,live:!0},barrierLevels:[{id:"turbo_tight",label:"Tight (0.03%)",distancePercent:.03,profitPercent:65,enabled:!0},{id:"turbo_normal",label:"Normal (0.05%)",distancePercent:.05,profitPercent:55,enabled:!0}],payoutPerPointRange:{min:.1,max:5},maxDuration:3,allowTicksBased:!1}},durations:[{id:"d_1m",minutes:1,enabled:!0,orderTypeOverrides:{RISE_FALL:{enabled:!0,profitAdjustment:3},HIGHER_LOWER:{enabled:!0,profitAdjustment:2},TOUCH_NO_TOUCH:{enabled:!0,profitAdjustment:3},CALL_PUT:{enabled:!0,profitAdjustment:2},TURBO:{enabled:!0,profitAdjustment:0}}},{id:"d_3m",minutes:3,enabled:!0,orderTypeOverrides:{RISE_FALL:{enabled:!0,profitAdjustment:0},HIGHER_LOWER:{enabled:!0,profitAdjustment:0},TOUCH_NO_TOUCH:{enabled:!0,profitAdjustment:0},CALL_PUT:{enabled:!0,profitAdjustment:0},TURBO:{enabled:!0,profitAdjustment:-3}}},{id:"d_5m",minutes:5,enabled:!0,orderTypeOverrides:{RISE_FALL:{enabled:!0,profitAdjustment:-3},HIGHER_LOWER:{enabled:!0,profitAdjustment:-4},TOUCH_NO_TOUCH:{enabled:!0,profitAdjustment:-3},CALL_PUT:{enabled:!0,profitAdjustment:-4},TURBO:{enabled:!1,profitAdjustment:0}}},{id:"d_15m",minutes:15,enabled:!0,orderTypeOverrides:{RISE_FALL:{enabled:!0,profitAdjustment:-8},HIGHER_LOWER:{enabled:!0,profitAdjustment:-10},TOUCH_NO_TOUCH:{enabled:!0,profitAdjustment:-8},CALL_PUT:{enabled:!0,profitAdjustment:-10},TURBO:{enabled:!1,profitAdjustment:0}}}],riskManagement:{dailyLossLimit:1e3,winRateAlert:60},_preset:"conservative",_lastModified:(new Date).toISOString()};exports.AGGRESSIVE_PRESET={global:{enabled:!0,practiceEnabled:!0,maxConcurrentOrders:20,maxDailyOrders:200,cooldownSeconds:0,orderExpirationBuffer:15,cancelExpirationBuffer:30},display:{chartType:"CHART_ENGINE"},cancellation:{enabled:!0,rules:{RISE_FALL:{enabled:!0,minTimeBeforeExpirySeconds:15,penaltyPercentage:5,penaltyByTimeRemaining:{above60Seconds:2,above30Seconds:5,below30Seconds:10}},HIGHER_LOWER:{enabled:!0,minTimeBeforeExpirySeconds:15,penaltyPercentage:8,penaltyByTimeRemaining:{above60Seconds:3,above30Seconds:8,below30Seconds:15}},TOUCH_NO_TOUCH:{enabled:!0,minTimeBeforeExpirySeconds:30,penaltyPercentage:10},CALL_PUT:{enabled:!0,minTimeBeforeExpirySeconds:30,penaltyPercentage:8,penaltyByTimeRemaining:{above60Seconds:3,above30Seconds:8,below30Seconds:15}},TURBO:{enabled:!0,minTimeBeforeExpirySeconds:10,penaltyPercentage:25}}},orderTypes:{RISE_FALL:{enabled:!0,profitPercentage:82,tradingModes:{demo:!0,live:!0}},HIGHER_LOWER:{enabled:!0,profitPercentage:78,tradingModes:{demo:!0,live:!0},barrierLevels:[{id:"hl_close",label:"Close (0.1%)",distancePercent:.1,profitPercent:78,enabled:!0},{id:"hl_near",label:"Near (0.2%)",distancePercent:.2,profitPercent:65,enabled:!0},{id:"hl_medium",label:"Medium (0.3%)",distancePercent:.3,profitPercent:55,enabled:!0},{id:"hl_far",label:"Far (0.5%)",distancePercent:.5,profitPercent:42,enabled:!0}]},TOUCH_NO_TOUCH:{enabled:!1,profitPercentage:110,tradingModes:{demo:!0,live:!0},barrierLevels:[{id:"tn_close",label:"Close (0.1%)",distancePercent:.1,profitPercent:110,enabled:!0},{id:"tn_near",label:"Near (0.2%)",distancePercent:.2,profitPercent:140,enabled:!0},{id:"tn_medium",label:"Medium (0.3%)",distancePercent:.3,profitPercent:180,enabled:!0},{id:"tn_far",label:"Far (0.5%)",distancePercent:.5,profitPercent:230,enabled:!0}],touchProfitMultiplier:1.15,noTouchProfitMultiplier:.75},CALL_PUT:{enabled:!1,profitPercentage:80,tradingModes:{demo:!0,live:!0},strikeLevels:[{id:"cp_atm",label:"At The Money (0.1%)",distancePercent:.1,profitPercent:80,enabled:!0},{id:"cp_near",label:"Near (0.2%)",distancePercent:.2,profitPercent:70,enabled:!0},{id:"cp_otm",label:"Out of Money (0.5%)",distancePercent:.5,profitPercent:55,enabled:!0}]},TURBO:{enabled:!1,profitPercentage:75,tradingModes:{demo:!0,live:!0},barrierLevels:[{id:"turbo_tight",label:"Tight (0.03%)",distancePercent:.03,profitPercent:85,enabled:!0},{id:"turbo_normal",label:"Normal (0.05%)",distancePercent:.05,profitPercent:75,enabled:!0},{id:"turbo_wide",label:"Wide (0.1%)",distancePercent:.1,profitPercent:60,enabled:!0}],payoutPerPointRange:{min:.1,max:20},maxDuration:5,allowTicksBased:!0}},durations:[{id:"d_1m",minutes:1,enabled:!0,orderTypeOverrides:{RISE_FALL:{enabled:!0,profitAdjustment:5},HIGHER_LOWER:{enabled:!0,profitAdjustment:4},TOUCH_NO_TOUCH:{enabled:!0,profitAdjustment:5},CALL_PUT:{enabled:!0,profitAdjustment:4},TURBO:{enabled:!0,profitAdjustment:2}}},{id:"d_2m",minutes:2,enabled:!0,orderTypeOverrides:{RISE_FALL:{enabled:!0,profitAdjustment:3},HIGHER_LOWER:{enabled:!0,profitAdjustment:2},TOUCH_NO_TOUCH:{enabled:!0,profitAdjustment:3},CALL_PUT:{enabled:!0,profitAdjustment:2},TURBO:{enabled:!0,profitAdjustment:0}}},{id:"d_3m",minutes:3,enabled:!0,orderTypeOverrides:{RISE_FALL:{enabled:!0,profitAdjustment:0},HIGHER_LOWER:{enabled:!0,profitAdjustment:0},TOUCH_NO_TOUCH:{enabled:!0,profitAdjustment:0},CALL_PUT:{enabled:!0,profitAdjustment:0},TURBO:{enabled:!0,profitAdjustment:-3}}},{id:"d_5m",minutes:5,enabled:!0,orderTypeOverrides:{RISE_FALL:{enabled:!0,profitAdjustment:0},HIGHER_LOWER:{enabled:!0,profitAdjustment:-2},TOUCH_NO_TOUCH:{enabled:!0,profitAdjustment:0},CALL_PUT:{enabled:!0,profitAdjustment:-2},TURBO:{enabled:!0,profitAdjustment:-5}}},{id:"d_10m",minutes:10,enabled:!0,orderTypeOverrides:{RISE_FALL:{enabled:!0,profitAdjustment:-2},HIGHER_LOWER:{enabled:!0,profitAdjustment:-4},TOUCH_NO_TOUCH:{enabled:!0,profitAdjustment:-2},CALL_PUT:{enabled:!0,profitAdjustment:-4},TURBO:{enabled:!1,profitAdjustment:0}}},{id:"d_15m",minutes:15,enabled:!0,orderTypeOverrides:{RISE_FALL:{enabled:!0,profitAdjustment:-4},HIGHER_LOWER:{enabled:!0,profitAdjustment:-6},TOUCH_NO_TOUCH:{enabled:!0,profitAdjustment:-4},CALL_PUT:{enabled:!0,profitAdjustment:-6},TURBO:{enabled:!1,profitAdjustment:0}}},{id:"d_30m",minutes:30,enabled:!0,orderTypeOverrides:{RISE_FALL:{enabled:!0,profitAdjustment:-6},HIGHER_LOWER:{enabled:!0,profitAdjustment:-8},TOUCH_NO_TOUCH:{enabled:!0,profitAdjustment:-6},CALL_PUT:{enabled:!0,profitAdjustment:-8},TURBO:{enabled:!1,profitAdjustment:0}}},{id:"d_1h",minutes:60,enabled:!0,orderTypeOverrides:{RISE_FALL:{enabled:!0,profitAdjustment:-10},HIGHER_LOWER:{enabled:!0,profitAdjustment:-12},TOUCH_NO_TOUCH:{enabled:!0,profitAdjustment:-10},CALL_PUT:{enabled:!0,profitAdjustment:-12},TURBO:{enabled:!1,profitAdjustment:0}}},{id:"d_4h",minutes:240,enabled:!0,orderTypeOverrides:{RISE_FALL:{enabled:!0,profitAdjustment:-15},HIGHER_LOWER:{enabled:!0,profitAdjustment:-18},TOUCH_NO_TOUCH:{enabled:!0,profitAdjustment:-15},CALL_PUT:{enabled:!0,profitAdjustment:-18},TURBO:{enabled:!1,profitAdjustment:0}}}],riskManagement:{dailyLossLimit:0,winRateAlert:75},_preset:"aggressive",_lastModified:(new Date).toISOString()};exports.BINARY_PRESETS={conservative:exports.CONSERVATIVE_PRESET,balanced:exports.DEFAULT_BINARY_SETTINGS,aggressive:exports.AGGRESSIVE_PRESET};