"use strict";async function convertToUSD(e,t,s){try{if("USD"===t||"USDT"===t)return e;let a=1;switch(s){case"FIAT":a=await(0,utils_1.getFiatPriceInUSD)(t);break;case"SPOT":a=await(0,utils_1.getSpotPriceInUSD)(t);break;case"ECO":a=await(0,utils_1.getEcoPriceInUSD)(t)}return e*a}catch(s){console_1.logger.debug("DASHBOARD",`Failed to convert ${t} to USD: ${s.message}`);return e}}function generateDateRange(e="monthly"){const t=[],s=new Date;if("yearly"===e){const e=s.getFullYear();for(let s=0;s<12;s++){const a=new Date(e,s,1);t.push(a.toISOString().split("T")[0])}}else if("weekly"===e){const e=new Date(s);e.setDate(s.getDate()-s.getDay());for(let s=0;s<7;s++){const a=new Date(e);a.setDate(e.getDate()+s);t.push(a.toISOString().split("T")[0])}}else for(let e=3;e>=0;e--){const a=new Date(s);a.setDate(s.getDate()-7*e);const r=a.getDay(),o=0===r?-6:1-r;a.setDate(a.getDate()+o);t.push(a.toISOString().split("T")[0])}return t}function fillMissingDates(e,t="monthly",s){const a=generateDateRange(t),r=new Map(e.map(e=>[e.date,e]));return a.map(e=>{const t=r.get(e);return t||{date:e,...s}})}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize"),utils_1=require("@b/api/finance/currency/utils"),console_1=require("@b/utils/console");exports.metadata={summary:"Get Admin Dashboard Analytics",description:"Comprehensive admin dashboard analytics including user stats, financial metrics, trading activity, and system overview",operationId:"getAdminDashboard",tags:["Admin","Dashboard","Analytics"],requiresAuth:!0,permission:"access.admin",responses:{200:{description:"Dashboard analytics retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{overview:{type:"object",properties:{totalUsers:{type:"number"},activeUsers:{type:"number"},newUsersToday:{type:"number"},totalRevenue:{type:"number"},totalTransactions:{type:"number"},pendingKYC:{type:"number"},systemHealth:{type:"string"}}},userMetrics:{type:"object",properties:{registrations:{type:"array",items:{type:"object",properties:{date:{type:"string"},total:{type:"number"},new:{type:"number"}}}},usersByLevel:{type:"array",items:{type:"object",properties:{level:{type:"string"},count:{type:"number"},color:{type:"string"}}}}}},financialMetrics:{type:"object",properties:{dailyRevenue:{type:"array",items:{type:"object",properties:{date:{type:"string"},revenue:{type:"number"},profit:{type:"number"}}}},transactionVolume:{type:"array",items:{type:"object",properties:{type:{type:"string"},value:{type:"number"},color:{type:"string"}}}}}},tradingActivity:{type:"object",properties:{dailyTrades:{type:"array",items:{type:"object",properties:{date:{type:"string"},count:{type:"number"},volume:{type:"number"}}}},topAssets:{type:"array",items:{type:"object",properties:{asset:{type:"string"},volume:{type:"number"},trades:{type:"number"}}}}}},systemStatus:{type:"object",properties:{services:{type:"array",items:{type:"object",properties:{name:{type:"string"},status:{type:"string"},uptime:{type:"number"}}}},performance:{type:"object",properties:{cpu:{type:"number"},memory:{type:"number"},disk:{type:"number"}}}}}}}}}}}};exports.default=async e=>{var t,s;const{query:a,ctx:r}=e;try{null==r||r.step("Fetching dashboard analytics");const e=(null==a?void 0:a.timeframe)||"monthly";let o;const l=new Date;switch(e){case"yearly":o=new Date(l.getFullYear(),0,1);break;case"weekly":o=new Date(l);o.setDate(l.getDate()-l.getDay());break;default:o=new Date(l.getTime()-24192e5)}const n=[db_1.models.user?db_1.models.user.count().catch(()=>0):Promise.resolve(0),db_1.models.user?db_1.models.user.count({where:{lastLogin:{[sequelize_1.Op.gte]:new Date(Date.now()-2592e6)}}}).catch(()=>0):Promise.resolve(0),db_1.models.user?db_1.models.user.count({where:{createdAt:{[sequelize_1.Op.gte]:new Date((new Date).setHours(0,0,0,0))}}}).catch(()=>0):Promise.resolve(0),db_1.models.transaction?db_1.models.transaction.count().catch(()=>0):Promise.resolve(0),db_1.models.kyc?db_1.models.kyc.count({where:{status:"PENDING"}}).catch(()=>0):Promise.resolve(0)],[i,u,c,d,p]=await Promise.all(n);let m=0;try{if(db_1.models.transaction){const e=await db_1.models.transaction.findAll({where:{status:"COMPLETED",type:{[sequelize_1.Op.in]:["DEPOSIT","WITHDRAWAL","TRANSFER","TRADE"]}},attributes:["amount","fee"],include:[{model:db_1.models.wallet,as:"wallet",attributes:["type","currency"],required:!0}]});for(const a of e){const e=(null===(t=a.wallet)||void 0===t?void 0:t.type)||"SPOT",r=(null===(s=a.wallet)||void 0===s?void 0:s.currency)||"USD",o=parseFloat(a.fee)||0;if(o>0){m+=await convertToUSD(o,r,e)}}}}catch(e){console_1.logger.debug("DASHBOARD",`Failed to calculate total revenue: ${e.message}`)}let y=[];try{if(db_1.models.user){const t="yearly"===e?[(0,sequelize_1.fn)("YEAR",(0,sequelize_1.col)("createdAt")),(0,sequelize_1.fn)("MONTH",(0,sequelize_1.col)("createdAt"))]:"monthly"===e?[(0,sequelize_1.fn)("YEARWEEK",(0,sequelize_1.col)("createdAt"),1)]:[(0,sequelize_1.fn)("DATE",(0,sequelize_1.col)("createdAt"))],s="yearly"===e?(0,sequelize_1.fn)("CONCAT",(0,sequelize_1.fn)("YEAR",(0,sequelize_1.col)("createdAt")),"-",(0,sequelize_1.fn)("LPAD",(0,sequelize_1.fn)("MONTH",(0,sequelize_1.col)("createdAt")),2,"0"),"-01"):"monthly"===e?(0,sequelize_1.fn)("DATE",(0,sequelize_1.fn)("DATE_SUB",(0,sequelize_1.col)("createdAt"),(0,sequelize_1.literal)("INTERVAL WEEKDAY(createdAt) DAY"))):(0,sequelize_1.fn)("DATE",(0,sequelize_1.col)("createdAt")),a=await db_1.models.user.findAll({attributes:[[s,"date"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"count"]],where:{createdAt:{[sequelize_1.Op.gte]:o}},group:t,order:[[s,"ASC"]]}),r=new Map;a.forEach(e=>{const t=e.getDataValue("date"),s=parseInt(e.getDataValue("count"))||0;r.set(t,s)});const l=generateDateRange(e);let n=Math.max(0,i-c);y=l.map(e=>{const t=r.get(e)||0;n+=t;return{date:e,total:n,new:t}})}}catch(t){console_1.logger.debug("DASHBOARD",`Failed to fetch user registration data: ${t.message}`);y=fillMissingDates([],e,{total:i,new:0})}const _=[];try{if(db_1.models.kyc){const e=await db_1.models.kyc.findAll({attributes:["level",[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("userId")),"count"]],group:["level"]}),t=["#0088FE","#00C49F","#FFBB28","#FF8042","#8884D8"];e.forEach((e,s)=>{_.push({level:e.level||"Unverified",count:parseInt(e.getDataValue("count"))||0,color:t[s%t.length]})})}}catch(e){console_1.logger.debug("DASHBOARD",`Failed to fetch KYC level data: ${e.message}`);_.push({level:"No KYC Data",count:i,color:"#8884D8"})}let g=[];try{if(db_1.models.transaction){const t="yearly"===e?[(0,sequelize_1.fn)("YEAR",(0,sequelize_1.col)("createdAt")),(0,sequelize_1.fn)("MONTH",(0,sequelize_1.col)("createdAt"))]:"monthly"===e?[(0,sequelize_1.fn)("YEARWEEK",(0,sequelize_1.col)("createdAt"),1)]:[(0,sequelize_1.fn)("DATE",(0,sequelize_1.col)("createdAt"))],s="yearly"===e?(0,sequelize_1.fn)("CONCAT",(0,sequelize_1.fn)("YEAR",(0,sequelize_1.col)("createdAt")),"-",(0,sequelize_1.fn)("LPAD",(0,sequelize_1.fn)("MONTH",(0,sequelize_1.col)("createdAt")),2,"0"),"-01"):"monthly"===e?(0,sequelize_1.fn)("DATE",(0,sequelize_1.fn)("DATE_SUB",(0,sequelize_1.col)("createdAt"),(0,sequelize_1.literal)("INTERVAL WEEKDAY(createdAt) DAY"))):(0,sequelize_1.fn)("DATE",(0,sequelize_1.col)("createdAt")),a=await db_1.models.transaction.findAll({attributes:[[s,"date"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("fee")),"totalFee"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"transactionCount"]],where:{createdAt:{[sequelize_1.Op.gte]:o},status:"COMPLETED",fee:{[sequelize_1.Op.gt]:0}},group:t,order:[[s,"ASC"]]}),r=new Map;for(const e of a){const t=e.getDataValue("date"),s=parseFloat(e.getDataValue("totalFee"))||0,a=.7*s;r.set(t,{revenue:s,profit:a})}g=generateDateRange(e).map(e=>{const t=r.get(e)||{revenue:0,profit:0};return{date:e,revenue:t.revenue,profit:t.profit}})}}catch(t){console_1.logger.debug("DASHBOARD",`Failed to fetch daily revenue data: ${t.message}`);g=fillMissingDates([],e,{revenue:0,profit:0})}const D=[];try{if(db_1.models.transaction){const e=await db_1.models.transaction.findAll({attributes:["type",[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"totalAmount"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"count"]],where:{status:"COMPLETED"},group:["type"]}),t={DEPOSIT:"Deposit",WITHDRAW:"Withdrawal",TRANSFER:"Transfer",INCOMING_TRANSFER:"Incoming Transfer",OUTGOING_TRANSFER:"Outgoing Transfer",BINARY_ORDER:"Binary Order",FOREX_DEPOSIT:"Forex Deposit",FOREX_WITHDRAW:"Forex Withdrawal",REFERRAL_REWARD:"Referral Reward",STAKING_REWARD:"Staking Reward",AI_INVESTMENT:"AI Investment",ICO_CONTRIBUTION:"ICO Contribution",P2P_TRADE:"P2P Trade",COMMISSION:"Commission",BONUS:"Bonus"},s=["#0088FE","#00C49F","#FFBB28","#FF8042","#8884D8","#82CA9D"];e.forEach((e,a)=>{const r=e.type||"Unknown";D.push({type:t[r]||r,value:Math.round(parseFloat(e.getDataValue("totalAmount"))||0),color:s[a%s.length]})})}}catch(e){console_1.logger.debug("DASHBOARD",`Failed to fetch transaction volume data: ${e.message}`)}let f=[];try{if(db_1.models.exchangeOrder){const t="yearly"===e?[(0,sequelize_1.fn)("YEAR",(0,sequelize_1.col)("createdAt")),(0,sequelize_1.fn)("MONTH",(0,sequelize_1.col)("createdAt"))]:"monthly"===e?[(0,sequelize_1.fn)("YEARWEEK",(0,sequelize_1.col)("createdAt"),1)]:[(0,sequelize_1.fn)("DATE",(0,sequelize_1.col)("createdAt"))],s="yearly"===e?(0,sequelize_1.fn)("CONCAT",(0,sequelize_1.fn)("YEAR",(0,sequelize_1.col)("createdAt")),"-",(0,sequelize_1.fn)("LPAD",(0,sequelize_1.fn)("MONTH",(0,sequelize_1.col)("createdAt")),2,"0"),"-01"):"monthly"===e?(0,sequelize_1.fn)("DATE",(0,sequelize_1.fn)("DATE_SUB",(0,sequelize_1.col)("createdAt"),(0,sequelize_1.literal)("INTERVAL WEEKDAY(createdAt) DAY"))):(0,sequelize_1.fn)("DATE",(0,sequelize_1.col)("createdAt")),a=await db_1.models.exchangeOrder.findAll({attributes:[[s,"date"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"count"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"volume"]],where:{createdAt:{[sequelize_1.Op.gte]:o},status:"FILLED"},group:t,order:[[s,"ASC"]]}),r=new Map;a.forEach(e=>{const t=e.getDataValue("date"),s=parseInt(e.getDataValue("count"))||0,a=parseFloat(e.getDataValue("volume"))||0;r.set(t,{count:s,volume:a})});f=generateDateRange(e).map(e=>{const t=r.get(e)||{count:0,volume:0};return{date:e,count:t.count,volume:t.volume}})}}catch(t){console_1.logger.debug("DASHBOARD",`Failed to fetch daily trades data: ${t.message}`);f=fillMissingDates([],e,{count:0,volume:0})}const A=[];try{if(db_1.models.exchangeOrder){const e=await db_1.models.exchangeOrder.findAll({attributes:["symbol",[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"volume"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"trades"]],where:{status:"FILLED"},group:["symbol"],order:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"DESC"]],limit:5});for(const t of e)A.push({asset:t.symbol||"Unknown",volume:parseFloat(t.getDataValue("volume"))||0,trades:parseInt(t.getDataValue("trades"))||0})}}catch(e){console_1.logger.debug("DASHBOARD",`Failed to fetch top assets data: ${e.message}`)}const b={services:[{name:"Database",status:"online",uptime:99.9},{name:"API Server",status:"online",uptime:99.8},{name:"WebSocket",status:"online",uptime:99.7},{name:"Cache Server",status:"online",uptime:99.9},{name:"Background Jobs",status:"warning",uptime:95.2}],performance:{cpu:Math.floor(30*Math.random())+20,memory:Math.floor(40*Math.random())+30,disk:Math.floor(20*Math.random())+15}};null==r||r.success("Dashboard analytics retrieved successfully");return{overview:{totalUsers:i,activeUsers:u,newUsersToday:c,totalRevenue:m,totalTransactions:d,pendingKYC:p,systemHealth:m>1e3?"healthy":"warning"},userMetrics:{registrations:y.length>0?y:fillMissingDates([],e,{total:i||0,new:0}),usersByLevel:_.length>0?_:[{level:"Unverified",count:i,color:"#8884D8"}]},financialMetrics:{dailyRevenue:g.length>0?g:fillMissingDates([],e,{revenue:0,profit:0}),transactionVolume:D.length>0?D:[{type:"No Data",value:0,color:"#8884D8"}]},tradingActivity:{dailyTrades:f.length>0?f:fillMissingDates([],e,{count:0,volume:0}),topAssets:A.length>0?A:[{asset:"No Data",volume:0,trades:0}]},systemStatus:b}}catch(e){console_1.logger.error("DASHBOARD","Admin dashboard error",e);const t="monthly";return{overview:{totalUsers:0,activeUsers:0,newUsersToday:0,totalRevenue:0,totalTransactions:0,pendingKYC:0,systemHealth:"error"},userMetrics:{registrations:fillMissingDates([],t,{total:0,new:0}),usersByLevel:[{level:"Error",count:0,color:"#FF0000"}]},financialMetrics:{dailyRevenue:fillMissingDates([],t,{revenue:0,profit:0}),transactionVolume:[{type:"Error",value:0,color:"#FF0000"}]},tradingActivity:{dailyTrades:fillMissingDates([],t,{count:0,volume:0}),topAssets:[{asset:"Error",volume:0,trades:0}]},systemStatus:{services:[{name:"System",status:"offline",uptime:0}],performance:{cpu:0,memory:0,disk:0}}}}};