"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),db_1=require("@b/db");exports.metadata={summary:"Bulk deletes users by UUIDs",operationId:"bulkDeleteUsers",tags:["Admin","CRM","User"],logModule:"ADMIN_CRM",logTitle:"Bulk delete users",parameters:(0,query_1.commonBulkDeleteParams)("Users"),requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",items:{type:"string"},description:"Array of user UUIDs to delete"}},required:["ids"]}}}},responses:(0,query_1.commonBulkDeleteResponses)("Users"),requiresAuth:!0,permission:"delete.user"};exports.default=async e=>{const{body:r,query:s,user:t,ctx:o}=e,{ids:l}=r;null==o||o.step("Validating user authorization");if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const u=await db_1.models.user.findByPk(t.id,{include:[{model:db_1.models.role,as:"role"}]});if(!u||!u.role||"Super Admin"!==u.role.name)throw(0,error_1.createError)({statusCode:403,message:"Forbidden - Only Super Admins can bulk delete users"});null==o||o.step("Validating target users");const d=await db_1.models.user.findAll({where:{id:l},include:[{model:db_1.models.role,as:"role"}]});for(const e of d)if(e.role&&"Super Admin"===e.role.name)throw(0,error_1.createError)({statusCode:403,message:"Forbidden - You cannot delete Super Admin accounts"});null==o||o.step(`Deleting ${l.length} users`);const i=await(0,query_1.handleBulkDelete)({model:"user",ids:l,query:s});null==o||o.success();return i};