"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),query_1=require("@b/utils/query"),constants_1=require("@b/utils/constants"),utils_1=require("./utils"),sequelize_1=require("sequelize"),console_1=require("@b/utils/console");exports.metadata={summary:"Lists support tickets with pagination and filtering",operationId:"listSupportTickets",tags:["Admin","CRM","Support Ticket"],parameters:constants_1.crudParameters,responses:{200:{description:"Support tickets retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{data:{type:"array",items:{type:"object",properties:utils_1.supportTicketSchema}},pagination:constants_1.paginationSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Support Tickets"),500:query_1.serverErrorResponse},requiresAuth:!0,permission:"access.support.ticket",demoMask:["items.user.email","items.agent.email"]};exports.default=async e=>{const{query:s,user:t}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});try{const e=await(0,query_1.getFiltered)({model:db_1.models.supportTicket,query:s,sortField:s.sortField||"createdAt",where:{userId:{[sequelize_1.Op.ne]:t.id}},includeModels:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","email","avatar"]},{model:db_1.models.user,as:"agent",attributes:["id","firstName","lastName","email","avatar"]}]});e.items&&Array.isArray(e.items)&&(e.items=e.items.map(e=>{if("string"==typeof e.messages)try{e.messages=JSON.parse(e.messages)}catch(s){console_1.logger.warn("SUPPORT","Failed to parse messages JSON");e.messages=[]}if("string"==typeof e.tags)try{e.tags=JSON.parse(e.tags)}catch(s){console_1.logger.warn("SUPPORT","Failed to parse tags JSON");e.tags=[]}e.messages=e.messages||[];e.tags=e.tags||[];return e}));return e}catch(e){console_1.logger.error("SUPPORT","Error fetching support tickets",e);if(e.statusCode)throw e;throw(0,error_1.createError)({statusCode:500,message:"Failed to fetch support tickets"})}};