"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),db_1=require("@b/db");exports.metadata={summary:"Retrieves a list of KYC levels",description:"This endpoint retrieves all available KYC levels.",operationId:"getKycLevels",tags:["KYC Level"],requiresAuth:!0,logModule:"ADMIN_CRM",logTitle:"Get KYC level options",responses:{200:{description:"KYC levels retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{id:{type:"string"},name:{type:"string"}}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("KYC Level"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{user:r,ctx:t}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)(401,"Unauthorized");try{null==t||t.step("Fetching KYC level options");const e=(await db_1.models.kycLevel.findAll()).map(e=>({id:e.id,name:e.name}));null==t||t.success("KYC level options retrieved successfully");return e}catch(e){throw(0,error_1.createError)(500,"An error occurred while fetching KYC levels")}};