"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),db_1=require("@b/db");exports.metadata={summary:"Retrieves a list of categories",description:"This endpoint retrieves all available categories for posts.",operationId:"getCategories",tags:["Category"],requiresAuth:!0,responses:{200:{description:"Categories retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{id:{type:"string"},name:{type:"string"}}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Category"),500:query_1.serverErrorResponse},logModule:"ADMIN_BLOG",logTitle:"Get category options"};exports.default=async e=>{const{user:r,ctx:t}=e;null==t||t.step("Validating user authorization");if(!(null==r?void 0:r.id))throw(0,error_1.createError)(401,"Unauthorized");try{null==t||t.step("Fetching all categories");const e=await db_1.models.category.findAll();null==t||t.step("Formatting category options");const r=e.map(e=>({id:e.id,name:e.name}));null==t||t.success(`${r.length} category options retrieved`);return r}catch(e){null==t||t.fail("Failed to fetch categories");throw(0,error_1.createError)(500,"An error occurred while fetching categories")}};