"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize");exports.metadata={summary:"Get User's Staking Summary",description:"Retrieves a summary of the user's staking activity across all positions.",operationId:"getUserStakingSummary",tags:["Staking","User","Summary"],requiresAuth:!0,parameters:[],responses:{200:{description:"Summary retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{summary:{type:"object",properties:{totalStaked:{type:"number"},totalEarnings:{type:"number"},unclaimedEarnings:{type:"number"},activePositions:{type:"number"},byToken:{type:"array",items:{type:"object"}}}}}}}}},401:{description:"Unauthorized"},500:{description:"Internal Server Error"}}};exports.default=async e=>{const{user:t,ctx:o}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==o||o.step("Fetching user staking summary");const i=await db_1.models.stakingPosition.findAll({where:{userId:t.id,status:{[sequelize_1.Op.in]:["ACTIVE","LOCKED"]}},include:[{model:db_1.models.stakingPool,as:"pool",attributes:["id","name","symbol","icon"]}]}),s=i.reduce((e,t)=>e+t.amount,0),a=(i.map(e=>e.id),(await db_1.models.stakingPosition.findAll({where:{userId:t.id},attributes:["id"]})).map(e=>e.id)),n=await db_1.models.stakingEarningRecord.findAll({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"total"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN isClaimed = false THEN amount ELSE 0 END")),"unclaimed"]],where:{positionId:{[sequelize_1.Op.in]:a}},raw:!0}),r=n[0].total||0,l=n[0].unclaimed||0,u={};i.forEach(e=>{const t=e.pool.symbol;u[t]||(u[t]={tokenSymbol:t,tokenIcon:e.pool.icon,totalStaked:0,positionCount:0});u[t].totalStaked+=e.amount;u[t].positionCount+=1});(await db_1.models.stakingEarningRecord.findAll({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"total"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN isClaimed = false THEN amount ELSE 0 END")),"unclaimed"]],include:[{model:db_1.models.stakingPosition,as:"position",attributes:["id","poolId"],include:[{model:db_1.models.stakingPool,as:"pool",attributes:["id","symbol"]}]}],where:{positionId:{[sequelize_1.Op.in]:a}},group:["position.pool.id","position.pool.symbol"],raw:!1})).forEach(e=>{const t=e.position.pool.symbol;u[t]||(u[t]={tokenSymbol:t,tokenIcon:null,totalStaked:0,positionCount:0});u[t].totalEarnings=Number.parseFloat(e.getDataValue("total"))||0;u[t].unclaimedEarnings=Number.parseFloat(e.getDataValue("unclaimed"))||0});null==o||o.success("User staking summary retrieved successfully");return{summary:{totalStaked:s,totalEarnings:r,unclaimedEarnings:l,activePositions:i.length,byToken:Object.values(u)}}};