"use strict";async function isOfferOwner(e,i,r){var l,t,o;try{null===(l=null==r?void 0:r.step)||void 0===l||l.call(r,`Checking if user ${e} owns offer ${i}`);const o=await db_1.models.p2pOffer.findByPk(i,{attributes:["userId"]}),n=(null==o?void 0:o.userId)===e;null===(t=null==r?void 0:r.success)||void 0===t||t.call(r,`Offer ownership check: ${n}`);return n}catch(e){null===(o=null==r?void 0:r.fail)||void 0===o||o.call(r,e.message||"Failed to check offer ownership");throw e}}async function isTradeParticipant(e,i,r){var l,t,o;try{null===(l=null==r?void 0:r.step)||void 0===l||l.call(r,`Checking if user ${e} is participant in trade ${i}`);const o=await db_1.models.p2pTrade.findByPk(i,{attributes:["buyerId","sellerId"]}),n=(null==o?void 0:o.buyerId)===e||(null==o?void 0:o.sellerId)===e;null===(t=null==r?void 0:r.success)||void 0===t||t.call(r,`Trade participation check: ${n}`);return n}catch(e){null===(o=null==r?void 0:r.fail)||void 0===o||o.call(r,e.message||"Failed to check trade participation");throw e}}async function isPaymentMethodOwner(e,i,r){var l,t,o;try{null===(l=null==r?void 0:r.step)||void 0===l||l.call(r,`Checking if user ${e} owns payment method ${i}`);const o=await db_1.models.p2pPaymentMethod.findByPk(i,{attributes:["userId"]}),n=(null==o?void 0:o.userId)===e;null===(t=null==r?void 0:r.success)||void 0===t||t.call(r,`Payment method ownership check: ${n}`);return n}catch(e){null===(o=null==r?void 0:r.fail)||void 0===o||o.call(r,e.message||"Failed to check payment method ownership");throw e}}async function requireOfferOwnership(e,i,r){var l,t,o,n;try{null===(l=null==r?void 0:r.step)||void 0===l||l.call(r,"Verifying offer ownership");if(!await isOfferOwner(e,i,r)){null===(t=null==r?void 0:r.fail)||void 0===t||t.call(r,"User does not own this offer");throw(0,error_1.createError)({statusCode:403,message:"You don't have permission to modify this offer"})}null===(o=null==r?void 0:r.success)||void 0===o||o.call(r,"Offer ownership verified")}catch(e){null===(n=null==r?void 0:r.fail)||void 0===n||n.call(r,e.message||"Failed to verify offer ownership");throw e}}async function requireTradeParticipation(e,i,r){var l,t,o,n;try{null===(l=null==r?void 0:r.step)||void 0===l||l.call(r,"Verifying trade participation");if(!await isTradeParticipant(e,i,r)){null===(t=null==r?void 0:r.fail)||void 0===t||t.call(r,"User is not part of this trade");throw(0,error_1.createError)({statusCode:403,message:"You are not part of this trade"})}null===(o=null==r?void 0:r.success)||void 0===o||o.call(r,"Trade participation verified")}catch(e){null===(n=null==r?void 0:r.fail)||void 0===n||n.call(r,e.message||"Failed to verify trade participation");throw e}}async function logP2PAdminAction(e,i,r,l,t,o){var n,a,s;try{null===(n=null==o?void 0:o.step)||void 0===n||n.call(o,`Logging admin action: ${i} for ${r} ${l}`);await db_1.models.p2pActivityLog.create({userId:e,type:`ADMIN_${i}`,action:i,relatedEntity:r,relatedEntityId:l,details:JSON.stringify({...t,timestamp:(new Date).toISOString(),isAdminAction:!0})});null===(a=null==o?void 0:o.success)||void 0===a||a.call(o,"Admin action logged successfully")}catch(e){null===(s=null==o?void 0:o.fail)||void 0===s||s.call(o,e.message||"Failed to log admin action");console_1.logger.error("P2P_ADMIN","Failed to log P2P admin action",e)}}Object.defineProperty(exports,"__esModule",{value:!0});exports.isOfferOwner=isOfferOwner;exports.isTradeParticipant=isTradeParticipant;exports.isPaymentMethodOwner=isPaymentMethodOwner;exports.requireOfferOwnership=requireOfferOwnership;exports.requireTradeParticipation=requireTradeParticipation;exports.logP2PAdminAction=logP2PAdminAction;const db_1=require("@b/db"),error_1=require("@b/utils/error"),console_1=require("@b/utils/console");