"use strict";async function notifyTradeEvent(e,a,r,t){var i,s,n,o,l,d,u;try{null===(i=null==t?void 0:t.step)||void 0===i||i.call(t,`Notifying trade event: ${a} for trade ${e}`);const u=await db_1.models.p2pTrade.findByPk(e,{include:[{model:db_1.models.user,as:"buyer",attributes:["id","email","firstName","lastName"]},{model:db_1.models.user,as:"seller",attributes:["id","email","firstName","lastName"]}]});if(!u){null===(s=null==t?void 0:t.fail)||void 0===s||s.call(t,`Trade ${e} not found`);console_1.logger.error("P2P_NOTIF",`Trade ${e} not found for notification`);return}null===(n=null==t?void 0:t.step)||void 0===n||n.call(t,"Determining notification recipients");const c=await getRecipientsForEvent(u,a,r);null===(o=null==t?void 0:t.step)||void 0===o||o.call(t,`Sending notifications to ${c.length} recipient(s)`);for(const r of c)try{const i=getChannelsForEvent(a,r.sendEmail);await notification_1.notificationService.send({userId:r.userId,type:"TRADE",channels:i,data:{title:r.title,message:r.message,link:`/p2p/trade/${e}`,relatedId:e},priority:getEventPriority(a),idempotencyKey:`p2p-${a}-${e}-${r.userId}`});null===(l=null==t?void 0:t.step)||void 0===l||l.call(t,`Notification sent to user ${r.userId}`)}catch(e){console_1.logger.error("P2P_NOTIF",`Failed to create notification for user ${r.userId}`,e)}null===(d=null==t?void 0:t.success)||void 0===d||d.call(t,`Trade event notifications sent successfully for ${a}`)}catch(e){null===(u=null==t?void 0:t.fail)||void 0===u||u.call(t,e.message||`Failed to send trade notification for ${a}`);console_1.logger.error("P2P_NOTIF",`Failed to send trade notification for ${a}`,e)}}async function getRecipientsForEvent(e,a,r){const t=[];switch(a){case"TRADE_INITIATED":const a=r.initiatorId===e.buyer.id?e.seller:e.buyer;t.push({userId:a.id,email:a.email,userName:`${a.firstName} ${a.lastName}`,title:"New P2P Trade Request",message:`You have a new trade request for ${r.amount} ${r.currency}`,sendEmail:!0});break;case"PAYMENT_CONFIRMED":t.push({userId:e.seller.id,email:e.seller.email,userName:`${e.seller.firstName} ${e.seller.lastName}`,title:"Payment Confirmed",message:`Buyer has confirmed payment for ${r.amount} ${r.currency}. Please verify and release funds.`,sendEmail:!0});break;case"ESCROW_RELEASED":t.push({userId:e.buyer.id,email:e.buyer.email,userName:`${e.buyer.firstName} ${e.buyer.lastName}`,title:"Funds Released",message:`Seller has released ${r.amount} ${r.currency} to your wallet.`,sendEmail:!0});break;case"TRADE_COMPLETED":t.push({userId:e.buyer.id,email:e.buyer.email,userName:`${e.buyer.firstName} ${e.buyer.lastName}`,title:"Trade Completed",message:`Your trade for ${r.amount} ${r.currency} has been completed successfully.`,sendEmail:!0});t.push({userId:e.seller.id,email:e.seller.email,userName:`${e.seller.firstName} ${e.seller.lastName}`,title:"Trade Completed",message:`Your trade for ${r.amount} ${r.currency} has been completed successfully.`,sendEmail:!0});break;case"TRADE_DISPUTED":t.push({userId:e.buyer.id,email:e.buyer.email,userName:`${e.buyer.firstName} ${e.buyer.lastName}`,title:"Trade Disputed",message:`Trade #${e.id} has been disputed. Our support team will review the case.`,sendEmail:!0});t.push({userId:e.seller.id,email:e.seller.email,userName:`${e.seller.firstName} ${e.seller.lastName}`,title:"Trade Disputed",message:`Trade #${e.id} has been disputed. Our support team will review the case.`,sendEmail:!0});await notifyAdmins("TRADE_DISPUTED",{tradeId:e.id,buyerId:e.buyerId,sellerId:e.sellerId,amount:r.amount,currency:r.currency,reason:r.reason});break;case"TRADE_CANCELLED":const i=r.cancelledBy===e.buyerId?e.buyer:e.seller,s=r.cancelledBy===e.buyerId?e.seller:e.buyer;t.push({userId:s.id,email:s.email,userName:`${s.firstName} ${s.lastName}`,title:"Trade Cancelled",message:`Trade for ${r.amount} ${r.currency} has been cancelled by ${i.firstName}.`,sendEmail:!0});break;case"TRADE_MESSAGE":case"NEW_MESSAGE":const n=r.senderId===e.buyerId?e.seller:e.buyer;t.push({userId:n.id,email:n.email,userName:`${n.firstName} ${n.lastName}`,title:"New Message in P2P Trade",message:`You have a new message in your trade for ${r.amount} ${r.currency}`,sendEmail:!1});break;case"TRADE_EXPIRED":t.push({userId:e.buyer.id,email:e.buyer.email,userName:`${e.buyer.firstName} ${e.buyer.lastName}`,title:"Trade Expired",message:`Trade for ${r.amount} ${r.currency} has expired.`,sendEmail:!0});t.push({userId:e.seller.id,email:e.seller.email,userName:`${e.seller.firstName} ${e.seller.lastName}`,title:"Trade Expired",message:`Trade for ${r.amount} ${r.currency} has expired.`,sendEmail:!0});break;case"ADMIN_MESSAGE":t.push({userId:e.buyer.id,email:e.buyer.email,userName:`${e.buyer.firstName} ${e.buyer.lastName}`,title:"Message from Admin",message:r.message||`Admin has sent a message regarding your trade for ${r.amount} ${r.currency}`,sendEmail:!0});t.push({userId:e.seller.id,email:e.seller.email,userName:`${e.seller.firstName} ${e.seller.lastName}`,title:"Message from Admin",message:r.message||`Admin has sent a message regarding your trade for ${r.amount} ${r.currency}`,sendEmail:!0})}return t}async function notifyAdmins(e,a,r){var t,i,s,n,o,l;try{null===(t=null==r?void 0:r.step)||void 0===t||t.call(r,`Notifying admins about ${e}`);const l=await db_1.models.user.findAll({include:[{model:db_1.models.role,as:"role",where:{name:["Admin","Super Admin"]}}],attributes:["id","email","firstName","lastName"]});if(!l||0===l.length){null===(i=null==r?void 0:r.fail)||void 0===i||i.call(r,"No admin users found");console_1.logger.warn("P2P_NOTIF","No admin users found for P2P notifications");return}null===(s=null==r?void 0:r.step)||void 0===s||s.call(r,`Found ${l.length} admin(s) to notify`);let d="",u="",c="";switch(e){case"TRADE_DISPUTED":d="P2P Trade Disputed";u=`Trade #${a.tradeId} has been disputed. Reason: ${a.reason||"Not specified"}. Amount: ${a.amount} ${a.currency}`;c=`/admin/p2p/trade/${a.tradeId}`;break;case"P2P_SECURITY_ALERT":d=`P2P Security Alert - ${a.riskLevel}`;u=`${a.eventType} detected for ${a.entityType} #${a.entityId}. User: ${a.userId}`;c=`/admin/p2p/${a.entityType.toLowerCase()}/${a.entityId}`;break;case"HIGH_VALUE_TRADE":d="High Value P2P Trade";u=`Large trade initiated: ${a.amount} ${a.currency}. Trade ID: ${a.tradeId}`;c=`/admin/p2p/trade/${a.tradeId}`;break;case"SUSPICIOUS_ACTIVITY":d="Suspicious P2P Activity";u=`Suspicious activity detected for user ${a.userId}. ${a.description||""}`;c="/admin/p2p/activity-log";break;default:d="P2P Admin Notification";u=`Event: ${e}`;c="/admin/p2p"}null===(n=null==r?void 0:r.step)||void 0===n||n.call(r,"Creating admin notifications");const m=l.map(e=>e.id);m.length>0&&await notification_1.notificationService.sendBatch({userIds:m,type:"ALERT",channels:["IN_APP","EMAIL","PUSH"],data:{title:d,message:u,link:c},priority:"HIGH"});null===(o=null==r?void 0:r.success)||void 0===o||o.call(r,`Sent P2P admin notifications (${e}) to ${l.length} admin(s)`);console_1.logger.debug("P2P_NOTIF",`Sent P2P admin notifications (${e}) to ${l.length} admin(s)`)}catch(e){null===(l=null==r?void 0:r.fail)||void 0===l||l.call(r,e.message||"Failed to notify admins");console_1.logger.error("P2P_NOTIF","Failed to notify admins",e)}}async function notifyOfferEvent(e,a,r,t){var i,s,n,o,l;try{null===(i=null==t?void 0:t.step)||void 0===i||i.call(t,`Notifying offer event: ${a} for offer ${e}`);const l=await db_1.models.p2pOffer.findByPk(e,{include:[{model:db_1.models.user,as:"user",attributes:["id","email","firstName","lastName"]}]});if(!l||!l.user){null===(s=null==t?void 0:t.fail)||void 0===s||s.call(t,`Offer ${e} or owner not found`);console_1.logger.error("P2P_NOTIF",`Offer ${e} or owner not found for notification`);return}let d="",u="",c=`/p2p/offer/${e}`;switch(a){case"OFFER_APPROVED":d="Offer Approved";u=`Your P2P ${l.type} offer for ${l.currency} has been approved and is now active.`;break;case"OFFER_REJECTED":d="Offer Rejected";u=`Your P2P ${l.type} offer for ${l.currency} has been rejected. ${r.reason?`Reason: ${r.reason}`:"Please contact support for details."}`;break;case"OFFER_EXPIRED":d="Offer Expired";u=`Your P2P ${l.type} offer for ${l.currency} has expired and is no longer active.`;break;case"OFFER_LOW_BALANCE":d="Offer Low Balance";u=`Your P2P SELL offer for ${l.currency} has insufficient balance to fulfill new trades.`;c=`/p2p/offer/${e}/edit`;break;case"OFFER_TRADE_INITIATED":d="New Trade on Your Offer";u=`Someone wants to trade ${r.amount} ${l.currency} on your ${l.type} offer.`;c=`/p2p/trade/${r.tradeId}`;break;default:d="Offer Update";u="Your P2P offer has been updated."}null===(n=null==t?void 0:t.step)||void 0===n||n.call(t,"Creating offer notification");const m=["IN_APP","PUSH"];let f="NORMAL";if(["OFFER_APPROVED","OFFER_REJECTED","OFFER_TRADE_INITIATED"].includes(a)){m.push("EMAIL");f="OFFER_REJECTED"===a?"HIGH":"NORMAL"}"OFFER_LOW_BALANCE"===a&&(f="HIGH");await notification_1.notificationService.send({userId:l.user.id,type:"TRADE",channels:m,data:{title:d,message:u,link:c,relatedId:e},priority:f,idempotencyKey:`p2p-offer-${a}-${e}`});null===(o=null==t?void 0:t.success)||void 0===o||o.call(t,`Sent offer notification (${a}) to user ${l.user.id}`);console_1.logger.debug("P2P_NOTIF",`Sent offer notification (${a}) to user ${l.user.id}`)}catch(e){null===(l=null==t?void 0:t.fail)||void 0===l||l.call(t,e.message||"Failed to send offer notification");console_1.logger.error("P2P_NOTIF","Failed to send offer notification",e)}}async function notifyReputationEvent(e,a,r){try{let t="",i="",s="/p2p/profile",n="system";switch(a){case"REPUTATION_INCREASED":t="Reputation Increased";i=`Your P2P reputation has increased! You now have ${r.newRating||r.rating} stars.`;n="system";break;case"REPUTATION_DECREASED":t="Reputation Decreased";i=`Your P2P reputation has decreased${r.reason?` due to ${r.reason}`:""}.${r.newRating?` Current rating: ${r.newRating} stars.`:""}`;n="alert";break;case"MILESTONE_REACHED":t="Milestone Reached!";i=`Congratulations! You've completed ${r.trades} P2P trade${r.trades>1?"s":""}.${r.milestone?` ${r.milestone}`:""}`;n="system";break;case"POSITIVE_REVIEW":t="New Positive Review";i="You received a positive review from a trading partner!"+(r.comment?` "${r.comment}"`:"");s="/p2p/reviews";n="system";break;case"NEGATIVE_REVIEW":t="New Review Received";i="You received a review from a trading partner."+(r.rating?` Rating: ${r.rating} stars.`:"");s="/p2p/reviews";n="alert";break;case"TRUSTED_STATUS":t="Trusted Trader Status";i=`Congratulations! You've earned Trusted Trader status with ${r.completedTrades} completed trades and ${r.rating}+ rating.`;n="system";break;default:t="Reputation Update";i="Your P2P reputation has been updated.";n="system"}const o=["IN_APP","PUSH"];let l="NORMAL";if(["REPUTATION_DECREASED","NEGATIVE_REVIEW","MILESTONE_REACHED","TRUSTED_STATUS"].includes(a)){o.push("EMAIL");l="REPUTATION_DECREASED"===a||"NEGATIVE_REVIEW"===a?"HIGH":"NORMAL"}await notification_1.notificationService.send({userId:e,type:"alert"===n?"ALERT":"SYSTEM",channels:o,data:{title:t,message:i,link:s},priority:l,idempotencyKey:`p2p-reputation-${a}-${e}-${Date.now()}`});console_1.logger.debug("P2P_NOTIF",`Sent reputation notification (${a}) to user ${e}`)}catch(e){console_1.logger.error("P2P_NOTIF","Failed to send reputation notification",e)}}function getChannelsForEvent(e,a){const r=["IN_APP"];a&&(["TRADE_DISPUTED","TRADE_EXPIRED"].includes(e)||["TRADE_INITIATED","TRADE_COMPLETED","TRADE_CANCELLED","PAYMENT_CONFIRMED","ESCROW_RELEASED"].includes(e))&&r.push("EMAIL");"TRADE_MESSAGE"!==e&&"NEW_MESSAGE"!==e&&r.push("PUSH");return r}function getEventPriority(e){return["TRADE_DISPUTED","TRADE_EXPIRED"].includes(e)?"URGENT":["PAYMENT_CONFIRMED","ESCROW_RELEASED"].includes(e)?"HIGH":"NORMAL"}Object.defineProperty(exports,"__esModule",{value:!0});exports.notifyTradeEvent=notifyTradeEvent;exports.notifyAdmins=notifyAdmins;exports.notifyOfferEvent=notifyOfferEvent;exports.notifyReputationEvent=notifyReputationEvent;const db_1=require("@b/db"),console_1=require("@b/utils/console"),notification_1=require("@b/services/notification");