"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize");exports.metadata={summary:"Get Trade History with Pagination",description:"Retrieves paginated trade history for the authenticated user with filtering options.",operationId:"getP2PTradeHistory",tags:["P2P","Trade"],logModule:"P2P",logTitle:"Get trade history",requiresAuth:!0,middleware:["p2pSearchRateLimit"],parameters:[{name:"page",in:"query",description:"Page number (1-based)",required:!1,schema:{type:"integer",minimum:1,default:1}},{name:"limit",in:"query",description:"Number of items per page",required:!1,schema:{type:"integer",minimum:1,maximum:100,default:20}},{name:"status",in:"query",description:"Filter by trade status",required:!1,schema:{type:"string",enum:["PENDING","PAYMENT_SENT","ESCROW_RELEASED","COMPLETED","DISPUTED","CANCELLED","EXPIRED"]}},{name:"type",in:"query",description:"Filter by trade type",required:!1,schema:{type:"string",enum:["BUY","SELL"]}},{name:"currency",in:"query",description:"Filter by cryptocurrency",required:!1,schema:{type:"string"}},{name:"dateFrom",in:"query",description:"Filter trades from this date",required:!1,schema:{type:"string",format:"date"}},{name:"dateTo",in:"query",description:"Filter trades until this date",required:!1,schema:{type:"string",format:"date"}},{name:"search",in:"query",description:"Search by trade ID or counterparty name",required:!1,schema:{type:"string"}},{name:"sortBy",in:"query",description:"Sort field",required:!1,schema:{type:"string",enum:["createdAt","updatedAt","amount","totalAmount","status"],default:"createdAt"}},{name:"sortOrder",in:"query",description:"Sort order",required:!1,schema:{type:"string",enum:["ASC","DESC"],default:"DESC"}}],responses:{200:{description:"Trade history retrieved successfully.",content:{"application/json":{schema:{type:"object",properties:{trades:{type:"array",items:{type:"object",properties:{id:{type:"string"},type:{type:"string",enum:["BUY","SELL"]},currency:{type:"string"},amount:{type:"number"},price:{type:"number"},totalAmount:{type:"number"},status:{type:"string"},counterparty:{type:"object"},paymentMethod:{type:"string"},createdAt:{type:"string",format:"date-time"},updatedAt:{type:"string",format:"date-time"}}}},pagination:{type:"object",properties:{page:{type:"integer"},limit:{type:"integer"},total:{type:"integer"},totalPages:{type:"integer"},hasNext:{type:"boolean"},hasPrev:{type:"boolean"}}},summary:{type:"object",properties:{totalVolume:{type:"number"},completedCount:{type:"integer"},successRate:{type:"number"}}}}}}}},401:{description:"Unauthorized."},500:{description:"Internal Server Error."}}};exports.default=async e=>{const{query:t={},user:r,ctx:a}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==a||a.step("Parsing query parameters and building filters");try{const e=Math.max(1,parseInt(t.page)||1),i=Math.min(100,Math.max(1,parseInt(t.limit)||20)),s=(e-1)*i,o={[sequelize_1.Op.or]:[{buyerId:r.id},{sellerId:r.id}]};t.status&&(o.status=t.status);t.currency&&(o.currency=t.currency.toUpperCase());if(t.dateFrom||t.dateTo){o.createdAt={};t.dateFrom&&(o.createdAt[sequelize_1.Op.gte]=new Date(t.dateFrom));t.dateTo&&(o.createdAt[sequelize_1.Op.lte]=new Date(t.dateTo))}let n=null;t.type&&("BUY"===t.type?n={buyerId:r.id}:"SELL"===t.type&&(n={sellerId:r.id}));n&&(o[sequelize_1.Op.and]=[n]);if(t.search){const e=[{id:{[sequelize_1.Op.iLike]:`%${t.search}%`}}];o[sequelize_1.Op.and]=o[sequelize_1.Op.and]||[];o[sequelize_1.Op.and].push({[sequelize_1.Op.or]:e})}null==a||a.step(`Fetching trade history (page ${e}, limit ${i})`);const[d,u]=await Promise.all([db_1.models.p2pTrade.findAll({where:o,include:[{model:db_1.models.user,as:"buyer",attributes:["id","firstName","lastName","avatar"]},{model:db_1.models.user,as:"seller",attributes:["id","firstName","lastName","avatar"]},{model:db_1.models.p2pOffer,as:"offer",attributes:["id","currency","type"]},{model:db_1.models.p2pPaymentMethod,as:"paymentMethod",attributes:["id","name","icon"]}],order:[[t.sortBy||"createdAt",t.sortOrder||"DESC"]],limit:i,offset:s}),db_1.models.p2pTrade.count({where:o})]),p=(await db_1.models.p2pTrade.findAll({where:o,attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("totalAmount")),"totalVolume"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("CASE WHEN status = 'COMPLETED' THEN 1 END")),"completedCount"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"totalCount"]],raw:!0}))[0]||{},l=p.totalCount>0?Math.round(p.completedCount/p.totalCount*100):0,m=d.map(e=>{var t;const a=e.buyerId===r.id,i=a?e.seller:e.buyer;return{id:e.id,type:a?"BUY":"SELL",currency:(null===(t=e.offer)||void 0===t?void 0:t.currency)||e.currency,amount:e.amount,price:e.price,totalAmount:e.totalAmount,status:e.status,counterparty:i?{id:i.id,name:`${i.firstName} ${i.lastName}`.trim()||"Anonymous",avatar:i.avatar}:null,paymentMethod:e.paymentMethod?{id:e.paymentMethod.id,name:e.paymentMethod.name,icon:e.paymentMethod.icon}:null,createdAt:e.createdAt,updatedAt:e.updatedAt,completedAt:e.completedAt,expiresAt:e.expiresAt}});null==a||a.success(`Retrieved ${m.length} trades (page ${e}/${Math.ceil(u/i)})`);const c=Math.ceil(u/i);return{trades:m,pagination:{page:e,limit:i,total:u,totalPages:c,hasNext:e<c,hasPrev:e>1},summary:{totalVolume:parseFloat(p.totalVolume||0),completedCount:parseInt(p.completedCount||0),successRate:l}}}catch(e){null==a||a.fail(e.message||"Failed to fetch trade history");throw(0,error_1.createError)({statusCode:500,message:"Failed to fetch trade history: "+e.message})}};