"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),sequelize_1=require("sequelize"),console_1=require("@b/utils/console"),error_1=require("@b/utils/error");exports.metadata={summary:"List Payment Methods",description:"Retrieves a list of available payment methods using the payment methods model.",operationId:"listPaymentMethods",tags:["P2P","Payment Method"],logModule:"P2P",logTitle:"List payment methods",responses:{200:{description:"Payment methods retrieved successfully."},500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{const{user:t,ctx:s}=e;null==s||s.step("Fetching payment methods");try{const e=await db_1.models.p2pPaymentMethod.findAll({where:{available:!0,[sequelize_1.Op.or]:[{isGlobal:!0},{userId:null}]},order:[["isGlobal","DESC"],["popularityRank","ASC"],["name","ASC"]],raw:!0});let o=[];if(null==t?void 0:t.id){o=await db_1.models.p2pPaymentMethod.findAll({where:{userId:t.id,available:!0},order:[["popularityRank","ASC"],["name","ASC"]],raw:!0});const e=o.map(e=>e.id);if(e.length>0){const t=await db_1.models.p2pTrade.findAll({where:{status:{[sequelize_1.Op.in]:["PENDING","PAYMENT_SENT","DISPUTED"]},paymentMethod:{[sequelize_1.Op.in]:e}},attributes:["paymentMethod"],raw:!0}),s=new Set(t.map(e=>e.paymentMethod)),a=await db_1.models.p2pOffer.findAll({include:[{model:db_1.models.p2pPaymentMethod,as:"paymentMethods",where:{id:{[sequelize_1.Op.in]:e}},attributes:["id"],through:{attributes:[]}}],where:{status:{[sequelize_1.Op.in]:["ACTIVE","PENDING_APPROVAL","PAUSED"]}},attributes:["id"]}),r=new Set;for(const e of a){const t=e.paymentMethods||[];for(const e of t)r.add(e.id)}o=o.map(e=>{const t=s.has(e.id),o=r.has(e.id);return{...e,icon:null,isCustom:!0,isGlobal:!1,isSystem:!1,canEdit:!t,canDelete:!t&&!o,hasActiveTrade:t,hasActiveOffer:o,usageInfo:t||o?{inActiveTrade:t,inActiveOffer:o}:null}})}}const a=e.map(e=>({...e,isCustom:!1,isGlobal:!0===e.isGlobal||1===e.isGlobal,isSystem:null===e.userId&&!e.isGlobal,canEdit:!1,canDelete:!1,hasActiveTrade:!1}));console_1.logger.info("P2P_PAYMENT_METHOD",`Found ${e.length} global/system and ${o.length} custom methods for user ${(null==t?void 0:t.id)||"anonymous"}`);null==s||s.success(`Retrieved ${e.length} global and ${o.length} custom methods`);return{global:a,custom:o}}catch(e){console_1.logger.error("P2P_PAYMENT_METHOD","Error fetching payment methods",e);null==s||s.fail(e.message||"Failed to fetch payment methods");throw(0,error_1.createError)({statusCode:500,message:"Internal Server Error: "+e.message})}};