"use strict";async function getCurrentPhase(e,t){const n=await db_1.models.icoTokenOffering.findByPk(e,{transaction:t});if(!n)return null;const a=await db_1.models.icoTokenOfferingPhase.findAll({where:{offeringId:e},order:[["sequence","ASC"]],transaction:t});if(0===a.length)return null;const i=new Date;let r=new Date(n.startDate);for(let e=0;e<a.length;e++){const t=a[e],n=new Date(r);n.setDate(n.getDate()+t.duration);if(i>=r&&i<n&&t.remaining>0)return{id:t.id,name:t.name,tokenPrice:t.tokenPrice,allocation:t.allocation,remaining:t.remaining,duration:t.duration,startDate:r,endDate:n,isActive:!0,index:e};r=n}return null}async function getNextPhase(e,t,n){const a=await db_1.models.icoTokenOffering.findByPk(e,{transaction:n});if(!a)return null;const i=await db_1.models.icoTokenOfferingPhase.findAll({where:{offeringId:e},order:[["sequence","ASC"]],transaction:n});if(t+1>=i.length)return null;const r=new Date(a.startDate);for(let e=0;e<=t+1;e++){const n=i[e];if(e===t+1){const t=new Date(r);t.setDate(t.getDate()+n.duration);return{id:n.id,name:n.name,tokenPrice:n.tokenPrice,allocation:n.allocation,remaining:n.remaining,duration:n.duration,startDate:r,endDate:t,isActive:!1,index:e}}r.setDate(r.getDate()+n.duration)}return null}async function checkAndUpdateOfferingStatus(){const e=await db_1.sequelize.transaction();try{const t=await db_1.models.icoTokenOffering.findAll({where:{status:"ACTIVE",endDate:{[sequelize_1.Op.lte]:new Date}},transaction:e});for(const n of t){const t=await db_1.models.icoTransaction.sum("amount",{where:{offeringId:n.id,status:{[sequelize_1.Op.in]:["PENDING","VERIFICATION","RELEASED"]}},transaction:e})||0,a=t>=.75*n.targetAmount?"SUCCESS":"FAILED";await n.update({status:a},{transaction:e});await(0,notifications_1.createNotification)({userId:n.userId,relatedId:n.id,type:"system",title:"ICO Offering Ended",message:`Your ICO offering "${n.name}" has ended with status: ${a}`,details:`Total raised: ${t} ${n.purchaseWalletCurrency} (Target: ${n.targetAmount})`,link:`/ico/creator/token/${n.id}`});"FAILED"===a&&await db_1.models.icoTransaction.update({status:"REFUND_PENDING"},{where:{offeringId:n.id,status:{[sequelize_1.Op.in]:["PENDING","VERIFICATION"]}},transaction:e})}const n=await db_1.models.icoTokenOffering.findAll({where:{status:"UPCOMING",startDate:{[sequelize_1.Op.lte]:new Date}},transaction:e});for(const t of n){await t.update({status:"ACTIVE"},{transaction:e});await(0,notifications_1.createNotification)({userId:t.userId,relatedId:t.id,type:"system",title:"ICO Offering Started",message:`Your ICO offering "${t.name}" is now active!`,link:`/ico/creator/token/${t.id}`})}await e.commit()}catch(t){await e.rollback();console_1.logger.error("ICO","Error updating offering statuses",t);throw t}}async function transitionToNextPhase(e){const t=await db_1.sequelize.transaction();try{const n=await getCurrentPhase(e,t);if(!n)return!1;const a=await getNextPhase(e,n.index,t);if(!a)return!1;const i=await db_1.models.icoTokenOffering.findByPk(e,{transaction:t});if(!i)return!1;await i.update({tokenPrice:a.tokenPrice},{transaction:t});await db_1.models.icoAdminActivity.create({type:"PHASE_TRANSITION",offeringId:i.id,offeringName:i.name,adminId:null,details:JSON.stringify({fromPhase:n.name,toPhase:a.name,oldPrice:n.tokenPrice,newPrice:a.tokenPrice})},{transaction:t});await(0,notifications_1.createNotification)({userId:i.userId,relatedId:i.id,type:"system",title:"ICO Phase Transition",message:`${i.name} has moved to phase: ${a.name}`,details:`New token price: ${a.tokenPrice} ${i.purchaseWalletCurrency}`,link:`/ico/creator/token/${i.id}`});await t.commit();return!0}catch(e){await t.rollback();console_1.logger.error("ICO","Error transitioning phase",e);return!1}}async function checkSoftCap(e){const t=await db_1.models.icoTokenOffering.findByPk(e);if(!t)return!1;return(await db_1.models.icoTransaction.sum("amount",{where:{offeringId:t.id,status:{[sequelize_1.Op.in]:["PENDING","VERIFICATION","RELEASED"]}}})||0)>=.3*t.targetAmount}async function checkHardCap(e){const t=await db_1.models.icoTokenOffering.findByPk(e);if(!t)return!1;return(await db_1.models.icoTransaction.sum("amount",{where:{offeringId:t.id,status:{[sequelize_1.Op.in]:["PENDING","VERIFICATION","RELEASED"]}}})||0)>=t.targetAmount}Object.defineProperty(exports,"__esModule",{value:!0});exports.getCurrentPhase=getCurrentPhase;exports.getNextPhase=getNextPhase;exports.checkAndUpdateOfferingStatus=checkAndUpdateOfferingStatus;exports.transitionToNextPhase=transitionToNextPhase;exports.checkSoftCap=checkSoftCap;exports.checkHardCap=checkHardCap;const db_1=require("@b/db"),sequelize_1=require("sequelize"),notifications_1=require("@b/utils/notifications"),console_1=require("@b/utils/console");