"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error");exports.metadata={summary:"Get User Portfolio Overview",description:"Retrieves a summary of the user's ICO portfolio including total invested, pending investment, pending verification investment, received investment, rejected investment, current portfolio value, total profit/loss, and ROI. Pending investments indicate funds invested for tokens not yet received, and rejected investments indicate funds that were refunded.",operationId:"getUserPortfolioOverview",tags:["ICO","Portfolio"],logModule:"ICO",logTitle:"Get ICO Portfolio",requiresAuth:!0,responses:{200:{description:"User portfolio overview retrieved successfully.",content:{"application/json":{schema:{type:"object",properties:{totalInvested:{type:"number"},pendingInvested:{type:"number"},pendingVerificationInvested:{type:"number"},receivedInvested:{type:"number"},rejectedInvested:{type:"number"},currentValue:{type:"number"},totalProfitLoss:{type:"number"},roi:{type:"number"}}}}}},401:{description:"Unauthorized."},500:{description:"Internal Server Error."}}};exports.default=async e=>{const{user:t,ctx:r}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==r||r.step("Fetching ICO portfolio");try{const e=await db_1.models.icoTransaction.findAll({where:{userId:t.id,status:"PENDING"},include:[{model:db_1.models.icoTokenOffering,as:"offering",attributes:["currentPrice","tokenPrice"]}]}),n=await db_1.models.icoTransaction.findAll({where:{userId:t.id,status:"VERIFICATION"},include:[{model:db_1.models.icoTokenOffering,as:"offering",attributes:["currentPrice","tokenPrice"]}]}),o=await db_1.models.icoTransaction.findAll({where:{userId:t.id,status:"RELEASED"},include:[{model:db_1.models.icoTokenOffering,as:"offering",attributes:["currentPrice","tokenPrice"]}]}),i=await db_1.models.icoTransaction.findAll({where:{userId:t.id,status:"REJECTED"},include:[{model:db_1.models.icoTokenOffering,as:"offering",attributes:["currentPrice","tokenPrice"]}]});let s=0,d=0,c=0,a=0,u=0,l=0;e.forEach(e=>{const t=e.amount*e.price;s+=t;d+=t});n.forEach(e=>{const t=e.amount*e.price;s+=t;c+=t});o.forEach(e=>{const t=e.amount*e.price;s+=t;a+=t;const r=e.offering,n=null!=(null==r?void 0:r.currentPrice)?r.currentPrice:null==r?void 0:r.tokenPrice,o=n?e.amount*n:t;l+=o});i.forEach(e=>{const t=e.amount*e.price;u+=t});null==r||r.success("ICO portfolio retrieved successfully");return{totalInvested:s,pendingInvested:d,pendingVerificationInvested:c,receivedInvested:a,rejectedInvested:u,currentValue:l}}catch(e){throw(0,error_1.createError)({statusCode:500,message:"Internal Server Error"})}};