"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize");exports.metadata={summary:"Get Creator ICO Offerings",description:"Retrieves ICO offerings for the authenticated creator, grouped by status (active, pending, completed) along with currentRaised for each offering.",operationId:"getCreatorOfferings",tags:["ICO","Creator","Offerings"],logModule:"ICO",logTitle:"Get Creator Tokens",requiresAuth:!0,responses:{200:{description:"Creator offerings retrieved successfully.",content:{"application/json":{schema:{type:"object",properties:{active:{type:"array",items:{type:"object"}},pending:{type:"array",items:{type:"object"}},completed:{type:"array",items:{type:"object"}}}}}}},401:{description:"Unauthorized"},500:{description:"Internal Server Error"}}};exports.default=async e=>{const{user:r,ctx:t}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==t||t.step("Fetching creator tokens");const s=await db_1.models.icoTokenOffering.findAll({where:{userId:r.id},raw:!0});if(!s.length){null==t||t.success("Creator tokens retrieved successfully");return{active:[],pending:[],completed:[]}}const i=s.map(e=>e.id),o=await db_1.models.icoTransaction.findAll({attributes:["offeringId",[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("price * amount")),"currentRaised"]],where:{offeringId:{[sequelize_1.Op.in]:i},status:{[sequelize_1.Op.not]:["REJECTED"]}},group:["offeringId"],raw:!0}),a={};o.forEach(e=>{a[e.offeringId]=parseFloat(e.currentRaised)||0});const n=s.map(e=>({...e,currentRaised:a[e.id]||0})),c=n.filter(e=>"ACTIVE"===e.status),u=n.filter(e=>"PENDING"===e.status),d=n.filter(e=>"SUCCESS"===e.status);null==t||t.success("Get Creator Tokens retrieved successfully");return{active:c,pending:u,completed:d}};