"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize");exports.metadata={summary:"Get Creator Stats",description:"Retrieves aggregated statistics (counts, growth metrics) for the authenticated creator's ICO offerings, and calculates total raised and raise growth from all transactions except those with a 'REJECTED' status.",operationId:"getCreatorStatsStats",tags:["ICO","Creator","Stats"],logModule:"ICO",logTitle:"Get Creator Stats",requiresAuth:!0,responses:{200:{description:"Creator statistics retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{totalOfferings:{type:"number"},pendingOfferings:{type:"number"},activeOfferings:{type:"number"},completedOfferings:{type:"number"},rejectedOfferings:{type:"number"},totalRaised:{type:"number"},currentRaised:{type:"number"},previousRaised:{type:"number"},offeringsGrowth:{type:"number"},activeGrowth:{type:"number"},raiseGrowth:{type:"number"}}}}}},401:{description:"Unauthorized"},500:{description:"Internal server error"}}};exports.default=async e=>{const{user:t,ctx:r}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==r||r.step("Fetching creator stats");const i=t.id,s=new Date,n=new Date(s.getFullYear(),s.getMonth(),1),a=new Date(s.getFullYear(),s.getMonth()-1,1),o=new Date(s.getFullYear(),s.getMonth(),0),u=db_1.models.icoTokenOffering.findOne({attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("*")),"totalOfferings"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN `icoTokenOffering`.`status` = 'PENDING' THEN 1 ELSE 0 END")),"pendingOfferings"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN `icoTokenOffering`.`status` = 'ACTIVE' THEN 1 ELSE 0 END")),"activeOfferings"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN `icoTokenOffering`.`status` = 'SUCCESS' THEN 1 ELSE 0 END")),"completedOfferings"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN `icoTokenOffering`.`status` = 'REJECTED' THEN 1 ELSE 0 END")),"rejectedOfferings"]],where:{userId:i},raw:!0}),l=db_1.models.icoTokenOffering.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN \`icoTokenOffering\`.\`createdAt\` >= '${n.toISOString()}' THEN 1 ELSE 0 END`)),"currentOfferingsCount"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN \`icoTokenOffering\`.\`createdAt\` >= '${n.toISOString()}' AND \`icoTokenOffering\`.\`status\` = 'ACTIVE' THEN 1 ELSE 0 END`)),"currentActive"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN \`icoTokenOffering\`.\`createdAt\` >= '${n.toISOString()}' THEN 1 ELSE 0 END`)),"currentTotal"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN \`icoTokenOffering\`.\`createdAt\` BETWEEN '${a.toISOString()}' AND '${o.toISOString()}' THEN 1 ELSE 0 END`)),"previousOfferingsCount"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN \`icoTokenOffering\`.\`createdAt\` BETWEEN '${a.toISOString()}' AND '${o.toISOString()}' AND \`icoTokenOffering\`.\`status\` = 'ACTIVE' THEN 1 ELSE 0 END`)),"previousActive"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN \`icoTokenOffering\`.\`createdAt\` BETWEEN '${a.toISOString()}' AND '${o.toISOString()}' THEN 1 ELSE 0 END`)),"previousTotal"]],where:{userId:i},raw:!0}),c=db_1.models.icoTransaction.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN `icoTransaction`.`status` NOT IN ('REJECTED') THEN `icoTransaction`.`price` * `icoTransaction`.`amount` ELSE 0 END")),"totalRaised"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN \`icoTransaction\`.\`createdAt\` >= '${n.toISOString()}' AND \`icoTransaction\`.\`status\` NOT IN ('REJECTED') THEN \`icoTransaction\`.\`price\` * \`icoTransaction\`.\`amount\` ELSE 0 END`)),"currentRaised"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN \`icoTransaction\`.\`createdAt\` BETWEEN '${a.toISOString()}' AND '${o.toISOString()}' AND \`icoTransaction\`.\`status\` NOT IN ('REJECTED') THEN \`icoTransaction\`.\`price\` * \`icoTransaction\`.\`amount\` ELSE 0 END`)),"previousRaised"]],include:[{model:db_1.models.icoTokenOffering,as:"offering",attributes:[],where:{userId:i}}],raw:!0}),[E,f,d]=await Promise.all([u,l,c]),g=parseInt(E.totalOfferings,10)||0,S=parseInt(E.pendingOfferings,10)||0,p=parseInt(E.activeOfferings,10)||0,O=parseInt(E.completedOfferings,10)||0,T=parseInt(E.rejectedOfferings,10)||0,N=parseInt(f.currentOfferingsCount,10)||0,C=parseInt(f.previousOfferingsCount,10)||0,I=parseInt(f.currentActive,10)||0,_=parseInt(f.previousActive,10)||0,A=parseInt(f.currentTotal,10)||0,q=parseInt(f.previousTotal,10)||0,m=parseFloat(d.totalRaised)||0,z=parseFloat(d.currentRaised)||0,D=parseFloat(d.previousRaised)||0,h=C>0?Math.round((N-C)/C*100):0,H=D>0?Math.round((z-D)/D*100):0,b=A>0?Math.round(I/A*100):0,v=q>0?Math.round(_/q*100):0,M=g>0?Math.round(p/g*100):0,w=v?b-v:0;null==r||r.success("Get Creator Stats retrieved successfully");return{totalOfferings:g,pendingOfferings:S,activeOfferings:p,completedOfferings:O,rejectedOfferings:T,totalRaised:m,offeringGrowth:h,raiseGrowth:H,successRate:M,successRateGrowth:w}};