"use strict";function getTimeAgo(e){if(!e)return"just now";const t=Math.floor((Date.now()-new Date(e).getTime())/1e3);return t<60?"just now":t<3600?`${Math.floor(t/60)}m ago`:t<86400?`${Math.floor(t/3600)}h ago`:`${Math.floor(t/86400)}d ago`}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize");exports.metadata={summary:"Get Gateway Landing Page Data",description:"Retrieves optimized data for the gateway landing page including stats, supported currencies, fee structure, and recent activity.",operationId:"getGatewayLandingData",tags:["Gateway","Landing"],requiresAuth:!1,responses:{200:{description:"Gateway landing data retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{stats:{type:"object"},supportedPayments:{type:"object"},feeStructure:{type:"object"},payoutOptions:{type:"array"},recentActivity:{type:"array"},integrations:{type:"array"}}}}}}}};exports.default=async()=>{const[e,t,a,n,o,r,s,i,l,u]=await Promise.all([db_1.models.gatewayMerchant.count(),db_1.models.gatewayMerchant.count({where:{status:"ACTIVE"}}),db_1.models.gatewayPayment.count(),db_1.models.gatewayPayment.count({where:{status:"COMPLETED"}}),db_1.models.gatewayPayment.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"totalVolume"],[(0,sequelize_1.fn)("AVG",(0,sequelize_1.col)("amount")),"avgAmount"]],where:{status:"COMPLETED"},raw:!0}),db_1.models.gatewayPayment.findAll({attributes:[[(0,sequelize_1.fn)("DISTINCT",(0,sequelize_1.col)("currency")),"currency"]],where:{status:"COMPLETED"},raw:!0}),db_1.models.gatewayMerchant.findAll({attributes:[[(0,sequelize_1.fn)("DISTINCT",(0,sequelize_1.col)("country")),"country"]],where:{status:"ACTIVE",country:{[sequelize_1.Op.ne]:null}},raw:!0}),db_1.models.gatewayPayment.findOne({attributes:[[(0,sequelize_1.fn)("AVG",(0,sequelize_1.literal)("TIMESTAMPDIFF(SECOND, createdAt, completedAt)")),"avgSeconds"]],where:{status:"COMPLETED",completedAt:{[sequelize_1.Op.ne]:null}},raw:!0}),db_1.models.gatewayRefund.count({where:{status:"COMPLETED"}}),db_1.models.gatewayPayment.findAll({where:{status:"COMPLETED",testMode:!1},include:[{model:db_1.models.gatewayMerchant,as:"merchant",attributes:["name","country"]}],order:[["completedAt","DESC"]],limit:10})]),c=parseFloat(null==o?void 0:o.totalVolume)||0,d=parseFloat(null==o?void 0:o.avgAmount)||0,m=parseFloat(null==i?void 0:i.avgSeconds)||2,y=a>0?Math.round(n/a*100):99,p=n>0?Math.round(l/n*100*100)/100:0,h=r.map(e=>e.currency).filter(Boolean),g=h.filter(e=>["BTC","ETH","USDT","USDC","LTC","XRP","BNB","SOL","DOGE"].includes(e)),T=h.filter(e=>["USD","EUR","GBP","CAD","AUD","JPY","CHF"].includes(e)),f=u.slice(0,8).map(e=>{var t;return{type:"payment_completed",amount:e.amount,currency:e.currency,timeAgo:getTimeAgo(e.completedAt),merchantCategory:(null===(t=e.merchant)||void 0===t?void 0:t.country)||"Global"}});return{stats:{totalMerchants:t||e,totalTransactions:a,totalVolume:Math.round(c/1e6*100)/100,successRate:y,avgProcessingTime:Math.max(Math.round(m),1),currenciesSupported:h.length||15,countriesServed:s.length||50,avgTransactionValue:Math.round(100*d)/100,refundRate:p,uptime:99.99},supportedPayments:{fiat:T.length>0?T:["USD","EUR","GBP","CAD","AUD"],crypto:g.length>0?g:["BTC","ETH","USDT","USDC","LTC"],walletTypes:["FIAT","SPOT","ECO"]},feeStructure:{type:"BOTH",percentage:2.9,fixed:.3,example:{amount:100,fee:3.2,netAmount:96.8}},payoutOptions:[{schedule:"INSTANT",description:"Get paid immediately after each transaction",minThreshold:0,icon:"zap"},{schedule:"DAILY",description:"Automatic daily settlements at midnight UTC",minThreshold:100,icon:"calendar"},{schedule:"WEEKLY",description:"Weekly payouts every Monday",minThreshold:100,icon:"calendar-week"},{schedule:"MONTHLY",description:"Monthly payouts on the 1st",minThreshold:100,icon:"calendar-month"}],recentActivity:f,integrations:[{name:"Node.js SDK",type:"SDK",languages:["JavaScript","TypeScript"],icon:"nodejs"},{name:"Python SDK",type:"SDK",languages:["Python"],icon:"python"},{name:"PHP SDK",type:"SDK",languages:["PHP"],icon:"php"},{name:"REST API",type:"API",languages:["Any"],icon:"api"},{name:"WooCommerce",type:"PLUGIN",platforms:["WordPress"],icon:"woocommerce"},{name:"Shopify",type:"PLUGIN",platforms:["Shopify"],icon:"shopify"}]}};