"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),positions_1=require("@b/api/(ext)/futures/utils/queries/positions");let fromBigInt;try{const t=require("@b/api/(ext)/ecosystem/utils/blockchain");fromBigInt=t.fromBigInt}catch(t){}exports.metadata={summary:"List Futures Positions",operationId:"listFuturesPositions",tags:["Futures","Positions"],logModule:"FUTURES",logTitle:"List futures positions",description:"Retrieves a list of futures positions for the authenticated user.",parameters:[{name:"currency",in:"query",description:"Currency of the positions to retrieve.",schema:{type:"string"}},{name:"pair",in:"query",description:"Pair of the positions to retrieve.",schema:{type:"string"}},{name:"type",in:"query",description:"Type of positions to retrieve.",schema:{type:"string"}}],responses:{200:{description:"A list of futures positions",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{id:{type:"string"},userId:{type:"string"},symbol:{type:"string"},side:{type:"string"},entryPrice:{type:"string"},amount:{type:"string"},leverage:{type:"string"},unrealizedPnl:{type:"string"},status:{type:"string"},createdAt:{type:"string",format:"date-time"},updatedAt:{type:"string",format:"date-time"}}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Position"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async t=>{var e,i,r,s,o,n,a,u;const{user:l,query:p,ctx:d}=t;null===(e=null==d?void 0:d.step)||void 0===e||e.call(d,"Validating user authentication");if(!(null==l?void 0:l.id)){null===(i=null==d?void 0:d.fail)||void 0===i||i.call(d,"User not authenticated");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"})}const{currency:c,pair:y,type:g}=p;try{const t=c&&y?`${c}/${y}`:void 0,e="OPEN_POSITIONS"===g?"OPEN":void 0;null===(r=null==d?void 0:d.step)||void 0===r||r.call(d,`Fetching futures positions${t?` for ${t}`:""}${e?` (${e})`:""}`);const i=await(0,positions_1.getPositions)(l.id,t,e);if(!i||0===i.length){null===(s=null==d?void 0:d.success)||void 0===s||s.call(d,"No positions found");return[]}null===(o=null==d?void 0:d.step)||void 0===o||o.call(d,"Formatting position data");const u=i.map(t=>({...t,entryPrice:fromBigInt?fromBigInt(t.entryPrice):t.entryPrice,amount:fromBigInt?fromBigInt(t.amount):t.amount,leverage:t.leverage,unrealizedPnl:fromBigInt?fromBigInt(t.unrealizedPnl):t.unrealizedPnl,createdAt:t.createdAt.toISOString(),updatedAt:t.updatedAt.toISOString()}));let p=u;if("POSITIONS_HISTORY"===g){null===(n=null==d?void 0:d.step)||void 0===n||n.call(d,"Filtering for position history");p=u.filter(t=>"OPEN"!==t.status)}null===(a=null==d?void 0:d.success)||void 0===a||a.call(d,`Retrieved ${p.length} positions`);return p}catch(t){null===(u=null==d?void 0:d.fail)||void 0===u||u.call(d,`Failed to retrieve positions: ${t.message}`);throw(0,error_1.createError)({statusCode:500,message:`Failed to retrieve positions: ${t.message}`})}};