"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.ForexFraudDetector=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize"),console_1=require("@b/utils/console");class ForexFraudDetector{static async checkDeposit(e,i,l,t){var o,r,n,a,s,d,c;try{null===(o=null==t?void 0:t.step)||void 0===o||o.call(t,`Running fraud detection for deposit: ${i} ${l}`);null===(r=null==t?void 0:t.step)||void 0===r||r.call(t,"Checking recent deposit history");if(await db_1.models.transaction.count({where:{userId:e,type:"FOREX_DEPOSIT",createdAt:{[sequelize_1.Op.gte]:new Date(Date.now()-864e5)}}})>10){null===(n=null==t?void 0:t.fail)||void 0===n||n.call(t,"Too many deposits in 24 hours");return{isValid:!1,reason:"Too many deposits in 24 hours",riskScore:.8}}null===(a=null==t?void 0:t.step)||void 0===a||a.call(t,"Validating deposit amount limits");if(i>1e4){null===(s=null==t?void 0:t.fail)||void 0===s||s.call(t,"Deposit amount exceeds maximum limit");return{isValid:!1,reason:"Deposit amount exceeds maximum limit",riskScore:.9}}null===(d=null==t?void 0:t.success)||void 0===d||d.call(t,"Deposit fraud check passed");return{isValid:!0,riskScore:.1}}catch(e){console_1.logger.error("FOREX_FRAUD","Fraud detection error",e);null===(c=null==t?void 0:t.fail)||void 0===c||c.call(t,"Fraud detection check failed");return{isValid:!0,riskScore:.5}}}static async checkWithdrawal(e,i,l,t){var o,r,n,a,s;try{null===(o=null==t?void 0:t.step)||void 0===o||o.call(t,`Running fraud detection for withdrawal: ${i} ${l}`);null===(r=null==t?void 0:t.step)||void 0===r||r.call(t,"Checking recent withdrawal history");if(await db_1.models.transaction.count({where:{userId:e,type:"FOREX_WITHDRAW",createdAt:{[sequelize_1.Op.gte]:new Date(Date.now()-864e5)}}})>5){null===(n=null==t?void 0:t.fail)||void 0===n||n.call(t,"Too many withdrawal attempts in 24 hours");return{isValid:!1,reason:"Too many withdrawal attempts in 24 hours",riskScore:.9}}null===(a=null==t?void 0:t.success)||void 0===a||a.call(t,"Withdrawal fraud check passed");return{isValid:!0,riskScore:.2}}catch(e){console_1.logger.error("FOREX_FRAUD","Fraud detection error",e);null===(s=null==t?void 0:t.fail)||void 0===s||s.call(t,"Fraud detection check failed");return{isValid:!0,riskScore:.5}}}static async checkInvestment(e,i,l,t){var o,r,n,a,s,d,c;try{null===(o=null==t?void 0:t.step)||void 0===o||o.call(t,`Running fraud detection for investment: ${i} in plan ${l}`);null===(r=null==t?void 0:t.step)||void 0===r||r.call(t,"Checking active investments count");if(await db_1.models.forexInvestment.count({where:{userId:e,status:"ACTIVE"}})>10){null===(n=null==t?void 0:t.fail)||void 0===n||n.call(t,"Too many active investments");return{isValid:!1,reason:"Too many active investments",riskScore:.7}}null===(a=null==t?void 0:t.step)||void 0===a||a.call(t,"Validating investment amount limits");if(i>5e4){null===(s=null==t?void 0:t.fail)||void 0===s||s.call(t,"Investment amount exceeds maximum limit");return{isValid:!1,reason:"Investment amount exceeds maximum limit",riskScore:.8}}null===(d=null==t?void 0:t.success)||void 0===d||d.call(t,"Investment fraud check passed");return{isValid:!0,riskScore:.1}}catch(e){console_1.logger.error("FOREX_FRAUD","Fraud detection error",e);null===(c=null==t?void 0:t.fail)||void 0===c||c.call(t,"Fraud detection check failed");return{isValid:!0,riskScore:.5}}}}exports.ForexFraudDetector=ForexFraudDetector;