"use strict";function getTimeAgo(e){const t=Math.floor((Date.now()-new Date(e).getTime())/1e3);return t<60?"just now":t<3600?`${Math.floor(t/60)}m ago`:t<86400?`${Math.floor(t/3600)}h ago`:t<604800?`${Math.floor(t/86400)}d ago`:`${Math.floor(t/604800)}w ago`}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize");exports.metadata={summary:"Get Forex Landing Page Data",description:"Retrieves optimized data for the forex landing page including stats, featured plans, performance history, and recent completions.",operationId:"getForexLandingData",tags:["Forex","Landing"],requiresAuth:!1,responses:{200:{description:"Forex landing data retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{stats:{type:"object"},featuredPlans:{type:"array"},topPerformingPlan:{type:"object"},performanceHistory:{type:"array"},signals:{type:"array"},recentCompletions:{type:"array"},durationOptions:{type:"object"}}}}}}}};const ACTIVE_STATUS=["ACTIVE"],COMPLETED_STATUS=["COMPLETED"];exports.default=async()=>{const e=new Date;e.setMonth(e.getMonth()-6);const[t,o,n,r,a,i,s,l,u,d,m]=await Promise.all([db_1.models.forexInvestment.count({distinct:!0,col:"userId",where:{status:{[sequelize_1.Op.in]:ACTIVE_STATUS}}}),db_1.models.forexInvestment.sum("amount"),db_1.models.forexInvestment.count({where:{status:{[sequelize_1.Op.in]:COMPLETED_STATUS}}}),db_1.models.forexInvestment.count({where:{status:{[sequelize_1.Op.in]:ACTIVE_STATUS}}}),db_1.models.forexInvestment.count({where:{status:{[sequelize_1.Op.in]:COMPLETED_STATUS},result:"WIN"}}),db_1.models.forexInvestment.count({where:{status:{[sequelize_1.Op.in]:COMPLETED_STATUS}}}),db_1.models.forexInvestment.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("profit")),"totalProfit"],[(0,sequelize_1.fn)("AVG",(0,sequelize_1.literal)("CASE WHEN amount > 0 THEN (profit / amount) * 100 ELSE NULL END")),"avgReturn"]],where:{status:{[sequelize_1.Op.in]:COMPLETED_STATUS}},raw:!0}),db_1.models.forexPlan.findAll({where:{status:!0},include:[{model:db_1.models.forexDuration,as:"durations",through:{attributes:[]}}],order:[["trending","DESC"],["profitPercentage","DESC"]],limit:6}),db_1.models.forexSignal.findAll({where:{status:!0},limit:4}),db_1.models.forexInvestment.findAll({where:{status:{[sequelize_1.Op.in]:COMPLETED_STATUS}},include:[{model:db_1.models.forexPlan,as:"plan",attributes:["name","title"]},{model:db_1.models.forexDuration,as:"duration"}],order:[["updatedAt","DESC"]],limit:10}),db_1.models.forexDuration.findAll({order:[["timeframe","ASC"],["duration","ASC"]]})]),p=await db_1.models.forexInvestment.findAll({attributes:["planId",[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"totalInvested"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.fn)("DISTINCT",(0,sequelize_1.col)("userId"))),"investorCount"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN result = 'WIN' THEN 1 ELSE 0 END")),"winCount"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN status IN ('${COMPLETED_STATUS.join("','")}') THEN 1 ELSE 0 END`)),"completedCount"]],group:["planId"],raw:!0}),f=new Map(p.map(e=>[e.planId,e])),c=o||0,_=parseFloat(null==s?void 0:s.totalProfit)||0,g=parseFloat(null==s?void 0:s.avgReturn)||0,T=i>0?Math.round(a/i*100):0,A=l.map(e=>{const t=e.toJSON(),o=f.get(t.id)||{},n=parseInt(o.completedCount)>0?Math.round(parseInt(o.winCount)/parseInt(o.completedCount)*100):0;return{id:t.id,name:t.name,title:t.title,description:t.description,image:t.image,currency:t.currency,minProfit:t.minProfit,maxProfit:t.maxProfit,minAmount:t.minAmount,maxAmount:t.maxAmount,profitPercentage:t.profitPercentage,trending:t.trending,totalInvested:parseFloat(o.totalInvested)||0,investorCount:parseInt(o.investorCount)||0,winRate:n,durations:(t.durations||[]).map(e=>({duration:e.duration,timeframe:e.timeframe}))}}),S=A.length>0?A.reduce((e,t)=>t.profitPercentage>e.profitPercentage?t:e):null,E=await Promise.all(u.map(async e=>{const t=await db_1.models.forexAccountSignal.count({where:{forexSignalId:e.id}});return{id:e.id,title:e.title,image:e.image,subscriberCount:t}})),v=d.map(e=>{var t,o;const n=e.toJSON(),r=n.amount>0?n.profit/n.amount*100:0;return{planName:(null===(t=n.plan)||void 0===t?void 0:t.title)||(null===(o=n.plan)||void 0===o?void 0:o.name)||"Unknown",result:n.result,profit:n.profit||0,profitPercent:Math.round(10*r)/10,duration:n.duration?`${n.duration.duration} ${n.duration.timeframe.toLowerCase()}${n.duration.duration>1?"s":""}`:"N/A",timeAgo:getTimeAgo(n.updatedAt),anonymizedUser:`Investor #${String(n.userId).slice(-4)}`}}),I=(await db_1.models.forexInvestment.findAll({where:{status:{[sequelize_1.Op.in]:COMPLETED_STATUS},updatedAt:{[sequelize_1.Op.gte]:e}},attributes:[[(0,sequelize_1.fn)("DATE_FORMAT",(0,sequelize_1.col)("updatedAt"),"%Y-%m"),"monthKey"],[(0,sequelize_1.fn)("DATE_FORMAT",(0,sequelize_1.col)("updatedAt"),"%b"),"month"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"totalInvested"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("profit")),"totalProfit"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"completions"]],group:[(0,sequelize_1.literal)("monthKey")],order:[[(0,sequelize_1.literal)("monthKey"),"ASC"]],raw:!0})).map(e=>({month:e.month,totalInvested:parseFloat(e.totalInvested)||0,totalProfit:parseFloat(e.totalProfit)||0,avgReturn:parseFloat(e.totalInvested)>0?Math.round(parseFloat(e.totalProfit)/parseFloat(e.totalInvested)*100*10)/10:0,completions:parseInt(e.completions)})),h={HOUR:1,DAY:2,WEEK:3,MONTH:4},P=m.map(e=>e.toJSON()).sort((e,t)=>{const o=(h[e.timeframe]||5)-(h[t.timeframe]||5);return 0!==o?o:e.duration-t.duration}),q=e=>`${e.duration} ${e.timeframe.toLowerCase()}${e.duration>1?"s":""}`,z={shortest:P.length>0?q(P[0]):"1 hour",longest:P.length>0?q(P[P.length-1]):"12 months",mostPopular:"1 month"};return{stats:{activeInvestors:t,totalInvested:c,averageReturn:Math.round(10*g)/10,totalProfit:_,winRate:T,completedInvestments:n,activeInvestments:r,avgInvestmentAmount:t>0?Math.round(c/t):0,topPlanRoi:(null==S?void 0:S.profitPercentage)||0},featuredPlans:A,topPerformingPlan:S?{...S,badge:"top_performer"}:null,performanceHistory:I,signals:E,recentCompletions:v,durationOptions:z}};