"use strict";function getUtxoNetwork(t){switch(t){case"BTC":return"mainnet"===BTC_NETWORK?bitcoin.networks.bitcoin:bitcoin.networks.testnet;case"LTC":return blockchain_1.litecoinNetwork;case"DOGE":return blockchain_1.dogecoinNetwork;case"DASH":return blockchain_1.dashNetwork;default:throw(0,error_1.createError)({statusCode:400,message:`Unsupported UTXO chain: ${t}`})}}async function createTransactionDetailsForUTXO(t,e,o,r){const a=e.hash,s=e.inputs.map(t=>({prevHash:t.prev_hash,outputIndex:t.output_index,value:(0,blockchain_1.satoshiToStandardUnit)(t.output_value,r),addresses:t.addresses,script:t.script})),n=e.outputs.filter(t=>t.addresses.includes(o)).map(t=>({value:(0,blockchain_1.satoshiToStandardUnit)(t.value,r),addresses:t.addresses,script:t.script})),i=n.reduce((t,e)=>t+e.value,0);return{id:t,address:o,chain:r,hash:a,from:s.map(t=>t.addresses).flat(),to:n.map(t=>t.addresses).flat(),amount:i,inputs:s,outputs:n}}async function recordUTXO(t,e,o,r,a,s){await db_1.models.ecosystemUtxo.create({walletId:t,transactionId:e,index:o,amount:r,script:a,status:s})}function formatTransactionData(t,e){var o;return"haskoin"===e?{hash:t.txid,block_height:null===(o=t.block)||void 0===o?void 0:o.height,inputs:t.inputs,outputs:t.outputs.map(t=>({addresses:[t.addresses],script:t.pkscript,value:t.value,spent:t.spent,spender:t.spender}))}:{hash:t.hash,block_height:t.block_height,inputs:t.inputs,outputs:t.outputs.map(t=>({addresses:t.addresses,script:t.script,value:t.value,spender:t.spent_by}))}}async function getCurrentUtxoFeeRatePerByte(t){try{const e=await(0,UTXOProviderFactory_1.getUTXOProvider)(t);return await e.getFeeRate()}catch(t){console_1.logger.error("UTXO","Get fee rate error",t);return 1}}async function handleUTXOWithdrawal(t){const e="string"==typeof t.metadata?JSON.parse(t.metadata):t.metadata,o=e.chain,r=e.toAddress,a=(0,blockchain_1.standardUnitToSatoshi)(t.amount,o),s=(0,blockchain_1.standardUnitToSatoshi)(t.fee,o),n=await db_1.models.wallet.findByPk(t.walletId);if(!n)throw(0,error_1.createError)({statusCode:404,message:"Wallet not found"});const i=await calculateMinimumWithdrawal(n.id,o,t.amount);if(i.isEconomical)console_1.logger.info("UTXO",`Withdrawal validation passed: requires ${i.utxoCount} UTXOs`);else{console_1.logger.warn("UTXO",`Withdrawal validation failed: ${JSON.stringify(i)}`);const e=await shouldAutoConsolidateUTXOs(n.id,o);if(!e.shouldConsolidate)throw(0,error_1.createError)({statusCode:400,message:i.reason});{console_1.logger.info("UTXO",`Auto consolidation triggered for wallet ${n.id}, chain ${o}: ${e.reason}`);const r=await consolidateUTXOs(n.id,o,10);if(!r.success){console_1.logger.warn("UTXO",`Auto consolidation failed: ${r.message}`);throw(0,error_1.createError)({statusCode:400,message:`${i.reason}. Consolidation attempt failed: ${r.message}`})}{console_1.logger.success("UTXO",`Auto consolidation success: ${r.message}`);console_1.logger.info("UTXO","Waiting for consolidation transaction to confirm...");const e=await(0,exports.verifyUTXOTransaction)(o,r.txid);if(!e.confirmed)throw(0,error_1.createError)({statusCode:500,message:`Consolidation transaction ${r.txid} failed to confirm within 30 minutes. Please try withdrawal again later.`});console_1.logger.success("UTXO",`Auto consolidation transaction confirmed. Fee: ${e.fee} ${o}`);const a=await calculateMinimumWithdrawal(n.id,o,t.amount);if(!a.isEconomical)throw(0,error_1.createError)({statusCode:400,message:`Even after consolidation: ${a.reason}`});console_1.logger.info("UTXO",`After consolidation: withdrawal now requires ${a.utxoCount} UTXOs`)}}}if(!await(0,wallet_1.getMasterWalletByChain)(o))throw(0,error_1.createError)({statusCode:404,message:`Master wallet not found for ${o}`});const c=getUtxoNetwork(o);if(!c)throw(0,error_1.createError)({statusCode:400,message:`Unsupported UTXO chain: ${o}`});const d=await getCurrentUtxoFeeRatePerByte(o);if(!d)throw(0,error_1.createError)({statusCode:500,message:"Failed to fetch current fee rate"});const l=getDustThreshold(o);if(a<l)throw(0,error_1.createError)({statusCode:400,message:`Amount to send (${a} satoshis) is below the dust threshold of ${l} satoshis.`});let u=0;for(;u<3;){const e=await db_1.sequelize.transaction({isolationLevel:sequelize_1.Transaction.ISOLATION_LEVELS.READ_COMMITTED});try{const i=await db_1.models.ecosystemUtxo.findAll({where:{status:!1,walletId:n.id},order:[["amount","DESC"]],lock:sequelize_1.Transaction.LOCK.UPDATE,transaction:e});if(0===i.length){await e.rollback();throw(0,error_1.createError)({statusCode:400,message:"No UTXOs available for withdrawal"})}try{const{success:u,txid:h}=await createAndBroadcastTransaction(i,n,t,a,s,d,l,o,c,r,e);if(u){await e.commit();await db_1.models.transaction.update({status:"COMPLETED",description:`Withdrawal of ${t.amount} ${n.currency} to ${r}`,trxId:h},{where:{id:t.id}});return{success:!0,txid:h}}await e.rollback();throw(0,error_1.createError)({statusCode:500,message:"Transaction failed without specific error"})}catch(a){await e.rollback();if(a instanceof TransactionBroadcastedError){await db_1.models.transaction.update({status:"COMPLETED",description:`Withdrawal of ${t.amount} ${n.currency} to ${r}`,trxId:a.txid},{where:{id:t.id}});console_1.logger.error("UTXO","Post-broadcast error",a);return{success:!0,txid:a.txid}}if(a.message.includes("already been spent")||a.message.includes("Missing inputs")||a.message.includes("bad-txns-inputs-spent")){await markSpentUtxosFromError(a,o,n.id);u++;if(u>=3)throw(0,error_1.createError)({statusCode:500,message:"Failed to broadcast transaction after 3 attempts due to spent UTXOs."});continue}throw(0,error_1.createError)({statusCode:500,message:`Failed to broadcast transaction: ${a.message}`})}}catch(t){if("No UTXOs available for withdrawal"===t.message)throw t;throw t}}}async function createAndBroadcastTransaction(t,e,o,r,a,s,n,i,c,d,l){const u=new bitcoin.Psbt({network:c});let h=0;const f=[];for(const o of t){const a=await db_1.models.walletData.findOne({where:{walletId:o.walletId}});if(!a)continue;const g=JSON.parse((0,encrypt_1.decrypt)(a.data));if(!g.privateKey)continue;const p=await(0,exports.fetchRawUtxoTransaction)(o.transactionId,i);u.addInput({hash:o.transactionId,index:o.index,nonWitnessUtxo:Buffer.from(p,"hex")});const T=(0,blockchain_1.standardUnitToSatoshi)(o.amount,i);h+=T;const w=ECPair.fromWIF(g.privateKey,c);f.push({index:u.inputCount-1,keyPair:w});const m=180*u.inputCount+34*2+10;let U=Math.ceil(m*s),_=r+U,O=h-_;console_1.logger.debug("UTXO",`Input #${u.inputCount}: utxo=${T}, total=${h}, amount=${r}, fee=${U}, required=${_}, change=${O}`);if(O>0&&O<n){console_1.logger.debug("UTXO",`Change is dust (${O} < ${n}), adding to fee`);U+=O;_+=O;O=0}_=r+U;O=h-_;console_1.logger.debug("UTXO",`After dust adjustment: required=${_}, change=${O}, hasEnough=${h>=_}`);if(h>=_){const o=[];o.push({address:d,value:BigInt(r)});O>0&&o.push({address:getChangeAddress(e,i),value:BigInt(O)});o.forEach(t=>{u.addOutput(t)});f.forEach(({index:t,keyPair:e})=>{u.signInput(t,e)});u.finalizeAllInputs();const a=u.extractTransaction().toHex(),s=await(0,exports.broadcastRawUtxoTransaction)(a,i);if(!s.success)throw(0,error_1.createError)({statusCode:500,message:`Failed to broadcast transaction: ${s.error}`});if(!s.success)throw(0,error_1.createError)({statusCode:500,message:`Failed to broadcast transaction: ${s.error}`});{const o=s.txid;try{O>0&&await recordChangeUtxo(o,O,e,i,l);await markUsedUtxos(u,t,l);return{success:!0,txid:o}}catch(t){console_1.logger.error("UTXO","Post-broadcast error",t);return{success:!0,txid:o}}}}}throw(0,error_1.createError)({statusCode:400,message:"Insufficient funds to cover the amount and transaction fee"})}function getChangeAddress(t,e){var o;const r="string"==typeof t.address?JSON.parse(t.address):t.address;if(!r)throw(0,error_1.createError)({statusCode:404,message:"Wallet addresses not found"});if(!(null==r?void 0:r[e]))throw(0,error_1.createError)({statusCode:404,message:"Wallet address chain not found"});if(!(null===(o=null==r?void 0:r[e])||void 0===o?void 0:o.address))throw(0,error_1.createError)({statusCode:404,message:"Wallet address not found"});return r[e].address}async function markUsedUtxos(t,e,o){if(t&&e)for(let r=0;r<t.inputCount;r++){const a=t.txInputs[r];if(!a||!a.hash||void 0===a.index){console_1.logger.error("UTXO",`Input at index ${r} is undefined or missing properties`);continue}const s=Buffer.from(a.hash).reverse().toString("hex"),n=a.index,i=e.find(t=>t.transactionId===s&&t.index===n);if(i){const t={where:{id:i.id}};o&&(t.transaction=o);await db_1.models.ecosystemUtxo.update({status:!0},t)}else console_1.logger.error("UTXO",`UTXO not found for transaction ${s} index ${n}`)}else console_1.logger.error("UTXO","Cannot mark used UTXOs: psbt or utxos is undefined")}async function recordChangeUtxo(t,e,o,r,a){if(!t){console_1.logger.error("UTXO","Cannot record change UTXO: txid is undefined");return}const s=await(0,exports.fetchUtxoTransaction)(t,r);if(!s||!s.outputs){console_1.logger.error("UTXO","Change transaction data is undefined or invalid");return}const n=getChangeAddress(o,r),i=s.outputs.find(t=>t.addresses&&t.addresses.includes(n));if(i){const n=s.outputs.indexOf(i),c=i.script,d=(0,blockchain_1.satoshiToStandardUnit)(e,r),l={walletId:o.id,transactionId:t,index:n,amount:d,script:c,status:!1};a?await db_1.models.ecosystemUtxo.create(l,{transaction:a}):await db_1.models.ecosystemUtxo.create(l)}else console_1.logger.error("UTXO","Change output not found in transaction data")}async function markSpentUtxosFromError(t,e,o){const r=parseSpentUtxosFromError(t.message);if(0===r.length)await markSpentUtxos(e,o);else for(const t of r){const e=await db_1.models.ecosystemUtxo.findOne({where:{transactionId:t.transactionId}});if(e){await db_1.models.ecosystemUtxo.update({status:!0},{where:{id:e.id}});console_1.logger.info("UTXO",`Marked UTXO as spent: txId=${t.transactionId}, index=${t.index}`)}else console_1.logger.error("UTXO",`UTXO not found in database for transaction ${t.transactionId} index ${t.index}`)}}function parseSpentUtxosFromError(t){const e=[],o=/Transaction ([a-f0-9]{64}) referenced by input (\d+) of [a-f0-9]{64} has already been spent/gi;let r;for(;null!==(r=o.exec(t));){const t=r[1],o=parseInt(r[2]);e.push({transactionId:t,index:o})}return e}async function markSpentUtxos(t,e){const o=await db_1.models.ecosystemUtxo.findAll({where:{status:!1,walletId:e}});for(const e of o)try{const o=(await(0,exports.fetchUtxoTransaction)(e.transactionId,t)).outputs[e.index];(o.spent||o.spender)&&await db_1.models.ecosystemUtxo.update({status:!0},{where:{id:e.id}})}catch(t){}}async function shouldAutoConsolidateUTXOs(t,e){const o=await db_1.models.ecosystemUtxo.findAll({where:{status:!1,walletId:t},order:[["amount","ASC"]]});if(o.length<2)return{shouldConsolidate:!1,reason:"Not enough UTXOs to warrant consolidation (need at least 2)"};const r=await getCurrentUtxoFeeRatePerByte(e);if(!r)return{shouldConsolidate:!1,reason:"Cannot fetch fee rate"};const a=o.reduce((t,o)=>t+(0,blockchain_1.standardUnitToSatoshi)(o.amount,e),0)/o.length,s=180*r;return a<3*s?{shouldConsolidate:!0,reason:`${o.length} UTXOs with avg size ${(0,blockchain_1.satoshiToStandardUnit)(a,e)} ${e} (cost to spend: ${(0,blockchain_1.satoshiToStandardUnit)(s,e)} ${e}). Consolidation will reduce future fees.`}:o.length>=10?{shouldConsolidate:!0,reason:`${o.length} UTXOs detected. Consolidation will improve wallet efficiency.`}:{shouldConsolidate:!1,reason:"UTXOs are large enough, no consolidation needed"}}async function calculateMinimumWithdrawal(t,e,o){const r=(0,blockchain_1.standardUnitToSatoshi)(o,e),a=await getCurrentUtxoFeeRatePerByte(e);if(!a)return{isEconomical:!1,minAmount:0,reason:"Failed to fetch current fee rate",utxoCount:0};const s=await db_1.models.ecosystemUtxo.findAll({where:{status:!1,walletId:t},order:[["amount","DESC"]]});if(0===s.length)return{isEconomical:!1,minAmount:0,reason:"No UTXOs available",utxoCount:0};const n=getDustThreshold(e);let i=0,c=0;for(const t of s){c++;i+=(0,blockchain_1.standardUnitToSatoshi)(t.amount,e);const s=180*c+68+10,d=Math.ceil(s*a),l=r+d;if(i>=l){const t=i-l;if(!(t>0&&t<n))return{isEconomical:!0,minAmount:o,reason:"Withdrawal is economical",utxoCount:c};if(i>=r+d+t)return{isEconomical:!0,minAmount:o,reason:"Withdrawal is economical",utxoCount:c}}}const d=180*s.length+68+10,l=Math.ceil(d*a),u=i-l;return u<=0?{isEconomical:!1,minAmount:0,reason:`UTXOs too small for any withdrawal. Total value: ${(0,blockchain_1.satoshiToStandardUnit)(i,e)} ${e}, estimated fee: ${(0,blockchain_1.satoshiToStandardUnit)(l,e)} ${e}. Consider consolidating UTXOs when fees are lower.`,utxoCount:s.length}:{isEconomical:!1,minAmount:(0,blockchain_1.satoshiToStandardUnit)(u,e),reason:`Insufficient funds. Maximum possible withdrawal: ${(0,blockchain_1.satoshiToStandardUnit)(u,e)} ${e}. Consider consolidating UTXOs to reduce fees.`,utxoCount:s.length}}async function consolidateUTXOs(t,e,o=2){const r=await getCurrentUtxoFeeRatePerByte(e);if(!r)return{success:!1,message:"Failed to fetch current fee rate"};if(r>o)return{success:!1,message:`Current fee rate (${r} sat/byte) is too high for consolidation. Waiting for fees <= ${o} sat/byte.`};const a=await db_1.models.wallet.findByPk(t);if(!a)return{success:!1,message:"Wallet not found"};if(!await(0,wallet_1.getMasterWalletByChain)(e))return{success:!1,message:`Master wallet not found for ${e}`};const s=getUtxoNetwork(e);if(!s)return{success:!1,message:`Unsupported UTXO chain: ${e}`};const n=await db_1.sequelize.transaction({isolationLevel:sequelize_1.Transaction.ISOLATION_LEVELS.READ_COMMITTED});try{const o=await db_1.models.ecosystemUtxo.findAll({where:{status:!1,walletId:t},order:[["amount","ASC"]],lock:sequelize_1.Transaction.LOCK.UPDATE,transaction:n});console_1.logger.info("UTXO",`Consolidation: Found ${o.length} available UTXOs for wallet ${t}`);if(o.length<2){await n.rollback();return{success:!1,message:`Not enough UTXOs to consolidate (need at least 2, found ${o.length})`}}const i=180*r,c=getDustThreshold(e),d=o.filter(t=>{const o=(0,blockchain_1.standardUnitToSatoshi)(t.amount,e);return o<5*i||o<2*c});if(d.length<2){await n.rollback();return{success:!1,message:`No small UTXOs to consolidate. All ${o.length} UTXOs are already efficiently sized.`}}const l=d.slice(0,Math.min(50,d.length));console_1.logger.info("UTXO",`Consolidation: Will consolidate ${l.length} small UTXOs (out of ${o.length} total). Keeping ${o.length-l.length} larger UTXOs separate.`);const u=new bitcoin.Psbt({network:s});let h=0;const f=[];for(const t of l){const o=await db_1.models.walletData.findOne({where:{walletId:t.walletId}});if(!o)continue;const r=JSON.parse((0,encrypt_1.decrypt)(o.data));if(!r.privateKey)continue;const a=await(0,exports.fetchRawUtxoTransaction)(t.transactionId,e);u.addInput({hash:t.transactionId,index:t.index,nonWitnessUtxo:Buffer.from(a,"hex")});h+=(0,blockchain_1.standardUnitToSatoshi)(t.amount,e);const n=ECPair.fromWIF(r.privateKey,s);f.push({index:u.inputCount-1,keyPair:n})}const g=u.inputCount,p=180*g+34*1+10,T=Math.ceil(p*r),w=h-T,m=getDustThreshold(e);if(w<m){await n.rollback();return{success:!1,message:`Consolidation would result in dust output (${w} < ${m} satoshis)`}}const U=getChangeAddress(a,e);u.addOutput({address:U,value:BigInt(w)});f.forEach(({index:t,keyPair:e})=>{u.signInput(t,e)});u.finalizeAllInputs();const _=u.extractTransaction().toHex(),O=await(0,exports.broadcastRawUtxoTransaction)(_,e);if(!O.success){await n.rollback();return{success:!1,message:`Failed to broadcast consolidation: ${O.error}`}}const x=O.txid;if(!x){await n.rollback();return{success:!1,message:"Failed to get transaction ID from broadcast result"}}await markUsedUtxos(u,l,n);await recordChangeUtxo(x,w,a,e,n);await n.commit();console_1.logger.success("UTXO",`Consolidation: Successfully consolidated ${g} UTXOs into 1. TxID: ${x}`);return{success:!0,txid:x,message:`Successfully consolidated ${g} UTXOs (${(0,blockchain_1.satoshiToStandardUnit)(h,e)} ${e}) into 1 UTXO (${(0,blockchain_1.satoshiToStandardUnit)(w,e)} ${e}). Fee: ${(0,blockchain_1.satoshiToStandardUnit)(T,e)} ${e}`}}catch(t){await n.rollback();console_1.logger.error("UTXO","Consolidate UTXOs error",t);return{success:!1,message:`Consolidation failed: ${t.message}`}}}function getDustThreshold(t){switch(t){case"BTC":case"DASH":return 546;case"LTC":return 1e3;case"DOGE":return 1e8;default:throw(0,error_1.createError)({statusCode:400,message:`Unsupported UTXO chain: ${t}`})}}var __createBinding=this&&this.__createBinding||(Object.create?function(t,e,o,r){void 0===r&&(r=o);var a=Object.getOwnPropertyDescriptor(e,o);a&&!("get"in a?!e.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return e[o]}});Object.defineProperty(t,r,a)}:function(t,e,o,r){void 0===r&&(r=o);t[r]=e[o]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(t,e){Object.defineProperty(t,"default",{enumerable:!0,value:e})}:function(t,e){t.default=e}),__importStar=this&&this.__importStar||function(){var t=function(e){t=Object.getOwnPropertyNames||function(t){var e=[];for(var o in t)Object.prototype.hasOwnProperty.call(t,o)&&(e[e.length]=o);return e};return t(e)};return function(e){if(e&&e.__esModule)return e;var o={};if(null!=e)for(var r=t(e),a=0;a<r.length;a++)"default"!==r[a]&&__createBinding(o,e,r[a]);__setModuleDefault(o,e);return o}}(),__importDefault=this&&this.__importDefault||function(t){return t&&t.__esModule?t:{default:t}};Object.defineProperty(exports,"__esModule",{value:!0});exports.calculateUTXOFee=exports.broadcastRawUtxoTransaction=exports.verifyUTXOTransaction=exports.fetchUtxoTransaction=exports.fetchRawUtxoTransaction=exports.fetchUTXOWalletBalance=exports.fetchUTXOTransactions=exports.createUTXOWallet=exports.cancelWatchAddress=exports.watchAddressBlockCypher=void 0;exports.createTransactionDetailsForUTXO=createTransactionDetailsForUTXO;exports.recordUTXO=recordUTXO;exports.getCurrentUtxoFeeRatePerByte=getCurrentUtxoFeeRatePerByte;exports.handleUTXOWithdrawal=handleUTXOWithdrawal;exports.calculateMinimumWithdrawal=calculateMinimumWithdrawal;exports.consolidateUTXOs=consolidateUTXOs;const assert=__importStar(require("assert")),bitcoin=__importStar(require("bitcoinjs-lib")),ecpair_1=__importDefault(require("ecpair")),ecc=__importStar(require("tiny-secp256k1")),ws_1=__importDefault(require("ws")),blockchain_1=require("./blockchain"),db_1=require("@b/db"),sequelize_1=require("sequelize"),encrypt_1=require("../../../../utils/encrypt"),wallet_1=require("./wallet"),UTXOProviderFactory_1=require("./utxo/providers/UTXOProviderFactory"),console_1=require("@b/utils/console"),error_1=require("@b/utils/error");class TransactionBroadcastedError extends Error{constructor(t,e){super(t);this.name="TransactionBroadcastedError";this.txid=e}}const BTC_NETWORK=process.env.BTC_NETWORK||"mainnet",BLOCKCYPHER_TOKEN=process.env.BLOCKCYPHER_TOKEN,BTC_NODE=process.env.BTC_NODE||"blockcypher",LTC_NODE=process.env.LTC_NODE||"blockcypher",DOGE_NODE=process.env.DOGE_NODE||"blockcypher",DASH_NODE=process.env.DASH_NODE||"blockcypher",wsConnections=new Map;bitcoin.initEccLib(ecc);const ECPair=(0,ecpair_1.default)(ecc),getUtxoProvider=t=>{switch(t){case"BTC":return BTC_NODE;case"LTC":return LTC_NODE;case"DOGE":return DOGE_NODE;case"DASH":return DASH_NODE;default:return"blockcypher"}},providers={haskoin:{BTC:"https://api.haskoin.com/btc"+("mainnet"===BTC_NETWORK?"":"test")},blockcypher:{BTC:"https://api.blockcypher.com/v1/btc/"+("mainnet"===BTC_NETWORK?"main":"test3"),LTC:"https://api.blockcypher.com/v1/ltc/main",DASH:"https://api.blockcypher.com/v1/dash/main",DOGE:"https://api.blockcypher.com/v1/doge/main"}},watchAddressBlockCypher=(t,e,o)=>{const r="BTC"===t?"mainnet"===BTC_NETWORK?"main":"test3":"main",a=new ws_1.default(`wss://socket.blockcypher.com/v1/${t.toLowerCase()}/${r}?token=${BLOCKCYPHER_TOKEN}`);a.on("open",function(){a.send(JSON.stringify({event:"unconfirmed-tx",address:e}))});a.on("message",function(r){const a=r.toString(),s=JSON.parse(a);if(s&&s.hash){o(s);(0,exports.cancelWatchAddress)(t,e)}});a.on("close",function(){console_1.logger.info("UTXO",`WebSocket disconnected from ${t} address: ${e}`)});a.on("error",function(t){console_1.logger.error("UTXO","Watch address error",t)});const s=`${t}_${e.toLowerCase()}`;wsConnections.set(s,a)};exports.watchAddressBlockCypher=watchAddressBlockCypher;const cancelWatchAddress=(t,e)=>{const o=`${t}_${e.toLowerCase()}`,r=wsConnections.get(o);if(r)try{r.close();console_1.logger.info("UTXO",`WebSocket for ${t} address ${e} has been successfully closed.`)}catch(t){console_1.logger.error("UTXO","Cancel watch address error",t)}finally{wsConnections.delete(o)}else console_1.logger.info("UTXO",`No active WebSocket found for ${t} address ${e}.`)};exports.cancelWatchAddress=cancelWatchAddress;const constructApiUrl=(t,e,o="",r="",a="")=>{""===a&&(a=getUtxoProvider(t));if("haskoin"===a){const a=providers.haskoin[t];switch(e){case"fetchBalance":return`${a}/address/${o}/balance`;case"fetchTransactions":return`${a}/address/${o}/transactions/full`;case"fetchTransaction":return`${a}/transaction/${r}`;case"fetchRawTransaction":return`${a}/transaction/${r}/raw`;case"broadcastTransaction":return`${a}/transactions/full`;default:throw(0,error_1.createError)({statusCode:400,message:`Unsupported operation for Haskoin: ${e}`})}}{const a=providers.blockcypher[t];switch(e){case"fetchBalance":return`${a}/addrs/${o}/balance`;case"fetchTransactions":return`${a}/addrs/${o}`;case"fetchTransaction":return`${a}/txs/${r}`;case"fetchRawTransaction":return`${a}/txs/${r}?includeHex=true`;case"broadcastTransaction":return`${a}/txs/push`;default:throw(0,error_1.createError)({statusCode:400,message:`Unsupported operation for BlockCypher: ${e}`})}}},fetchFromApi=async(t,e={})=>{try{const o=await fetch(t,e),r=await o.json();if(!r||"object"!=typeof r)throw(0,error_1.createError)({statusCode:500,message:"Invalid response structure"});return r}catch(t){console_1.logger.error("UTXO","Fetch from API error",t);throw t}},createUTXOWallet=t=>{const e=getUtxoNetwork(t);if(!e)throw(0,error_1.createError)({statusCode:400,message:`Unsupported UTXO chain: ${t}`});const o=ECPair.makeRandom({network:e}),{address:r}=bitcoin.payments.p2pkh({pubkey:o.publicKey,network:e});"BTC"===t&&e===bitcoin.networks.testnet&&assert.strictEqual(r.startsWith("m")||r.startsWith("n"),!0);return{address:r,data:{privateKey:o.toWIF()}}};exports.createUTXOWallet=createUTXOWallet;const fetchUTXOTransactions=async(t,e)=>{try{const o=await(0,UTXOProviderFactory_1.getUTXOProvider)(t);console_1.logger.info("UTXO",`Using ${o.getName()} for fetching transactions`);return await o.fetchTransactions(e)}catch(t){console_1.logger.error("UTXO","Fetch transactions error",t);return[]}};exports.fetchUTXOTransactions=fetchUTXOTransactions;const fetchUTXOWalletBalance=async(t,e)=>{try{const o=await(0,UTXOProviderFactory_1.getUTXOProvider)(t),r=await o.getBalance(e);return(0,blockchain_1.satoshiToStandardUnit)(r,t)}catch(t){console_1.logger.error("UTXO","Fetch wallet balance error",t);return 0}};exports.fetchUTXOWalletBalance=fetchUTXOWalletBalance;const fetchRawUtxoTransaction=async(t,e)=>{try{const o=await(0,UTXOProviderFactory_1.getUTXOProvider)(e);return await o.fetchRawTransaction(t)}catch(t){console_1.logger.error("UTXO","Fetch raw transaction error",t);throw t}};exports.fetchRawUtxoTransaction=fetchRawUtxoTransaction;const fetchUtxoTransaction=async(t,e)=>{try{const o=await(0,UTXOProviderFactory_1.getUTXOProvider)(e);return await o.fetchTransaction(t)}catch(t){console_1.logger.error("UTXO","Fetch transaction error",t);return null}};exports.fetchUtxoTransaction=fetchUtxoTransaction;const verifyUTXOTransaction=async(t,e)=>{const o=constructApiUrl(t,"fetchTransaction","",e),r=Date.now(),a=getUtxoProvider(t);for(;Date.now()-r<18e5;){try{const e=await fetchFromApi(o);let r=!1,s=0;if("haskoin"===a){r=!!e.block;s=e.fee}else{r=e.confirmations>=1;s=e.fee?(0,blockchain_1.satoshiToStandardUnit)(e.fee,t):0}if(r)return{confirmed:r,fee:s}}catch(t){console_1.logger.error("UTXO","Verify transaction error",t)}await new Promise(t=>setTimeout(t,3e4))}return{confirmed:!1,fee:0}};exports.verifyUTXOTransaction=verifyUTXOTransaction;const broadcastRawUtxoTransaction=async(t,e)=>{if(!t){console_1.logger.error("UTXO","Error broadcasting transaction: No transaction data provided");return{success:!1,error:"No transaction data provided",txid:null}}try{const o=await(0,UTXOProviderFactory_1.getUTXOProvider)(e);console_1.logger.info("UTXO",`Broadcasting transaction using ${o.getName()}`);return await o.broadcastTransaction(t)}catch(t){console_1.logger.error("UTXO","Broadcast transaction error",t);return{success:!1,error:t.message,txid:null}}};exports.broadcastRawUtxoTransaction=broadcastRawUtxoTransaction;const calculateUTXOFee=async(t,e,o)=>{const r=await getCurrentUtxoFeeRatePerByte(o);if(!r)throw(0,error_1.createError)({statusCode:500,message:"Failed to fetch current fee rate"});const a=[],s=[];let n=0;const i=await db_1.models.ecosystemUtxo.findAll({where:{status:!1},order:[["amount","DESC"]]});if(0===i.length)throw(0,error_1.createError)({statusCode:400,message:"No UTXOs available for withdrawal"});for(const t of i){a.push(t);n+=t.amount;if(n>=e)break}s.push({toAddress:t,amount:e});return(180*a.length+34*s.length+10)*r};exports.calculateUTXOFee=calculateUTXOFee;