"use strict";async function getBestPriceFromOrderBook(e,r){const{asks:t,bids:a}=await(0,queries_1.getOrderBook)(e);return"BUY"===r.toUpperCase()?t&&0!==t.length?t[0][0]:null:a&&0!==a.length?a[0][0]:null}var __createBinding=this&&this.__createBinding||(Object.create?function(e,r,t,a){void 0===a&&(a=t);var o=Object.getOwnPropertyDescriptor(r,t);o&&!("get"in o?!r.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return r[t]}});Object.defineProperty(e,a,o)}:function(e,r,t,a){void 0===a&&(a=t);e[a]=r[t]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,r){Object.defineProperty(e,"default",{enumerable:!0,value:r})}:function(e,r){e.default=r}),__importStar=this&&this.__importStar||function(){var e=function(r){e=Object.getOwnPropertyNames||function(e){var r=[];for(var t in e)Object.prototype.hasOwnProperty.call(e,t)&&(r[r.length]=t);return r};return e(r)};return function(r){if(r&&r.__esModule)return r;var t={};if(null!=r)for(var a=e(r),o=0;o<a.length;o++)"default"!==a[o]&&__createBinding(t,r,a[o]);__setModuleDefault(t,r);return t}}();Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),wallet_1=require("@b/api/(ext)/ecosystem/utils/wallet"),queries_1=require("@b/api/(ext)/ecosystem/utils/scylla/queries"),blockchain_1=require("@b/api/(ext)/ecosystem/utils/blockchain"),query_1=require("@b/utils/query"),db_1=require("@b/db"),ws_1=require("@b/api/(ext)/ecosystem/utils/ws");exports.metadata={summary:"Creates a new trading order",description:"Submits a new trading order for the logged-in user.",operationId:"createOrder",tags:["Trading","Orders"],logModule:"ECO_ORDER",logTitle:"Create trading order",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{currency:{type:"string",description:"Currency symbol (e.g., BTC)"},pair:{type:"string",description:"Pair symbol (e.g., USDT)"},type:{type:"string",description:"Order type, limit or market"},side:{type:"string",description:"Order side, buy or sell"},amount:{type:"number",description:"Amount of the order"},price:{type:"number",description:"Price of the order (required if limit)"}},required:["currency","pair","type","side","amount"]}}}},responses:(0,query_1.createRecordResponses)("Order"),requiresAuth:!0};exports.default=async e=>{var r,t,a,o,i,s,n,l,d,u,c,m,p,f,g,_,h,b,v,w;const{body:y,user:C,ctx:k}=e;if(!(null==C?void 0:C.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{currency:B,pair:$,amount:O,price:E,type:U,side:q}=y;null==k||k.step("Validating order request");if(!O||Number(O)<=0){null==k||k.fail("Invalid amount");throw(0,error_1.createError)({statusCode:422,message:"Amount must be greater than zero."})}if(!U){null==k||k.fail("Order type missing");throw(0,error_1.createError)({statusCode:422,message:"Order type (limit/market) is required."})}if(!B||!$){null==k||k.fail("Invalid currency or pair");throw(0,error_1.createError)({statusCode:422,message:"Invalid currency/pair symbol."})}const I=`${B}/${$}`;try{null==k||k.step("Fetching market configuration");const e=await db_1.models.ecosystemMarket.findOne({where:{currency:B,pair:$}});if(!e||!e.metadata){null==k||k.fail("Market not found");throw(0,error_1.createError)({statusCode:422,message:"Market data not found or incomplete."})}null==k||k.step("Validating market metadata");if(!e.metadata.precision||!e.metadata.precision.amount||!e.metadata.precision.price){null==k||k.fail("Market metadata incomplete");throw(0,error_1.createError)({statusCode:422,message:"Market metadata missing precision details."})}if(!e.metadata.maker||!e.metadata.taker){null==k||k.fail("Market fee rates missing");throw(0,error_1.createError)({statusCode:422,message:"Market metadata missing fee rates."})}const y=Number((null===(a=null===(t=null===(r=e.metadata)||void 0===r?void 0:r.limits)||void 0===t?void 0:t.amount)||void 0===a?void 0:a.min)||0),N=Number((null===(s=null===(i=null===(o=e.metadata)||void 0===o?void 0:o.limits)||void 0===i?void 0:i.amount)||void 0===s?void 0:s.max)||0),S=Number((null===(d=null===(l=null===(n=e.metadata)||void 0===n?void 0:n.limits)||void 0===l?void 0:l.price)||void 0===d?void 0:d.min)||0),x=Number((null===(m=null===(c=null===(u=e.metadata)||void 0===u?void 0:u.limits)||void 0===c?void 0:c.price)||void 0===m?void 0:m.max)||0),F=Number((null===(g=null===(f=null===(p=e.metadata)||void 0===p?void 0:p.limits)||void 0===f?void 0:f.cost)||void 0===g?void 0:g.min)||0),L=Number((null===(b=null===(h=null===(_=e.metadata)||void 0===_?void 0:_.limits)||void 0===h?void 0:h.cost)||void 0===b?void 0:b.max)||0);if("SELL"===q.toUpperCase()&&O<y)throw(0,error_1.createError)({statusCode:422,message:`Amount is too low, you need at least ${y} ${B}`});if("BUY"===q.toUpperCase()&&O<y)throw(0,error_1.createError)({statusCode:422,message:`Amount is too low, minimum is ${y} ${B}`});if("SELL"===q.toUpperCase()&&N>0&&O>N)throw(0,error_1.createError)({statusCode:422,message:`Amount is too high, maximum is ${N} ${B}`});if("limit"===U.toLowerCase()&&(!E||E<=0))throw(0,error_1.createError)({statusCode:422,message:"Price must be greater than zero for limit orders."});let Y=E;if("market"===U.toLowerCase()){null==k||k.step("Determining market price from order book");const e=await getBestPriceFromOrderBook(I,q);if(!e){null==k||k.fail("No market price available");throw(0,error_1.createError)({statusCode:422,message:"Cannot execute market order: no price available."})}Y=e}if(Y&&Y<S)throw(0,error_1.createError)({statusCode:422,message:`Price is too low, you need at least ${S} ${$}`});if(x>0&&Y&&Y>x)throw(0,error_1.createError)({statusCode:422,message:`Price is too high, maximum is ${x} ${$}`});const P=Number("BUY"===q.toUpperCase()?e.metadata.precision.amount:e.metadata.precision.price)||8;null==k||k.step("Determining maker/taker fee structure");let M=!1;if("market"===U.toLowerCase())M=!0;else{const{asks:e,bids:r}=await(0,queries_1.getOrderBook)(I);"BUY"===q.toUpperCase()?e&&e.length>0&&Y>=e[0][0]&&(M=!0):r&&r.length>0&&Y<=r[0][0]&&(M=!0)}const j=Number(M?e.metadata.taker:e.metadata.maker);if(isNaN(j)||j<0){null==k||k.fail("Invalid fee rate");throw(0,error_1.createError)({statusCode:422,message:"Invalid fee rate from market metadata."})}if(!Y||isNaN(Y)){null==k||k.fail("Invalid price");throw(0,error_1.createError)({statusCode:422,message:"No valid price determined for the order."})}null==k||k.step("Calculating order cost and fees");const A=parseFloat((O*Y*j/100).toFixed(P)),D="BUY"===q.toUpperCase()?O*Y+A:O,R=parseFloat(D.toFixed(P));if("BUY"===q.toUpperCase()&&(isNaN(R)||R<=0))throw(0,error_1.createError)({statusCode:422,message:"Calculated cost is invalid. Check your price and amount."});if("BUY"===q.toUpperCase()&&R<F)throw(0,error_1.createError)({statusCode:422,message:`Cost is too low, you need at least ${F} ${$}`});if("BUY"===q.toUpperCase()&&L>0&&R>L)throw(0,error_1.createError)({statusCode:422,message:`Cost is too high, maximum is ${L} ${$}`});null==k||k.step("Retrieving user wallets");const[T,W]=await Promise.all([(0,wallet_1.getWalletByUserIdAndCurrency)(C.id,B),(0,wallet_1.getWalletByUserIdAndCurrency)(C.id,$)]);null==k||k.step("Verifying wallet balance");if("SELL"===q.toUpperCase()){const e=parseFloat(T.balance.toString())-parseFloat((null===(v=T.inOrder)||void 0===v?void 0:v.toString())||"0");if(!T||e<O){null==k||k.fail(`Insufficient ${B} balance`);throw(0,error_1.createError)({statusCode:400,message:`Insufficient balance. You need ${O} ${B}`})}}else{const e=parseFloat(W.balance.toString())-parseFloat((null===(w=W.inOrder)||void 0===w?void 0:w.toString())||"0");if(!W||e<R){null==k||k.fail(`Insufficient ${$} balance`);throw(0,error_1.createError)({statusCode:400,message:`Insufficient balance. You need ${R} ${$}`})}}null==k||k.step("Checking for self-matching orders");const z=await(0,queries_1.getOrders)(C.id,I,!0);if("SELL"===q.toUpperCase()){const e=z.find(e=>"BUY"===e.side&&e.price>=Y);if(e){null==k||k.fail("Self-matching order detected");throw(0,error_1.createError)({statusCode:400,message:`You already have a BUY order at ${e.price} or higher, cannot place SELL at ${Y} or lower.`})}}if("BUY"===q.toUpperCase()){const e=z.find(e=>"SELL"===e.side&&e.price<=Y);if(e){null==k||k.fail("Self-matching order detected");throw(0,error_1.createError)({statusCode:400,message:`You already have a SELL order at ${e.price} or lower, cannot place BUY at ${Y} or higher.`})}}null==k||k.step("Creating order in database");const V=await(0,queries_1.createOrder)({userId:C.id,symbol:I,amount:(0,blockchain_1.toBigIntFloat)(O),price:(0,blockchain_1.toBigIntFloat)(Y),cost:(0,blockchain_1.toBigIntFloat)(R),type:U,side:q,fee:(0,blockchain_1.toBigIntFloat)(A),feeCurrency:$}),Q={...V,amount:(0,blockchain_1.fromBigInt)(V.amount),price:(0,blockchain_1.fromBigInt)(V.price),cost:(0,blockchain_1.fromBigInt)(V.cost),fee:(0,blockchain_1.fromBigInt)(V.fee),remaining:(0,blockchain_1.fromBigInt)(V.remaining),filled:0,average:0};null==k||k.step("Updating wallet balance");try{if("BUY"===q.toUpperCase()){const e=`eco_order_place_${V.id}_buy_${W.id}`;await(0,wallet_1.updateWalletBalance)(W,Q.cost,"subtract",e)}else{const e=`eco_order_place_${V.id}_sell_${T.id}`;await(0,wallet_1.updateWalletBalance)(T,Q.amount,"subtract",e)}}catch(e){null==k||k.step("Rolling back order due to wallet update failure");await(0,queries_1.rollbackOrderCreation)(V.id,C.id,V.createdAt);null==k||k.fail("Failed to update wallet balance");throw(0,error_1.createError)({statusCode:500,message:"Failed to update wallet balance. Order rolled back."})}null==k||k.step("Adding order to matching engine");await(0,queries_1.addOrderToMatchingQueue)(V);null==k||k.step("Broadcasting order to WebSocket subscribers");await(0,ws_1.handleOrderBroadcast)({...V,status:"OPEN"});try{const{triggerCopyTrading:e}=await Promise.resolve().then(()=>__importStar(require("@b/utils/safe-imports")));e(V.id,C.id,I,q.toUpperCase(),U.toUpperCase(),O,Y).catch(()=>{})}catch(e){}null==k||k.success(`Created ${q} order for ${O} ${B} at ${Y} ${$}`);return{message:"Order created successfully",order:Q}}catch(e){null==k||k.fail(`Order creation failed: ${e.message}`);throw(0,error_1.createError)({statusCode:e.statusCode||400,message:`Failed to create order: ${e.message}`})}};