"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),query_1=require("@b/utils/query"),utils_1=require("../utils");exports.metadata={summary:"Retrieves the user's wishlist",description:"Fetches all items in the user's wishlist, including product details, categories, and reviews.",operationId:"getEcommerceWishlist",tags:["Ecommerce","Wishlist"],logModule:"ECOM",logTitle:"Get Wishlist",responses:{200:{description:"Wishlist retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:utils_1.baseWishlistItemSchema,required:["productId","product"]}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Ecommerce Wishlist"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{const{user:r,ctx:t}=e;null==t||t.step("Fetching Wishlist");if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const s=await db_1.models.ecommerceWishlist.findOne({where:{userId:r.id},include:[{model:db_1.models.ecommerceProduct,as:"products",where:{status:!0},attributes:["id","name","slug","description","shortDescription","type","price","status","image","currency","inventoryQuantity","createdAt"],include:[{model:db_1.models.ecommerceReview,as:"ecommerceReviews",attributes:["id","productId","userId","rating","status","createdAt"]},{model:db_1.models.ecommerceCategory,as:"category",attributes:["slug","name"]}]}],order:[[{model:db_1.models.ecommerceProduct,as:"products"},"name","ASC"]]});if(!s)throw(0,error_1.createError)({statusCode:404,message:"Wishlist not found"});if(0===s.products.length)return[];const i=s.toJSON();try{const e=i.products.map(e=>{var r,t,s;return{...e,rating:(null===(r=e.ecommerceReviews)||void 0===r?void 0:r.length)?e.ecommerceReviews.reduce((e,r)=>e+r.rating,0)/e.ecommerceReviews.length:0,reviewsCount:null!==(s=null===(t=e.ecommerceReviews)||void 0===t?void 0:t.length)&&void 0!==s?s:0}});null==t||t.success("Get Wishlist fetched successfully");return JSON.parse(JSON.stringify(e))}catch(e){throw(0,error_1.createError)({statusCode:500,message:"Error processing wishlist data"})}};