"use strict";async function getLeaderById(e,t=[]){const r=[];t.includes("user")&&r.push({model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","email","avatar"]});t.includes("followers")&&r.push({model:db_1.models.copyTradingFollower,as:"followers",where:{status:"ACTIVE"},required:!1});return db_1.models.copyTradingLeader.findByPk(e,{include:r})}async function getLeaderByUserId(e){return db_1.models.copyTradingLeader.findOne({where:{userId:e},include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","email","avatar"]}]})}async function checkLeaderEligibility(e){var t;const r=await checkPlatformStatus();if(!r.available)return{eligible:!1,reason:r.reason};const a=await db_1.models.copyTradingLeader.findOne({where:{userId:e}});if(a){if("ACTIVE"===a.status)return{eligible:!1,reason:"You are already an active leader"};if("PENDING"===a.status)return{eligible:!1,reason:"Your leader application is pending review"};if("SUSPENDED"===a.status)return{eligible:!1,reason:"Your leader account has been suspended"}}if((await getCopyTradingSettings()).requireKYC){const r=await db_1.models.user.findByPk(e);if(!(null===(t=null==r?void 0:r.kyc)||void 0===t?void 0:t.level)||r.kyc.level<2)return{eligible:!1,reason:"KYC verification is required"}}return{eligible:!0}}async function updateLeaderStats(e){const t=await db_1.models.copyTradingLeader.findByPk(e);if(!t)return;const r=await db_1.models.copyTradingTrade.findAll({where:{leaderId:e,isLeaderTrade:!0,status:"CLOSED"}}),a=r.length,o=r.filter(e=>(e.profit||0)>0).length,n=a>0?o/a*100:0,i=r.reduce((e,t)=>e+(t.profit||0),0),l=r.reduce((e,t)=>e+(t.cost||0),0),c=await db_1.models.copyTradingFollower.count({where:{leaderId:e,status:"ACTIVE"}}),s=l>0?i/l*100:0;await t.update({totalTrades:a,winRate:n,totalProfit:i,totalVolume:l,totalFollowers:c,roi:s})}async function getFollowerById(e,t=[]){const r=[];t.includes("user")&&r.push({model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","email","avatar"]});t.includes("leader")&&r.push({model:db_1.models.copyTradingLeader,as:"leader",include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","avatar"]}]});return db_1.models.copyTradingFollower.findByPk(e,{include:r})}async function getFollowersByUserId(e){return db_1.models.copyTradingFollower.findAll({where:{userId:e},include:[{model:db_1.models.copyTradingLeader,as:"leader",include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","avatar"]}]}]})}async function checkFollowEligibility(e,t){const r=await checkPlatformStatus();if(!r.available)return{eligible:!1,reason:r.reason};const a=await db_1.models.copyTradingLeader.findByPk(t);if(!a)return{eligible:!1,reason:"Leader not found"};if("ACTIVE"!==a.status)return{eligible:!1,reason:"Leader is not active"};if(a.userId===e)return{eligible:!1,reason:"You cannot follow yourself"};if(await db_1.models.copyTradingFollower.findOne({where:{userId:e,leaderId:t,status:{[sequelize_1.Op.ne]:"STOPPED"}}}))return{eligible:!1,reason:"You are already following this leader"};const o=await getCopyTradingSettings();if(await db_1.models.copyTradingFollower.count({where:{leaderId:t,status:"ACTIVE"}})>=Math.min(a.maxFollowers||o.maxFollowersPerLeader,o.maxFollowersPerLeader))return{eligible:!1,reason:"Leader has reached maximum followers"};return await db_1.models.copyTradingFollower.count({where:{userId:e,status:{[sequelize_1.Op.in]:["ACTIVE","PAUSED"]}}})>=o.maxLeadersPerFollower?{eligible:!1,reason:`You can only follow up to ${o.maxLeadersPerFollower} leaders`}:{eligible:!0}}async function updateFollowerStats(e){const t=await db_1.models.copyTradingFollower.findByPk(e);if(!t)return;const r=await db_1.models.copyTradingTrade.findAll({where:{followerId:e,status:"CLOSED"}}),a=r.length,o=r.filter(e=>(e.profit||0)>0).length,n=a>0?o/a*100:0,i=r.reduce((e,t)=>e+(t.profit||0),0);await t.update({totalTrades:a,winRate:n,totalProfit:i})}async function getUserWalletBalance(e,t){var r;if(!t)throw(0,error_1.createError)({statusCode:400,message:"Currency is required for getUserWalletBalance"});const a=await db_1.models.wallet.findOne({where:{userId:e,currency:t,type:"ECO"}});return a?parseFloat((null===(r=a.balance)||void 0===r?void 0:r.toString())||"0"):0}async function createCopyTradingTransaction(e,t){if(!e.currency)throw(0,error_1.createError)({statusCode:400,message:"Currency is required for createCopyTradingTransaction"});return db_1.models.copyTradingTransaction.create({...e,fee:e.fee||0,status:"COMPLETED",metadata:e.metadata?JSON.stringify(e.metadata):null},t?{transaction:t}:void 0)}function parseBool(e,t){return null==e?t:"boolean"==typeof e?e:"string"==typeof e?"true"===e.toLowerCase():Boolean(e)}function parseNum(e,t){if(null==e)return t;const r=Number(e);return isNaN(r)?t:r}async function getCopyTradingSettings(){const e=cache_1.CacheManager.getInstance(),t=await e.getSettings();return{enabled:parseBool(t.get("copyTradingEnabled"),DEFAULT_SETTINGS.enabled),maintenanceMode:parseBool(t.get("copyTradingMaintenanceMode"),DEFAULT_SETTINGS.maintenanceMode),requireKYC:parseBool(t.get("copyTradingRequireKYC"),DEFAULT_SETTINGS.requireKYC),platformFeePercent:parseNum(t.get("copyTradingPlatformFeePercent"),DEFAULT_SETTINGS.platformFeePercent),minLeaderTrades:parseNum(t.get("copyTradingMinLeaderTrades"),DEFAULT_SETTINGS.minLeaderTrades),minLeaderWinRate:parseNum(t.get("copyTradingMinLeaderWinRate"),DEFAULT_SETTINGS.minLeaderWinRate),minLeaderAccountAge:parseNum(t.get("copyTradingMinLeaderAccountAge"),DEFAULT_SETTINGS.minLeaderAccountAge),maxLeadersPerFollower:parseNum(t.get("copyTradingMaxLeadersPerFollower"),DEFAULT_SETTINGS.maxLeadersPerFollower),minAllocationAmount:parseNum(t.get("copyTradingMinAllocationAmount"),DEFAULT_SETTINGS.minAllocationAmount),maxAllocationPercent:parseNum(t.get("copyTradingMaxAllocationPercent"),DEFAULT_SETTINGS.maxAllocationPercent),maxFollowersPerLeader:parseNum(t.get("copyTradingMaxFollowersPerLeader"),DEFAULT_SETTINGS.maxFollowersPerLeader),maxProfitSharePercent:parseNum(t.get("copyTradingMaxProfitSharePercent"),DEFAULT_SETTINGS.maxProfitSharePercent),maxCopyLatencyMs:parseNum(t.get("copyTradingMaxCopyLatencyMs"),DEFAULT_SETTINGS.maxCopyLatencyMs),enableMarketOrders:parseBool(t.get("copyTradingEnableMarketOrders"),DEFAULT_SETTINGS.enableMarketOrders),enableLimitOrders:parseBool(t.get("copyTradingEnableLimitOrders"),DEFAULT_SETTINGS.enableLimitOrders),maxDailyLossDefault:parseNum(t.get("copyTradingMaxDailyLossDefault"),DEFAULT_SETTINGS.maxDailyLossDefault),maxPositionDefault:parseNum(t.get("copyTradingMaxPositionDefault"),DEFAULT_SETTINGS.maxPositionDefault),enableAutoRetry:parseBool(t.get("copyTradingEnableAutoRetry"),DEFAULT_SETTINGS.enableAutoRetry),maxRetryAttempts:parseNum(t.get("copyTradingMaxRetryAttempts"),DEFAULT_SETTINGS.maxRetryAttempts),enableProfitShare:parseBool(t.get("copyTradingEnableProfitShare"),DEFAULT_SETTINGS.enableProfitShare),leaderApplicationRateLimit:parseNum(t.get("copyTradingLeaderApplicationRateLimit"),DEFAULT_SETTINGS.leaderApplicationRateLimit)}}async function checkPlatformStatus(){const e=await getCopyTradingSettings();return e.enabled?e.maintenanceMode?{available:!1,reason:"Copy trading is currently under maintenance"}:{available:!0}:{available:!1,reason:"Copy trading is currently disabled"}}async function createAuditLog(e,t){return db_1.models.copyTradingAuditLog.create({...e,oldValue:e.oldValue?JSON.stringify(e.oldValue):null,newValue:e.newValue?JSON.stringify(e.newValue):null,metadata:e.metadata?JSON.stringify(e.metadata):null},t?{transaction:t}:void 0)}function calculateProfitShare(e,t,r){if(e<=0)return{leaderShare:0,platformFee:0,followerNet:e};const a=e*(r/100),o=e-a,n=o*(t/100);return{leaderShare:n,platformFee:a,followerNet:o-n}}async function getLeaderRankings(e="30d",t=50){const r=await db_1.models.copyTradingLeader.findAll({where:{status:"ACTIVE",isPublic:!0},include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","avatar"]}]}),a=r.map(e=>e.id),o=a.length>0?await(0,stats_calculator_1.calculateBatchLeaderStats)(a):new Map,n=r.map(e=>{const t=o.get(e.id)||{roi:0,winRate:0,totalFollowers:0,totalProfit:0,totalTrades:0,totalVolume:0};return{...e.toJSON(),roi:t.roi,winRate:t.winRate,totalFollowers:t.totalFollowers,totalProfit:t.totalProfit,totalTrades:t.totalTrades,totalVolume:t.totalVolume}});n.sort((e,t)=>t.roi-e.roi);return n.slice(0,t)}Object.defineProperty(exports,"__esModule",{value:!0});exports.copyTradingRateLimiters=exports.calculateRiskAdjustedReturn=exports.calculateAlpha=exports.calculateMonthlyPerformance=exports.calculateDailyReturns=exports.calculatePerformanceMetrics=exports.calculateExpectancy=exports.calculateProfitFactor=exports.calculateRollingVolatility=exports.calculateVolatility=exports.calculateStdDev=exports.calculateCurrentDrawdown=exports.calculateMaxDrawdown=exports.calculateSortinoRatio=exports.calculateSharpeRatio=exports.checkAutoActions=exports.getFollowerLimitStatus=exports.updateFollowerLimits=exports.resetFollowerDailyLimits=exports.recordLoss=exports.recordTrade=exports.getDailyStats=exports.checkDailyLimits=exports.previewProfitShare=exports.getFollowerProfitSharePayments=exports.getLeaderEarnings=exports.processPendingProfitDistributions=exports.calculateProfitShareBreakdown=exports.distributeProfitShare=exports.calculateUnrealizedPnL=exports.calculatePnL=exports.checkSlippageLimit=exports.calculateExpectedSlippage=exports.monitorTradeStopLevels=exports.checkStopLevels=exports.checkPositionSize=exports.cancelCopyOrder=exports.executeOrder=exports.handleOrderFilled=exports.closeLeaderTrade=exports.closeTrade=exports.FillMonitor=exports.calculateFollowerCopyAmount=exports.processCopyOrderWithRetry=exports.processCopyOrdersBatch=exports.processCopyOrder=exports.getLeaderInfo=exports.isActiveLeader=exports.handleOrderCreated=exports.LeaderTradeListener=void 0;exports.notifyCopyTradingAdmins=exports.notifyProfitShareEvent=exports.notifyFollowerRiskEvent=exports.notifyFollowerTradeEvent=exports.notifyFollowerAllocationEvent=exports.notifyFollowerSubscriptionEvent=exports.notifyLeaderFollowerStopped=exports.notifyLeaderNewFollower=exports.notifyLeaderApplicationEvent=exports.throwValidationError=exports.validateSort=exports.validatePagination=exports.validateLeaderUpdate=exports.validateSubscriptionUpdate=exports.validateFundOperation=exports.validateFollowRequest=exports.validateLeaderApplication=exports.validateNumber=exports.sanitizeString=exports.isValidUUID=void 0;exports.getLeaderById=getLeaderById;exports.getLeaderByUserId=getLeaderByUserId;exports.checkLeaderEligibility=checkLeaderEligibility;exports.updateLeaderStats=updateLeaderStats;exports.getFollowerById=getFollowerById;exports.getFollowersByUserId=getFollowersByUserId;exports.checkFollowEligibility=checkFollowEligibility;exports.updateFollowerStats=updateFollowerStats;exports.getUserWalletBalance=getUserWalletBalance;exports.createCopyTradingTransaction=createCopyTradingTransaction;exports.getCopyTradingSettings=getCopyTradingSettings;exports.checkPlatformStatus=checkPlatformStatus;exports.createAuditLog=createAuditLog;exports.calculateProfitShare=calculateProfitShare;exports.getLeaderRankings=getLeaderRankings;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize"),cache_1=require("@b/utils/cache"),stats_calculator_1=require("./stats-calculator"),DEFAULT_SETTINGS={enabled:!0,maintenanceMode:!1,requireKYC:!1,platformFeePercent:2,minLeaderTrades:10,minLeaderWinRate:50,minLeaderAccountAge:30,maxLeadersPerFollower:10,minAllocationAmount:50,maxAllocationPercent:50,maxFollowersPerLeader:1e3,maxProfitSharePercent:50,maxCopyLatencyMs:5e3,enableMarketOrders:!0,enableLimitOrders:!0,maxDailyLossDefault:20,maxPositionDefault:20,enableAutoRetry:!0,maxRetryAttempts:3,enableProfitShare:!0,leaderApplicationRateLimit:10};var tradeListener_1=require("./tradeListener");Object.defineProperty(exports,"LeaderTradeListener",{enumerable:!0,get:function(){return tradeListener_1.LeaderTradeListener}});Object.defineProperty(exports,"handleOrderCreated",{enumerable:!0,get:function(){return tradeListener_1.handleOrderCreated}});Object.defineProperty(exports,"isActiveLeader",{enumerable:!0,get:function(){return tradeListener_1.isActiveLeader}});Object.defineProperty(exports,"getLeaderInfo",{enumerable:!0,get:function(){return tradeListener_1.getLeaderInfo}});var copyProcessor_1=require("./copyProcessor");Object.defineProperty(exports,"processCopyOrder",{enumerable:!0,get:function(){return copyProcessor_1.processCopyOrder}});Object.defineProperty(exports,"processCopyOrdersBatch",{enumerable:!0,get:function(){return copyProcessor_1.processCopyOrdersBatch}});Object.defineProperty(exports,"processCopyOrderWithRetry",{enumerable:!0,get:function(){return copyProcessor_1.processCopyOrderWithRetry}});Object.defineProperty(exports,"calculateFollowerCopyAmount",{enumerable:!0,get:function(){return copyProcessor_1.calculateCopyAmount}});var fillMonitor_1=require("./fillMonitor");Object.defineProperty(exports,"FillMonitor",{enumerable:!0,get:function(){return fillMonitor_1.FillMonitor}});Object.defineProperty(exports,"closeTrade",{enumerable:!0,get:function(){return fillMonitor_1.closeTrade}});Object.defineProperty(exports,"closeLeaderTrade",{enumerable:!0,get:function(){return fillMonitor_1.closeLeaderTrade}});Object.defineProperty(exports,"handleOrderFilled",{enumerable:!0,get:function(){return fillMonitor_1.handleOrderFilled}});var execution_1=require("./execution");Object.defineProperty(exports,"executeOrder",{enumerable:!0,get:function(){return execution_1.executeOrder}});Object.defineProperty(exports,"cancelCopyOrder",{enumerable:!0,get:function(){return execution_1.cancelCopyOrder}});Object.defineProperty(exports,"checkPositionSize",{enumerable:!0,get:function(){return execution_1.checkPositionSize}});Object.defineProperty(exports,"checkStopLevels",{enumerable:!0,get:function(){return execution_1.checkStopLevels}});Object.defineProperty(exports,"monitorTradeStopLevels",{enumerable:!0,get:function(){return execution_1.monitorStopLevels}});Object.defineProperty(exports,"calculateExpectedSlippage",{enumerable:!0,get:function(){return execution_1.calculateExpectedSlippage}});Object.defineProperty(exports,"checkSlippageLimit",{enumerable:!0,get:function(){return execution_1.checkSlippageLimit}});var profitShare_1=require("./profitShare");Object.defineProperty(exports,"calculatePnL",{enumerable:!0,get:function(){return profitShare_1.calculatePnL}});Object.defineProperty(exports,"calculateUnrealizedPnL",{enumerable:!0,get:function(){return profitShare_1.calculateUnrealizedPnL}});Object.defineProperty(exports,"distributeProfitShare",{enumerable:!0,get:function(){return profitShare_1.distributeProfitShare}});Object.defineProperty(exports,"calculateProfitShareBreakdown",{enumerable:!0,get:function(){return profitShare_1.calculateProfitShareBreakdown}});Object.defineProperty(exports,"processPendingProfitDistributions",{enumerable:!0,get:function(){return profitShare_1.processPendingProfitDistributions}});Object.defineProperty(exports,"getLeaderEarnings",{enumerable:!0,get:function(){return profitShare_1.getLeaderEarnings}});Object.defineProperty(exports,"getFollowerProfitSharePayments",{enumerable:!0,get:function(){return profitShare_1.getFollowerProfitSharePayments}});Object.defineProperty(exports,"previewProfitShare",{enumerable:!0,get:function(){return profitShare_1.previewProfitShare}});var dailyLimits_1=require("./dailyLimits");Object.defineProperty(exports,"checkDailyLimits",{enumerable:!0,get:function(){return dailyLimits_1.checkDailyLimits}});Object.defineProperty(exports,"getDailyStats",{enumerable:!0,get:function(){return dailyLimits_1.getDailyStats}});Object.defineProperty(exports,"recordTrade",{enumerable:!0,get:function(){return dailyLimits_1.recordTrade}});Object.defineProperty(exports,"recordLoss",{enumerable:!0,get:function(){return dailyLimits_1.recordLoss}});Object.defineProperty(exports,"resetFollowerDailyLimits",{enumerable:!0,get:function(){return dailyLimits_1.resetDailyLimits}});Object.defineProperty(exports,"updateFollowerLimits",{enumerable:!0,get:function(){return dailyLimits_1.updateFollowerLimits}});Object.defineProperty(exports,"getFollowerLimitStatus",{enumerable:!0,get:function(){return dailyLimits_1.getFollowerLimitStatus}});Object.defineProperty(exports,"checkAutoActions",{enumerable:!0,get:function(){return dailyLimits_1.checkAutoActions}});var calculations_1=require("./calculations");Object.defineProperty(exports,"calculateSharpeRatio",{enumerable:!0,get:function(){return calculations_1.calculateSharpeRatio}});Object.defineProperty(exports,"calculateSortinoRatio",{enumerable:!0,get:function(){return calculations_1.calculateSortinoRatio}});Object.defineProperty(exports,"calculateMaxDrawdown",{enumerable:!0,get:function(){return calculations_1.calculateMaxDrawdown}});Object.defineProperty(exports,"calculateCurrentDrawdown",{enumerable:!0,get:function(){return calculations_1.calculateCurrentDrawdown}});Object.defineProperty(exports,"calculateStdDev",{enumerable:!0,get:function(){return calculations_1.calculateStdDev}});Object.defineProperty(exports,"calculateVolatility",{enumerable:!0,get:function(){return calculations_1.calculateVolatility}});Object.defineProperty(exports,"calculateRollingVolatility",{enumerable:!0,get:function(){return calculations_1.calculateRollingVolatility}});Object.defineProperty(exports,"calculateProfitFactor",{enumerable:!0,get:function(){return calculations_1.calculateProfitFactor}});Object.defineProperty(exports,"calculateExpectancy",{enumerable:!0,get:function(){return calculations_1.calculateExpectancy}});Object.defineProperty(exports,"calculatePerformanceMetrics",{enumerable:!0,get:function(){return calculations_1.calculatePerformanceMetrics}});Object.defineProperty(exports,"calculateDailyReturns",{enumerable:!0,get:function(){return calculations_1.calculateDailyReturns}});Object.defineProperty(exports,"calculateMonthlyPerformance",{enumerable:!0,get:function(){return calculations_1.calculateMonthlyPerformance}});Object.defineProperty(exports,"calculateAlpha",{enumerable:!0,get:function(){return calculations_1.calculateAlpha}});Object.defineProperty(exports,"calculateRiskAdjustedReturn",{enumerable:!0,get:function(){return calculations_1.calculateRiskAdjustedReturn}});var security_1=require("./security");Object.defineProperty(exports,"copyTradingRateLimiters",{enumerable:!0,get:function(){return security_1.copyTradingRateLimiters}});Object.defineProperty(exports,"isValidUUID",{enumerable:!0,get:function(){return security_1.isValidUUID}});Object.defineProperty(exports,"sanitizeString",{enumerable:!0,get:function(){return security_1.sanitizeString}});Object.defineProperty(exports,"validateNumber",{enumerable:!0,get:function(){return security_1.validateNumber}});Object.defineProperty(exports,"validateLeaderApplication",{enumerable:!0,get:function(){return security_1.validateLeaderApplication}});Object.defineProperty(exports,"validateFollowRequest",{enumerable:!0,get:function(){return security_1.validateFollowRequest}});Object.defineProperty(exports,"validateFundOperation",{enumerable:!0,get:function(){return security_1.validateFundOperation}});Object.defineProperty(exports,"validateSubscriptionUpdate",{enumerable:!0,get:function(){return security_1.validateSubscriptionUpdate}});Object.defineProperty(exports,"validateLeaderUpdate",{enumerable:!0,get:function(){return security_1.validateLeaderUpdate}});Object.defineProperty(exports,"validatePagination",{enumerable:!0,get:function(){return security_1.validatePagination}});Object.defineProperty(exports,"validateSort",{enumerable:!0,get:function(){return security_1.validateSort}});Object.defineProperty(exports,"throwValidationError",{enumerable:!0,get:function(){return security_1.throwValidationError}});var notifications_1=require("./notifications");Object.defineProperty(exports,"notifyLeaderApplicationEvent",{enumerable:!0,get:function(){return notifications_1.notifyLeaderApplicationEvent}});Object.defineProperty(exports,"notifyLeaderNewFollower",{enumerable:!0,get:function(){return notifications_1.notifyLeaderNewFollower}});Object.defineProperty(exports,"notifyLeaderFollowerStopped",{enumerable:!0,get:function(){return notifications_1.notifyLeaderFollowerStopped}});Object.defineProperty(exports,"notifyFollowerSubscriptionEvent",{enumerable:!0,get:function(){return notifications_1.notifyFollowerSubscriptionEvent}});Object.defineProperty(exports,"notifyFollowerAllocationEvent",{enumerable:!0,get:function(){return notifications_1.notifyFollowerAllocationEvent}});Object.defineProperty(exports,"notifyFollowerTradeEvent",{enumerable:!0,get:function(){return notifications_1.notifyFollowerTradeEvent}});Object.defineProperty(exports,"notifyFollowerRiskEvent",{enumerable:!0,get:function(){return notifications_1.notifyFollowerRiskEvent}});Object.defineProperty(exports,"notifyProfitShareEvent",{enumerable:!0,get:function(){return notifications_1.notifyProfitShareEvent}});Object.defineProperty(exports,"notifyCopyTradingAdmins",{enumerable:!0,get:function(){return notifications_1.notifyCopyTradingAdmins}});