"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize");exports.metadata={summary:"Get My Copy Trades",description:"Retrieves the user's copy trading trade history with filtering and pagination.",operationId:"getMyCopyTrades",tags:["Copy Trading","Trades"],requiresAuth:!0,logModule:"COPY",logTitle:"Get my trades",parameters:[{name:"followerId",in:"query",required:!1,schema:{type:"string"},description:"Filter by subscription/follower ID"},{name:"leaderId",in:"query",required:!1,schema:{type:"string"},description:"Filter by leader ID"},{name:"symbol",in:"query",required:!1,schema:{type:"string"},description:"Filter by trading pair symbol"},{name:"status",in:"query",required:!1,schema:{type:"string",enum:["PENDING","EXECUTED","PARTIAL","CANCELLED","FAILED","CLOSED"]},description:"Filter by trade status"},{name:"side",in:"query",required:!1,schema:{type:"string",enum:["BUY","SELL"]},description:"Filter by trade side"},{name:"dateFrom",in:"query",required:!1,schema:{type:"string",format:"date"},description:"Filter trades from this date"},{name:"dateTo",in:"query",required:!1,schema:{type:"string",format:"date"},description:"Filter trades until this date"},{name:"page",in:"query",required:!1,schema:{type:"integer",default:1},description:"Page number"},{name:"limit",in:"query",required:!1,schema:{type:"integer",default:20},description:"Items per page"}],responses:{200:{description:"Trades retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{items:{type:"array"},pagination:{type:"object",properties:{total:{type:"number"},page:{type:"number"},limit:{type:"number"},totalPages:{type:"number"}}},summary:{type:"object",properties:{totalTrades:{type:"number"},totalProfit:{type:"number"},winRate:{type:"number"}}}}}}}},401:{description:"Unauthorized"},500:{description:"Internal Server Error"}}};exports.default=async e=>{const{user:t,query:r,ctx:i}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==i||i.step("Fetching user followers");const a=(await db_1.models.copyTradingFollower.findAll({where:{userId:t.id},attributes:["id","leaderId"]})).map(e=>e.id);if(0===a.length)return{items:[],pagination:{total:0,page:1,limit:20,totalPages:0},summary:{totalTrades:0,totalProfit:0,winRate:0}};const s={followerId:{[sequelize_1.Op.in]:a}};if(r.followerId){if(!a.includes(r.followerId))throw(0,error_1.createError)({statusCode:403,message:"Access denied to this subscription"});s.followerId=r.followerId}r.leaderId&&(s.leaderId=r.leaderId);r.symbol&&(s.symbol=r.symbol);r.status&&(s.status=r.status);r.side&&(s.side=r.side);if(r.dateFrom||r.dateTo){s.createdAt={};r.dateFrom&&(s.createdAt[sequelize_1.Op.gte]=new Date(r.dateFrom));r.dateTo&&(s.createdAt[sequelize_1.Op.lte]=new Date(r.dateTo+"T23:59:59.999Z"))}const o=parseInt(r.page)||1,d=Math.min(parseInt(r.limit)||20,100),n=(o-1)*d;null==i||i.step("Fetching trades");const{count:l,rows:u}=await db_1.models.copyTradingTrade.findAndCountAll({where:s,include:[{model:db_1.models.copyTradingLeader,as:"leader",attributes:["id","displayName"],include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","avatar"]}]},{model:db_1.models.copyTradingFollower,as:"follower",attributes:["id","copyMode","fixedAmount","fixedRatio"]}],order:[["createdAt","DESC"]],limit:d,offset:n});null==i||i.step("Calculating summary");const p=await db_1.models.copyTradingTrade.findAll({where:{followerId:{[sequelize_1.Op.in]:a},status:"CLOSED"},attributes:["profit"]}),m=p.length,c=p.filter(e=>(e.profit||0)>0).length,y=p.reduce((e,t)=>e+(t.profit||0),0),g=m>0?c/m*100:0;null==i||i.success(`Found ${l} trades`);return{items:u.map(e=>e.toJSON()),pagination:{total:l,page:o,limit:d,totalPages:Math.ceil(l/d)},summary:{totalTrades:m,totalProfit:Math.round(100*y)/100,winRate:Math.round(100*g)/100}}};