"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error");exports.metadata={summary:"Get leader's declared markets",description:"Returns all markets the authenticated leader has declared for trading with follower counts",operationId:"getLeaderMarkets",tags:["Copy Trading","Leader"],requiresAuth:!0,logModule:"COPY",logTitle:"Get leader markets",responses:{200:{description:"Markets retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{id:{type:"string"},symbol:{type:"string"},baseCurrency:{type:"string"},quoteCurrency:{type:"string"},isActive:{type:"boolean"},followerCount:{type:"number"},createdAt:{type:"string"}}}}}}},401:{description:"Unauthorized"},404:{description:"Leader profile not found"}}};exports.default=async e=>{const{user:r,ctx:t}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==t||t.step("Finding leader profile");const o=await db_1.models.copyTradingLeader.findOne({where:{userId:r.id}});if(!o)throw(0,error_1.createError)({statusCode:404,message:"Leader profile not found"});const s=o.id;null==t||t.step("Fetching leader markets");const a=await db_1.models.copyTradingLeaderMarket.findAll({where:{leaderId:s},order:[["createdAt","ASC"]]});null==t||t.step("Fetching follower counts per market");const l=await db_1.models.copyTradingFollowerAllocation.findAll({attributes:["symbol",[db_1.sequelize.fn("COUNT",db_1.sequelize.fn("DISTINCT",db_1.sequelize.col("copyTradingFollowerAllocation.followerId"))),"count"]],where:{isActive:!0},include:[{model:db_1.models.copyTradingFollower,as:"follower",where:{leaderId:s},attributes:[]}],group:["symbol"],raw:!0}),d=new Map(l.map(e=>[e.symbol,parseInt(e.count,10)])),n=a.map(e=>{const r=e.toJSON();r.followerCount=d.get(r.symbol)||0;return r});null==t||t.success(`Retrieved ${a.length} markets`);return n};